/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.ide.DataManager;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolEditorDialogPanel;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolEditorDialog
extends DialogWrapper {
    static final Function<String, List<String>> OUTPUT_FILTERS_SPLITTER = s -> StringUtil.split(s, "\u23ce");
    static final Function<List<String>, String> OUTPUT_FILTERS_JOINER = strings2 -> StringUtil.join(strings2, "\u23ce");
    private final Project myProject;
    private boolean myEnabled;
    private final ToolEditorDialogPanel content = new ToolEditorDialogPanel();

    protected ToolEditorDialog(JComponent parent2, @NlsContexts.DialogTitle String title) {
        super((Component)parent2, true);
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)parent2);
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        MacroManager.getInstance().cacheMacrosPreview(dataContext2);
        this.setTitle(title);
        this.init();
        this.addListeners();
    }

    protected String getHelpId() {
        return "preferences.externalToolsEdit";
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        this.fillAdditionalOptionsPanel(this.content.additionalOptionsPanel);
        DialogPanel dialogPanel = this.content.panel;
        if (dialogPanel == null) {
            ToolEditorDialog.$$$reportNull$$$0(0);
        }
        return dialogPanel;
    }

    protected void fillAdditionalOptionsPanel(@NotNull JPanel panel2) {
        if (panel2 == null) {
            ToolEditorDialog.$$$reportNull$$$0(1);
        }
    }

    protected void addWorkingDirectoryBrowseAction(@NotNull TextFieldWithBrowseButton workingDirField) {
        if (workingDirField == null) {
            ToolEditorDialog.$$$reportNull$$$0(2);
        }
        workingDirField.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
    }

    protected void addProgramBrowseAction(@NotNull TextFieldWithBrowseButton programField) {
        if (programField == null) {
            ToolEditorDialog.$$$reportNull$$$0(3);
        }
        programField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor(), this.myProject){

            protected void onFileChosen(@NotNull VirtualFile file2) {
                VirtualFile parent2;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onFileChosen(file2);
                String workingDirectory = ToolEditorDialog.this.content.workingDirField.getText();
                if (workingDirectory.isEmpty() && (parent2 = file2.getParent()) != null && parent2.isDirectory()) {
                    ToolEditorDialog.this.content.workingDirField.setText(parent2.getPresentableUrl());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tools/ToolEditorDialog$1", "onFileChosen"));
            }
        });
    }

    private void addListeners() {
        this.addProgramBrowseAction(this.content.programField);
        this.addWorkingDirectoryBrowseAction(this.content.workingDirField);
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.programField.getTextField()));
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.argumentsField.getTextField()));
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.workingDirField.getTextField()));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.content.nameField.getText().trim().isEmpty()) {
            return new ValidationInfo(ToolsBundle.message("dialog.message.specify.the.tool.name", new Object[0]), (JComponent)this.content.nameField);
        }
        for (String s : OUTPUT_FILTERS_SPLITTER.fun(this.content.outputFilterField.getText())) {
            if (s.contains("$FILE_PATH$")) continue;
            return new ValidationInfo(ToolsBundle.message("dialog.message.each.output.filter.must.contain.0.macro", "$FILE_PATH$"), (JComponent)this.content.outputFilterField);
        }
        return null;
    }

    public Tool getData() {
        Tool tool = this.createTool();
        tool.setName(ToolEditorDialog.convertString(this.content.nameField.getText()));
        tool.setDescription(ToolEditorDialog.convertString(this.content.descriptionField.getText()));
        Object selectedItem = this.content.groupCombo.getSelectedItem();
        tool.setGroup(StringUtil.notNullize(selectedItem != null ? ToolEditorDialog.convertString(selectedItem.toString()) : ""));
        tool.setUseConsole(this.content.useConsoleCheckbox.isSelected());
        tool.setShowConsoleOnStdOut(this.content.showConsoleOnStdOutCheckbox.isSelected());
        tool.setShowConsoleOnStdErr(this.content.showConsoleOnStdErrCheckbox.isSelected());
        tool.setFilesSynchronizedAfterRun(this.content.synchronizedAfterRunCheckbox.isSelected());
        tool.setEnabled(this.myEnabled);
        tool.setWorkingDirectory(StringUtil.nullize(FileUtil.toSystemIndependentName(this.content.workingDirField.getText())));
        tool.setProgram(ToolEditorDialog.convertString(this.content.programField.getText()));
        tool.setParameters(ToolEditorDialog.convertString(this.content.argumentsField.getText()));
        List<String> filterStrings = OUTPUT_FILTERS_SPLITTER.fun(this.content.outputFilterField.getText().trim());
        FilterInfo[] filters = ContainerUtil.map2Array(filterStrings, FilterInfo.class, s -> new FilterInfo((String)s, "", ""));
        tool.setOutputFilters(filters);
        return tool;
    }

    protected Tool createTool() {
        return new Tool();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.tools.ToolEditorDialog";
    }

    protected void setData(Tool tool, String @Nls [] existingGroups) {
        this.content.nameField.setText(tool.getName());
        this.content.descriptionField.setText(tool.getDescription());
        if (this.content.groupCombo.getItemCount() > 0) {
            this.content.groupCombo.removeAllItems();
        }
        for (String existingGroup : existingGroups) {
            if (existingGroup == null) continue;
            this.content.groupCombo.addItem((Object)existingGroup);
        }
        this.content.groupCombo.setSelectedItem((Object)tool.getGroup());
        this.content.useConsoleCheckbox.setSelected(tool.isUseConsole());
        this.content.showConsoleOnStdOutCheckbox.setEnabled(this.content.useConsoleCheckbox.isSelected());
        this.content.showConsoleOnStdOutCheckbox.setSelected(tool.isShowConsoleOnStdOut());
        this.content.showConsoleOnStdErrCheckbox.setEnabled(this.content.useConsoleCheckbox.isSelected());
        this.content.showConsoleOnStdErrCheckbox.setSelected(tool.isShowConsoleOnStdErr());
        this.content.synchronizedAfterRunCheckbox.setSelected(tool.synchronizeAfterExecution());
        this.myEnabled = tool.isEnabled();
        this.content.workingDirField.setText(FileUtil.toSystemDependentName(StringUtil.notNullize(tool.getWorkingDirectory())));
        this.content.programField.setText(tool.getProgram());
        this.content.argumentsField.setText(tool.getParameters());
        this.content.outputFilterField.setText(OUTPUT_FILTERS_JOINER.fun(ContainerUtil.map(tool.getOutputFilters(), info2 -> info2.getRegExp())));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.content.panel.getPreferredFocusedComponent();
    }

    private static String convertString(String s) {
        if (s != null && s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolEditorDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolEditorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillAdditionalOptionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addWorkingDirectoryBrowseAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addProgramBrowseAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

