/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.tools.ToolsBundle;
import org.jetbrains.annotations.NotNull;

public class ToolProcessAdapter
extends ProcessAdapter {
    private final Project myProject;
    private final boolean mySynchronizeAfterExecution;
    private final String myName;

    public ToolProcessAdapter(@NotNull Project project2, boolean synchronizeAfterExecution, @NotNull String name) {
        if (project2 == null) {
            ToolProcessAdapter.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ToolProcessAdapter.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.mySynchronizeAfterExecution = synchronizeAfterExecution;
        this.myName = name;
    }

    @Override
    public void processTerminated(@NotNull ProcessEvent event) {
        StatusBar statusBar;
        if (event == null) {
            ToolProcessAdapter.$$$reportNull$$$0(2);
        }
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject) && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
            statusBar.setInfo(ToolsBundle.message("tools.completed.message", this.myName, event.getExitCode()));
        }
        if (this.mySynchronizeAfterExecution) {
            SaveAndSyncHandler.getInstance().scheduleRefresh();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/tools/ToolProcessAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

