/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.paint.LinePainter2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;

public class ColoredSideBorder
implements Border {
    private final Color myLeftColor;
    private final Color myRightColor;
    private final Color myTopColor;
    private final Color myBottomColor;
    private final int myThickness;

    public ColoredSideBorder(Color topColor, Color leftColor, Color bottomColor, Color rightColor, int thickness) {
        this.myTopColor = topColor;
        this.myLeftColor = leftColor;
        this.myRightColor = rightColor;
        this.myBottomColor = bottomColor;
        this.myThickness = thickness;
    }

    @Override
    public Insets getBorderInsets(Component component2) {
        return new Insets(this.myTopColor != null ? this.getThickness() : 0, this.myLeftColor != null ? this.getThickness() : 0, this.myBottomColor != null ? this.getThickness() : 0, this.myRightColor != null ? this.getThickness() : 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        for (int i2 = 0; i2 < this.getThickness(); ++i2) {
            if (this.myLeftColor != null) {
                g.setColor(this.myLeftColor);
                LinePainter2D.paint((Graphics2D)g, x + i2, y + i2, (double)(x + i2), height - i2 - i2 - 1);
            }
            if (this.myTopColor != null) {
                g.setColor(this.myTopColor);
                LinePainter2D.paint((Graphics2D)g, x + i2, y + i2, (double)(width - i2 - i2 - 1), y + i2);
            }
            if (this.myRightColor != null) {
                g.setColor(this.myRightColor);
                LinePainter2D.paint((Graphics2D)g, width - i2 - i2 - 1, y + i2, (double)(width - i2 - i2 - 1), height - i2 - i2 - 1);
            }
            if (this.myBottomColor == null) continue;
            g.setColor(this.myBottomColor);
            LinePainter2D.paint((Graphics2D)g, x + i2, height - i2 - i2 - 1, (double)(width - i2 - i2 - 1), height - i2 - i2 - 1);
        }
        g.setColor(oldColor);
    }

    public int getThickness() {
        return this.myThickness;
    }
}

