/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.DeferredIconRepaintScheduler;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.IconReplacer;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.UpdatableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DeferredIconImpl<T>
extends JBScalableIcon
implements DeferredIcon,
RetrievableIcon,
IconWithToolTip,
CopyableIcon {
    private static final Logger LOG = Logger.getInstance(DeferredIconImpl.class);
    private static final int MIN_AUTO_UPDATE_MILLIS = 950;
    private static final DeferredIconRepaintScheduler ourRepaintScheduler = new DeferredIconRepaintScheduler();
    @NotNull
    private final Icon myDelegateIcon;
    @NotNull
    private volatile Icon myScaledDelegateIcon;
    private DeferredIconImpl<T> myScaledIconCache;
    private Function<? super T, ? extends Icon> myEvaluator;
    private Set<DeferredIconRepaintScheduler.RepaintRequest> myScheduledRepaints;
    private volatile boolean myIsScheduled;
    final T myParam;
    private static final Icon EMPTY_ICON = EmptyIcon.create(16).withIconPreScaled(false);
    private final boolean myNeedReadAction;
    private boolean myDone;
    private long myLastCalcTime;
    private long myLastTimeSpent;
    private AtomicLong myModificationCount;
    private static final ExecutorService ourIconCalculatingExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("IconCalculating Pool", 1);
    @Nullable
    private final BiConsumer<? super DeferredIcon, ? super Icon> myEvalListener;

    private DeferredIconImpl(@NotNull DeferredIconImpl<T> icon2) {
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(0);
        }
        super(icon2);
        this.myModificationCount = new AtomicLong(0L);
        this.myDelegateIcon = icon2.myDelegateIcon;
        this.myScaledDelegateIcon = icon2.myDelegateIcon;
        this.myScaledIconCache = null;
        this.myEvaluator = icon2.myEvaluator;
        this.myIsScheduled = icon2.myIsScheduled;
        this.myParam = icon2.myParam;
        this.myNeedReadAction = icon2.myNeedReadAction;
        this.myDone = icon2.myDone;
        this.myLastCalcTime = icon2.myLastCalcTime;
        this.myLastTimeSpent = icon2.myLastTimeSpent;
        this.myEvalListener = icon2.myEvalListener;
        this.myModificationCount = icon2.myModificationCount;
    }

    DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull Function<? super T, ? extends Icon> evaluator, @Nullable BiConsumer<? super DeferredIcon, ? super Icon> listener2) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(1);
        }
        this.myModificationCount = new AtomicLong(0L);
        this.myParam = param;
        this.myScaledDelegateIcon = this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myScaledIconCache = null;
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
        this.myEvalListener = listener2;
        this.checkDelegationDepth();
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, @NotNull com.intellij.util.Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(2);
        }
        this(baseIcon, param, needReadAction, t -> (Icon)evaluator.fun((Object)t), null);
    }

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Override
    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer2) {
        if (replacer2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(3);
        }
        return new DeferredIconAfterReplace(this, replacer2);
    }

    @Override
    @NotNull
    public DeferredIconImpl<T> copy() {
        return new DeferredIconImpl<T>(this);
    }

    @Override
    @NotNull
    public DeferredIconImpl<T> scale(float scale) {
        if (this.getScale() == scale) {
            DeferredIconImpl deferredIconImpl = this;
            if (deferredIconImpl == null) {
                DeferredIconImpl.$$$reportNull$$$0(4);
            }
            return deferredIconImpl;
        }
        DeferredIconImpl<T> icon2 = this.myScaledIconCache;
        if (icon2 == null || icon2.getScale() != scale) {
            icon2 = new DeferredIconImpl<T>(this);
            icon2.setScale(ScaleType.OBJ_SCALE.of(scale));
            this.myScaledIconCache = icon2;
        }
        icon2.myScaledDelegateIcon = IconUtil.scale((Icon)icon2.myDelegateIcon, null, (float)scale);
        DeferredIconImpl<T> deferredIconImpl = icon2;
        if (deferredIconImpl == null) {
            DeferredIconImpl.$$$reportNull$$$0(5);
        }
        return deferredIconImpl;
    }

    @NotNull
    public static <T> DeferredIcon withoutReadAction(Icon baseIcon, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            DeferredIconImpl.$$$reportNull$$$0(6);
        }
        return new DeferredIconImpl<T>(baseIcon, param, false, evaluator, (BiConsumer<DeferredIcon, Icon>)null);
    }

    @NotNull
    public Icon getBaseIcon() {
        Icon icon2 = this.myDelegateIcon;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(7);
        }
        return icon2;
    }

    private void checkDelegationDepth() {
        int depth;
        DeferredIconImpl each = this;
        for (depth = 0; each.myScaledDelegateIcon instanceof DeferredIconImpl && depth < 50; ++depth) {
            each = (DeferredIconImpl)each.myScaledDelegateIcon;
        }
        if (depth >= 50) {
            LOG.error("Too deep deferred icon nesting");
        }
    }

    @NotNull
    private static Icon nonNull(@Nullable Icon icon2) {
        Icon icon3 = icon2 == null ? EMPTY_ICON : icon2;
        if (icon3 == null) {
            DeferredIconImpl.$$$reportNull$$$0(8);
        }
        return icon3;
    }

    @Override
    public void paintIcon(Component c2, @NotNull Graphics g, int x, int y) {
        Icon scaledDelegateIcon;
        if (g == null) {
            DeferredIconImpl.$$$reportNull$$$0(9);
        }
        if (!((scaledDelegateIcon = this.myScaledDelegateIcon) instanceof DeferredIconImpl) || !(((DeferredIconImpl)scaledDelegateIcon).myScaledDelegateIcon instanceof DeferredIconImpl)) {
            scaledDelegateIcon.paintIcon(c2, g, x, y);
        }
        if (this.needScheduleEvaluation()) {
            this.scheduleEvaluation(c2, x, y);
        }
    }

    public void notifyPaint(@NotNull Component c2, int x, int y) {
        if (c2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(10);
        }
        if (this.needScheduleEvaluation()) {
            this.scheduleEvaluation(c2, x, y);
        }
    }

    private boolean needScheduleEvaluation() {
        return !this.isDone() && !PowerSaveMode.isEnabled();
    }

    @VisibleForTesting
    Future<?> scheduleEvaluation(Component c2, int x, int y) {
        DeferredIconRepaintScheduler.RepaintRequest repaintRequest = ourRepaintScheduler.createRepaintRequest(c2, x, y);
        AppUIUtil.invokeOnEdt(() -> {
            if (this.isDone()) {
                return;
            }
            if (this.myScheduledRepaints == null) {
                this.myScheduledRepaints = Collections.singleton(repaintRequest);
            } else if (!this.myScheduledRepaints.contains(repaintRequest)) {
                if (this.myScheduledRepaints.size() == 1) {
                    this.myScheduledRepaints = new HashSet<DeferredIconRepaintScheduler.RepaintRequest>(this.myScheduledRepaints);
                }
                this.myScheduledRepaints.add(repaintRequest);
            }
        });
        if (this.myIsScheduled) {
            return null;
        }
        this.myIsScheduled = true;
        return ourIconCalculatingExecutor.submit(() -> {
            int oldWidth = this.myScaledDelegateIcon.getIconWidth();
            Icon[] evaluated = new Icon[1];
            boolean success = true;
            if (this.myNeedReadAction) {
                success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> IconDeferrerImpl.evaluateDeferred(() -> {
                    evaluated[0] = this.evaluate();
                }));
            } else {
                IconDeferrerImpl.evaluateDeferred(() -> {
                    evaluated[0] = this.evaluate();
                });
            }
            Icon result2 = evaluated[0];
            if (!success || result2 == null) {
                this.myIsScheduled = false;
                EdtScheduledExecutorService.getInstance().schedule(() -> {
                    if (this.needScheduleEvaluation()) {
                        this.scheduleEvaluation(c2, x, y);
                    }
                }, 950L, TimeUnit.MILLISECONDS);
                return;
            }
            this.myScaledDelegateIcon = result2;
            this.myModificationCount.incrementAndGet();
            this.checkDelegationDepth();
            this.processRepaints(oldWidth, result2);
        });
    }

    private void processRepaints(int oldWidth, Icon result2) {
        boolean shouldRevalidate = Registry.is("ide.tree.deferred.icon.invalidates.cache") && this.myScaledDelegateIcon.getIconWidth() != oldWidth;
        ApplicationManager.getApplication().invokeLater(() -> {
            Set<DeferredIconRepaintScheduler.RepaintRequest> repaints = this.myScheduledRepaints;
            this.setDone(result2);
            if (DeferredIconImpl.equalIcons(result2, this.myDelegateIcon)) {
                return;
            }
            for (DeferredIconRepaintScheduler.RepaintRequest repaintRequest : repaints) {
                Component actualTarget = repaintRequest.getActualTarget();
                if (actualTarget == null) continue;
                if (shouldRevalidate && actualTarget instanceof JTree) {
                    TreeUtil.invalidateCacheAndRepaint((TreeUI)((JTree)actualTarget).getUI());
                }
                ourRepaintScheduler.scheduleRepaint(repaintRequest, this.getIconWidth(), this.getIconHeight(), false);
            }
        }, ModalityState.any());
    }

    private void setDone(@NotNull Icon result2) {
        if (result2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(11);
        }
        if (this.myEvalListener != null) {
            this.myEvalListener.accept(this, result2);
        }
        this.myDone = true;
        this.myEvaluator = null;
        this.myScheduledRepaints = null;
    }

    @Override
    @NotNull
    public Icon retrieveIcon() {
        if (this.isDone()) {
            Icon icon2 = this.myScaledDelegateIcon;
            if (icon2 == null) {
                DeferredIconImpl.$$$reportNull$$$0(12);
            }
            return icon2;
        }
        if (EDT.isCurrentThreadEdt()) {
            Icon icon3 = this.myScaledDelegateIcon;
            if (icon3 == null) {
                DeferredIconImpl.$$$reportNull$$$0(13);
            }
            return icon3;
        }
        Icon icon4 = this.evaluate();
        if (icon4 == null) {
            DeferredIconImpl.$$$reportNull$$$0(14);
        }
        return icon4;
    }

    public boolean isNeedReadAction() {
        return this.myNeedReadAction;
    }

    @NotNull
    public Icon evaluate() {
        Icon result2;
        try (AccessToken ignored = ClientId.withClientId((ClientId)null);){
            result2 = DeferredIconImpl.nonNull(this.myEvaluator.apply(this.myParam));
        }
        catch (IndexNotReadyException e) {
            result2 = EMPTY_ICON;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.checkDoesntReferenceThis(result2);
        }
        if (this.getScale() != 1.0f && result2 instanceof ScalableIcon) {
            result2 = ((ScalableIcon)result2).scale(this.getScale());
        }
        Icon icon2 = result2;
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(15);
        }
        return icon2;
    }

    private void checkDoesntReferenceThis(Icon icon2) {
        block4: {
            block5: {
                block3: {
                    if (icon2 == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon2 instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)icon2).myScaledDelegateIcon);
                    break block4;
                }
                if (!(icon2 instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon2).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon2 instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon2;
            int count2 = rowIcon.getIconCount();
            for (int i2 = 0; i2 < count2; ++i2) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i2));
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.myScaledDelegateIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.myScaledDelegateIcon.getIconHeight();
    }

    public String getToolTip(boolean composite2) {
        if (this.myScaledDelegateIcon instanceof IconWithToolTip) {
            return ((IconWithToolTip)this.myScaledDelegateIcon).getToolTip(composite2);
        }
        return null;
    }

    public boolean isDone() {
        return this.myDone;
    }

    public boolean equals(Object obj) {
        return obj instanceof DeferredIconImpl && DeferredIconImpl.paramsEqual(this, (DeferredIconImpl)obj);
    }

    public int hashCode() {
        return Objects.hash(this.myParam, this.myScaledDelegateIcon);
    }

    static boolean equalIcons(Icon icon1, Icon icon2) {
        if (icon1 instanceof DeferredIconImpl && icon2 instanceof DeferredIconImpl) {
            return DeferredIconImpl.paramsEqual((DeferredIconImpl)icon1, (DeferredIconImpl)icon2);
        }
        return Objects.equals(icon1, icon2);
    }

    private static boolean paramsEqual(@NotNull DeferredIconImpl<?> icon1, @NotNull DeferredIconImpl<?> icon2) {
        if (icon1 == null) {
            DeferredIconImpl.$$$reportNull$$$0(16);
        }
        if (icon2 == null) {
            DeferredIconImpl.$$$reportNull$$$0(17);
        }
        return Comparing.equal(icon1.myParam, icon2.myParam) && DeferredIconImpl.equalIcons(icon1.myScaledDelegateIcon, icon2.myScaledDelegateIcon);
    }

    @Override
    public String toString() {
        return "Deferred. Base=" + this.myScaledDelegateIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/DeferredIconImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nonNull";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceBy";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withoutReadAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "notifyPaint";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDone";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "paramsEqual";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 7, 8, 12, 13, 14, 15 -> new IllegalStateException(string2);
        };
    }

    private static class DeferredIconAfterReplace<T>
    implements ReplaceableIcon,
    UpdatableIcon {
        @NotNull
        private final DeferredIconImpl<T> myOriginal;
        @NotNull
        private Icon myOriginalEvaluatedIcon;
        @NotNull
        private final IconReplacer myReplacer;
        @NotNull
        private Icon myResultIcon;

        DeferredIconAfterReplace(@NotNull DeferredIconImpl<T> original, @NotNull IconReplacer replacer2) {
            if (original == null) {
                DeferredIconAfterReplace.$$$reportNull$$$0(0);
            }
            if (replacer2 == null) {
                DeferredIconAfterReplace.$$$reportNull$$$0(1);
            }
            this.myOriginal = original;
            this.myOriginalEvaluatedIcon = this.myOriginal.myScaledDelegateIcon;
            this.myReplacer = replacer2;
            this.myResultIcon = this.myReplacer.replaceIcon(this.myOriginalEvaluatedIcon);
        }

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            if (this.myOriginal.needScheduleEvaluation()) {
                this.myOriginal.scheduleEvaluation(c2, x, y);
            } else if (this.myOriginalEvaluatedIcon != this.myOriginal.myScaledDelegateIcon) {
                this.myOriginalEvaluatedIcon = this.myOriginal.myScaledDelegateIcon;
                this.myResultIcon = this.myReplacer.replaceIcon(this.myOriginalEvaluatedIcon);
            }
            this.myResultIcon.paintIcon(c2, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.myResultIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myResultIcon.getIconHeight();
        }

        @Override
        @NotNull
        public Icon replaceBy(@NotNull IconReplacer replacer2) {
            if (replacer2 == null) {
                DeferredIconAfterReplace.$$$reportNull$$$0(2);
            }
            Icon icon2 = replacer2.replaceIcon(this.myOriginal);
            if (icon2 == null) {
                DeferredIconAfterReplace.$$$reportNull$$$0(3);
            }
            return icon2;
        }

        @Override
        public long getModificationCount() {
            return this.myOriginal.getModificationCount();
        }

        @Override
        public void notifyPaint(@NotNull Component c2, int x, int y) {
            if (c2 == null) {
                DeferredIconAfterReplace.$$$reportNull$$$0(4);
            }
            this.myOriginal.notifyPaint(c2, x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/DeferredIconImpl$DeferredIconAfterReplace";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/DeferredIconImpl$DeferredIconAfterReplace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceBy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceBy";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyPaint";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

