/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.LinkedHashSet;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler;", "", "()V", "repaintScheduler", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintScheduler;", "createRepaintRequest", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintRequest;", "c", "Ljava/awt/Component;", "x", "", "y", "getTarget", "scheduleRepaint", "", "request", "iconWidth", "iconHeight", "alwaysSchedule", "", "RepaintRequest", "RepaintScheduler", "RepaintSchedulerRequest", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class DeferredIconRepaintScheduler {
    @NotNull
    private final RepaintScheduler repaintScheduler = new RepaintScheduler();

    @RequiresEdt
    @NotNull
    public final RepaintRequest createRepaintRequest(@Nullable Component c2, int x, int y) {
        Rectangle rectangle;
        Component paintingParent;
        Component target2 = this.getTarget(c2);
        Component component2 = paintingParent = (Component)SwingUtilities.getAncestorOfClass(PaintingParent.class, c2);
        if (component2 == null) {
            rectangle = null;
        } else {
            PaintingParent paintingParent2 = (PaintingParent)component2;
            Component component3 = c2;
            Intrinsics.checkNotNull((Object)component3);
            rectangle = paintingParent2.getChildRec(component3);
        }
        Rectangle paintingParentRec = rectangle;
        return new RepaintRequest(c2, x, y, target2, paintingParent, paintingParentRec);
    }

    @RequiresEdt
    public final void scheduleRepaint(@NotNull RepaintRequest request2, int iconWidth, int iconHeight, boolean alwaysSchedule) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Component actualTarget = request2.getActualTarget();
        if (actualTarget == null) {
            return;
        }
        Component component2 = request2.getComponent();
        if (!alwaysSchedule && Intrinsics.areEqual((Object)component2, (Object)actualTarget)) {
            component2.repaint(request2.getX(), request2.getY(), iconWidth, iconHeight);
        } else {
            this.repaintScheduler.pushDirtyComponent(actualTarget, request2.getPaintingParentRec());
        }
    }

    private final Component getTarget(Component c2) {
        Container list2 = SwingUtilities.getAncestorOfClass(JList.class, c2);
        if (list2 != null) {
            return list2;
        }
        Container table = SwingUtilities.getAncestorOfClass(JTable.class, c2);
        if (table != null) {
            return table;
        }
        Container tree = SwingUtilities.getAncestorOfClass(JTree.class, c2);
        if (tree != null) {
            return tree;
        }
        Container box2 = SwingUtilities.getAncestorOfClass(JComboBox.class, c2);
        if (box2 != null) {
            return box2;
        }
        Container tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c2);
        if (tabLabel != null) {
            return tabLabel;
        }
        return c2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintScheduler;", "", "()V", "myAlarm", "Lcom/intellij/util/Alarm;", "myQueue", "Ljava/util/LinkedHashSet;", "Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintSchedulerRequest;", "Lkotlin/collections/LinkedHashSet;", "pushDirtyComponent", "", "c", "Ljava/awt/Component;", "rec", "Ljava/awt/Rectangle;", "intellij.platform.lang.impl"})
    private static final class RepaintScheduler {
        @NotNull
        private final Alarm myAlarm = new Alarm();
        @NotNull
        private final LinkedHashSet<RepaintSchedulerRequest> myQueue = new LinkedHashSet();

        public final void pushDirtyComponent(@NotNull Component c2, @Nullable Rectangle rec) {
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> RepaintScheduler.pushDirtyComponent$lambda$0(this), 50);
            this.myQueue.add(new RepaintSchedulerRequest(c2, rec));
        }

        private static final void pushDirtyComponent$lambda$0(RepaintScheduler this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            for (RepaintSchedulerRequest each : this$0.myQueue) {
                Rectangle r = each.getRectangle();
                if (r == null) {
                    each.getComponent().repaint();
                    continue;
                }
                each.getComponent().repaint(r.x, r.y, r.width, r.height);
            }
            this$0.myQueue.clear();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003JM\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintRequest;", "", "component", "Ljava/awt/Component;", "x", "", "y", "target", "paintingParent", "paintingParentRec", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;IILjava/awt/Component;Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getPaintingParentRec", "()Ljava/awt/Rectangle;", "getTarget", "getX", "()I", "getY", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "getActualTarget", "hashCode", "toString", "", "intellij.platform.lang.impl"})
    public static final class RepaintRequest {
        @Nullable
        private final Component component;
        private final int x;
        private final int y;
        @Nullable
        private final Component target;
        @Nullable
        private final Component paintingParent;
        @Nullable
        private final Rectangle paintingParentRec;

        public RepaintRequest(@Nullable Component component2, int x, int y, @Nullable Component target2, @Nullable Component paintingParent, @Nullable Rectangle paintingParentRec) {
            this.component = component2;
            this.x = x;
            this.y = y;
            this.target = target2;
            this.paintingParent = paintingParent;
            this.paintingParentRec = paintingParentRec;
        }

        @Nullable
        public final Component getComponent() {
            return this.component;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        @Nullable
        public final Component getTarget() {
            return this.target;
        }

        @Nullable
        public final Rectangle getPaintingParentRec() {
            return this.paintingParentRec;
        }

        @Nullable
        public final Component getActualTarget() {
            if (this.target == null) {
                return null;
            }
            if (SwingUtilities.getWindowAncestor(this.target) != null) {
                return this.target;
            }
            if (this.paintingParent != null && SwingUtilities.getWindowAncestor(this.paintingParent) != null) {
                return this.paintingParent;
            }
            return null;
        }

        @Nullable
        public final Component component1() {
            return this.component;
        }

        public final int component2() {
            return this.x;
        }

        public final int component3() {
            return this.y;
        }

        @Nullable
        public final Component component4() {
            return this.target;
        }

        private final Component component5() {
            return this.paintingParent;
        }

        @Nullable
        public final Rectangle component6() {
            return this.paintingParentRec;
        }

        @NotNull
        public final RepaintRequest copy(@Nullable Component component2, int x, int y, @Nullable Component target2, @Nullable Component paintingParent, @Nullable Rectangle paintingParentRec) {
            return new RepaintRequest(component2, x, y, target2, paintingParent, paintingParentRec);
        }

        public static /* synthetic */ RepaintRequest copy$default(RepaintRequest repaintRequest, Component component2, int n, int n2, Component component3, Component component4, Rectangle rectangle, int n3, Object object) {
            if ((n3 & 1) != 0) {
                component2 = repaintRequest.component;
            }
            if ((n3 & 2) != 0) {
                n = repaintRequest.x;
            }
            if ((n3 & 4) != 0) {
                n2 = repaintRequest.y;
            }
            if ((n3 & 8) != 0) {
                component3 = repaintRequest.target;
            }
            if ((n3 & 0x10) != 0) {
                component4 = repaintRequest.paintingParent;
            }
            if ((n3 & 0x20) != 0) {
                rectangle = repaintRequest.paintingParentRec;
            }
            return repaintRequest.copy(component2, n, n2, component3, component4, rectangle);
        }

        @NotNull
        public String toString() {
            return "RepaintRequest(component=" + this.component + ", x=" + this.x + ", y=" + this.y + ", target=" + this.target + ", paintingParent=" + this.paintingParent + ", paintingParentRec=" + this.paintingParentRec + ")";
        }

        public int hashCode() {
            int result2 = this.component == null ? 0 : this.component.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.y);
            result2 = result2 * 31 + (this.target == null ? 0 : this.target.hashCode());
            result2 = result2 * 31 + (this.paintingParent == null ? 0 : this.paintingParent.hashCode());
            result2 = result2 * 31 + (this.paintingParentRec == null ? 0 : this.paintingParentRec.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepaintRequest)) {
                return false;
            }
            RepaintRequest repaintRequest = (RepaintRequest)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)repaintRequest.component)) {
                return false;
            }
            if (this.x != repaintRequest.x) {
                return false;
            }
            if (this.y != repaintRequest.y) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)repaintRequest.target)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paintingParent, (Object)repaintRequest.paintingParent)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.paintingParentRec, (Object)repaintRequest.paintingParentRec);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/DeferredIconRepaintScheduler$RepaintSchedulerRequest;", "", "component", "Ljava/awt/Component;", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getRectangle", "()Ljava/awt/Rectangle;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    private static final class RepaintSchedulerRequest {
        @NotNull
        private final Component component;
        @Nullable
        private final Rectangle rectangle;

        public RepaintSchedulerRequest(@NotNull Component component2, @Nullable Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            this.component = component2;
            this.rectangle = rectangle;
        }

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @Nullable
        public final Rectangle getRectangle() {
            return this.rectangle;
        }

        @NotNull
        public final Component component1() {
            return this.component;
        }

        @Nullable
        public final Rectangle component2() {
            return this.rectangle;
        }

        @NotNull
        public final RepaintSchedulerRequest copy(@NotNull Component component2, @Nullable Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            return new RepaintSchedulerRequest(component2, rectangle);
        }

        public static /* synthetic */ RepaintSchedulerRequest copy$default(RepaintSchedulerRequest repaintSchedulerRequest, Component component2, Rectangle rectangle, int n, Object object) {
            if ((n & 1) != 0) {
                component2 = repaintSchedulerRequest.component;
            }
            if ((n & 2) != 0) {
                rectangle = repaintSchedulerRequest.rectangle;
            }
            return repaintSchedulerRequest.copy(component2, rectangle);
        }

        @NotNull
        public String toString() {
            return "RepaintSchedulerRequest(component=" + this.component + ", rectangle=" + this.rectangle + ")";
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = result2 * 31 + (this.rectangle == null ? 0 : this.rectangle.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepaintSchedulerRequest)) {
                return false;
            }
            RepaintSchedulerRequest repaintSchedulerRequest = (RepaintSchedulerRequest)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)repaintSchedulerRequest.component)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rectangle, (Object)repaintSchedulerRequest.rectangle);
        }
    }
}

