/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.feedback.new_ui.state.NewUIInfoService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.IconMapLoader;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000e0\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ui/ExperimentalUIImpl;", "Lcom/intellij/ui/ExperimentalUI;", "Lcom/intellij/ide/AppLifecycleListener;", "()V", "newValue", "", "getNewValue", "()Z", "setNewValue", "(Z)V", "appClosing", "", "appStarted", "getIconMappings", "", "Ljava/lang/ClassLoader;", "", "isNewUIEnabledByDefault", "onExpUIDisabled", "suggestRestart", "onExpUIEnabled", "setNewUIInternal", "newUI", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nExperimentalUIImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentalUIImpl.kt\ncom/intellij/ui/ExperimentalUIImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,156:1\n39#2,3:157\n1282#3,2:160\n*S KotlinDebug\n*F\n+ 1 ExperimentalUIImpl.kt\ncom/intellij/ui/ExperimentalUIImpl\n*L\n44#1:157,3\n112#1:160,2\n*E\n"})
public final class ExperimentalUIImpl
extends ExperimentalUI
implements AppLifecycleListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean newValue = ExperimentalUI.isNewUI();

    public ExperimentalUIImpl() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection messageBusConnection = app.getMessageBus().connect();
        Topic topic = AppLifecycleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, this);
        if (ConfigImportHelper.isNewUser() && this.isNewUIEnabledByDefault() && !ExperimentalUI.isNewUI()) {
            app.invokeLater(() -> ExperimentalUIImpl._init_$lambda$0(this));
        }
    }

    public final boolean getNewValue() {
        return this.newValue;
    }

    public final void setNewValue(boolean bl) {
        this.newValue = bl;
    }

    private final boolean isNewUIEnabledByDefault() {
        return PlatformUtils.isAqua() || PlatformUtils.isPyCharmCommunity() || PlatformUtils.isWebStorm();
    }

    @NotNull
    public Map<ClassLoader, Map<String, String>> getIconMappings() {
        boolean $i$f$service = false;
        Class<IconMapLoader> serviceClass$iv = IconMapLoader.class;
        IconMapLoader iconMapLoader = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (iconMapLoader == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return iconMapLoader.loadIconMapping();
    }

    public void setNewUIInternal(boolean newUI, boolean suggestRestart) {
        if (newUI) {
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            if (propertyComponent.getBoolean("experimental.ui.used.once")) {
                propertyComponent.unsetValue("experimental.ui.first.switch");
            } else {
                propertyComponent.setValue("experimental.ui.first.switch", true);
            }
        }
        this.newValue = newUI;
        if (this.newValue != ExperimentalUI.isNewUI() && suggestRestart) {
            String string2 = ApplicationManager.getApplication().isRestartCapable() ? IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0]) : IdeBundle.message((String)"ide.shutdown.action", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (ApplicationManager.g\u2026ge(\"ide.shutdown.action\")");
            String action2 = string2;
            if (PlatformUtils.isJetBrainsClient()) {
                Registry.get("ide.experimental.ui").setValue(this.newValue);
            } else {
                Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()};
                int result2 = Messages.showYesNoDialog((String)IdeBundle.message((String)"dialog.message.must.be.restarted.for.changes.to.take.effect", (Object[])objectArray), (String)IdeBundle.message((String)"dialog.title.restart.required", (Object[])new Object[0]), (String)action2, (String)IdeBundle.message((String)"ide.notnow.action", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    ApplicationManagerEx.getApplicationEx().restart(true);
                }
            }
        }
    }

    public void appStarted() {
        if (ExperimentalUI.isNewUI()) {
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue("experimental.ui.used.once", true);
        }
    }

    public void appClosing() {
        if (this.newValue != ExperimentalUI.isNewUI()) {
            Registry.get("ide.experimental.ui").setValue(this.newValue);
            if (this.newValue) {
                this.onExpUIEnabled(false);
            } else {
                this.onExpUIDisabled(false);
            }
        }
    }

    public void onExpUIEnabled(boolean suggestRestart) {
        Object object;
        LafManager lafManager;
        block6: {
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            this.newValue = true;
            NewUIInfoService.Companion.getInstance().updateEnableNewUIDate();
            ExperimentalUIImpl.Companion.setRegistryKeyIfNecessary("ide.experimental.ui", true);
            ExperimentalUIImpl.Companion.setRegistryKeyIfNecessary("debugger.new.tool.window.layout", true);
            UISettings.Companion.getInstance().setHideToolStripes(false);
            String name = JBColor.isBright() ? "Light" : "Dark";
            lafManager = LafManager.getInstance();
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafManager.getInstalledLookAndFeels();
            Intrinsics.checkNotNullExpressionValue((Object)lookAndFeelInfoArray, (String)"lafManager.installedLookAndFeels");
            Object[] $this$firstOrNull$iv = lookAndFeelInfoArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UIManager.LookAndFeelInfo it = (UIManager.LookAndFeelInfo)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                object = element$iv;
                break block6;
            }
            object = null;
        }
        UIManager.LookAndFeelInfo laf = (UIManager.LookAndFeelInfo)object;
        if (laf != null) {
            lafManager.setCurrentLookAndFeel(laf);
            if (lafManager.getAutodetect()) {
                if (JBColor.isBright()) {
                    lafManager.setPreferredLightLaf(laf);
                } else {
                    lafManager.setPreferredDarkLaf(laf);
                }
            }
        }
    }

    public void onExpUIDisabled(boolean suggestRestart) {
        String currentLafName;
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        this.newValue = false;
        NewUIInfoService.Companion.getInstance().updateDisableNewUIDate();
        ExperimentalUIImpl.Companion.setRegistryKeyIfNecessary("ide.experimental.ui", false);
        ExperimentalUIImpl.Companion.setRegistryKeyIfNecessary("debugger.new.tool.window.layout", false);
        LafManager lafManager = LafManager.getInstance();
        Intrinsics.checkNotNull((Object)lafManager, (String)"null cannot be cast to non-null type com.intellij.ide.ui.laf.LafManagerImpl");
        LafManagerImpl lafManager2 = (LafManagerImpl)lafManager;
        UIManager.LookAndFeelInfo lookAndFeelInfo = lafManager2.getCurrentLookAndFeel();
        String string2 = currentLafName = lookAndFeelInfo != null ? lookAndFeelInfo.getName() : null;
        if (Intrinsics.areEqual((Object)currentLafName, (Object)"Dark") || Intrinsics.areEqual((Object)currentLafName, (Object)"Light")) {
            UIManager.LookAndFeelInfo lookAndFeelInfo2;
            if (JBColor.isBright()) {
                UIManager.LookAndFeelInfo lookAndFeelInfo3 = lafManager2.getDefaultLightLaf();
                lookAndFeelInfo2 = lookAndFeelInfo3;
                Intrinsics.checkNotNull((Object)lookAndFeelInfo3);
            } else {
                lookAndFeelInfo2 = lafManager2.getDefaultDarkLaf();
            }
            UIManager.LookAndFeelInfo laf = lookAndFeelInfo2;
            lafManager2.setCurrentLookAndFeel(laf);
            if (lafManager2.getAutodetect()) {
                if (JBColor.isBright()) {
                    lafManager2.setPreferredLightLaf(laf);
                } else {
                    lafManager2.setPreferredDarkLaf(laf);
                }
            }
        }
    }

    private static final void _init_$lambda$0(ExperimentalUIImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.newValue = true;
        this$0.onExpUIEnabled(false);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/ui/ExperimentalUIImpl$Companion;", "", "()V", "setRegistryKeyIfNecessary", "", "key", "", "value", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setRegistryKeyIfNecessary(String key, boolean value) {
            if (Registry.is(key) != value) {
                Registry.get(key).setValue(value);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

