/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public abstract class HeldDownKeyListener {
    private final KeyStroke myKeyStroke;

    public HeldDownKeyListener() {
        this(KeyStroke.getKeyStroke("shift pressed SHIFT"));
    }

    public HeldDownKeyListener(KeyStroke keyStroke) {
        this.myKeyStroke = keyStroke;
    }

    public void installOn(JComponent component2) {
        HeldDownKeyListener.registerAction(component2, "heldDownKey:" + this.myKeyStroke.toString(), this.myKeyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeldDownKeyListener.this.heldKeyTriggered((JComponent)e.getSource(), true);
            }
        });
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(this.myKeyStroke.getKeyCode(), 0, true);
        HeldDownKeyListener.registerAction(component2, "heldDownKey:" + keyStroke2.toString(), keyStroke2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeldDownKeyListener.this.heldKeyTriggered((JComponent)e.getSource(), false);
            }
        });
    }

    protected abstract void heldKeyTriggered(JComponent var1, boolean var2);

    private static void registerAction(JComponent component2, @NonNls String name, KeyStroke keyStroke, AbstractAction action2) {
        component2.getInputMap().put(keyStroke, name);
        component2.getActionMap().put(name, action2);
    }
}

