/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.VirtualFileAppearanceListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconDeferrerImpl
extends IconDeferrer {
    private static final ThreadLocal<Boolean> evaluationIsInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Object LOCK = new Object();
    private final Map<Object, Icon> myIconsCache = new FixedHashMap<Object, Icon>(SystemProperties.getIntProperty("ide.icons.deferrerCacheSize", 1000));
    private long myLastClearTimestamp;

    public IconDeferrerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, this::clearCache);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ui/IconDeferrerImpl$1", "after"));
            }
        });
        connection.subscribe(ProjectCloseListener.TOPIC, new ProjectCloseListener(){

            @Override
            public void projectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                IconDeferrerImpl.this.clearCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/IconDeferrerImpl$2", "projectClosed"));
            }
        });
        connection.subscribe(VirtualFileAppearanceListener.TOPIC, __ -> this.clearCache());
        LowMemoryWatcher.register(this::clearCache, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIconsCache.clear();
            ++this.myLastClearTimestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public <T> Icon defer(@Nullable Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        if (evaluator == null) {
            IconDeferrerImpl.$$$reportNull$$$0(0);
        }
        if (evaluationIsInProgress.get().booleanValue()) {
            Icon icon2 = evaluator.apply(param);
            if (icon2 != null) return icon2;
            IconDeferrerImpl.$$$reportNull$$$0(1);
            return icon2;
        }
        Object object = this.LOCK;
        // MONITORENTER : object
        Icon cached = this.myIconsCache.get(param);
        if (cached != null) {
            Icon icon3 = cached;
            // MONITOREXIT : object
            if (icon3 != null) return icon3;
            IconDeferrerImpl.$$$reportNull$$$0(2);
            return icon3;
        }
        long started = this.myLastClearTimestamp;
        DeferredIconImpl<T> result2 = new DeferredIconImpl<T>(base, param, true, evaluator, (source, r) -> {
            Object object = this.LOCK;
            synchronized (object) {
                if (started == this.myLastClearTimestamp) {
                    this.myIconsCache.put(((DeferredIconImpl)source).myParam, (Icon)r);
                }
            }
        });
        this.myIconsCache.put(param, result2);
        DeferredIconImpl<T> deferredIconImpl = result2;
        // MONITOREXIT : object
        if (deferredIconImpl != null) return deferredIconImpl;
        IconDeferrerImpl.$$$reportNull$$$0(3);
        return deferredIconImpl;
    }

    static void evaluateDeferred(@NotNull Runnable runnable) {
        if (runnable == null) {
            IconDeferrerImpl.$$$reportNull$$$0(4);
        }
        try {
            evaluationIsInProgress.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            evaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    public boolean equalIcons(Icon icon1, Icon icon2) {
        return DeferredIconImpl.equalIcons(icon1, icon2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/IconDeferrerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/IconDeferrerImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDeferred";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3 -> new IllegalStateException(string2);
        };
    }
}

