/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class SeparatorComponent
extends JComponent {
    private int myVGap = 3;
    private Color myColor = Color.lightGray;
    private Color myShadow = Gray._240;
    private int myHGap = 1;
    private SeparatorOrientation myOrientation = SeparatorOrientation.HORIZONTAL;

    public SeparatorComponent() {
    }

    public SeparatorComponent(int aVerticalGap) {
        this.myVGap = aVerticalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, int aHorizontalGap) {
        this.myVGap = aVerticalGap;
        this.myHGap = aHorizontalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, Color aColor, Color aShadowColor) {
        this(aVerticalGap, 1, aColor, aShadowColor);
    }

    public SeparatorComponent(int aVerticalGap, int horizontalGap, Color aColor, Color aShadowColor) {
        this.myVGap = aVerticalGap;
        this.myHGap = horizontalGap;
        this.myColor = aColor;
        this.myShadow = aShadowColor;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(Color color, SeparatorOrientation orientation) {
        this.myColor = color;
        this.myOrientation = orientation;
        this.myShadow = null;
        this.myHGap = 0;
        this.myVGap = 0;
    }

    public void setVGap(int VGap) {
        this.myVGap = VGap;
    }

    public void setHGap(int HGap) {
        this.myHGap = HGap;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.myColor == null) {
            return;
        }
        g.setColor(this.myColor);
        if (this.myOrientation == SeparatorOrientation.HORIZONTAL) {
            int length = this.getWidth() - this.myHGap * 2;
            if (this.myShadow != null) {
                --length;
            }
            SeparatorComponent.paintHorizontalLine(g, this.myHGap, this.myVGap, length);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                SeparatorComponent.paintHorizontalLine(g, this.myHGap + 1, this.myVGap + 1, length);
            }
        } else {
            int length = this.getHeight() - this.myVGap * 2;
            if (this.myShadow != null) {
                --length;
            }
            SeparatorComponent.paintVerticalLine(g, this.myHGap, this.myVGap, length);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                SeparatorComponent.paintVerticalLine(g, this.myHGap + 1, this.myVGap + 1, length);
            }
        }
    }

    private static void paintHorizontalLine(Graphics g, int x, int y, int length) {
        LinePainter2D.paint((Graphics2D)g, x, y, x + length, y, LinePainter2D.StrokeType.CENTERED, 1.0);
    }

    private static void paintVerticalLine(Graphics g, int x, int y, int length) {
        LinePainter2D.paint((Graphics2D)g, x, y, x, y + length, LinePainter2D.StrokeType.CENTERED, 1.0);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myOrientation == SeparatorOrientation.HORIZONTAL) {
            return new Dimension(0, this.myVGap * 2 + 1);
        }
        return new Dimension(this.myHGap * 2 + 1, 1 + (this.myShadow != null ? 1 : 0));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = this.getPreferredSize();
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            size.width = Integer.MAX_VALUE;
        } else {
            size.height = Integer.MAX_VALUE;
        }
        return size;
    }
}

