/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class SideBorder
extends LineBorder {
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    private final int mySideMask;

    public SideBorder(Color color, @SideMask int mask) {
        this(color, mask, 1);
    }

    public SideBorder(Color color, @SideMask int mask, int thickness) {
        super(color, thickness);
        this.mySideMask = mask;
    }

    @Override
    public Insets getBorderInsets(Component component2) {
        return new Insets((this.mySideMask & 2) != 0 ? this.getThickness() : 0, (this.mySideMask & 1) != 0 ? this.getThickness() : 0, (this.mySideMask & 8) != 0 ? this.getThickness() : 0, (this.mySideMask & 4) != 0 ? this.getThickness() : 0);
    }

    @Override
    public Insets getBorderInsets(Component component2, Insets insets) {
        insets.top = (this.mySideMask & 2) != 0 ? this.getThickness() : 0;
        insets.left = (this.mySideMask & 1) != 0 ? this.getThickness() : 0;
        insets.bottom = (this.mySideMask & 8) != 0 ? this.getThickness() : 0;
        insets.right = (this.mySideMask & 4) != 0 ? this.getThickness() : 0;
        return insets;
    }

    @Override
    public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getLineColor());
        if ((this.mySideMask & 1) != 0) {
            g.fillRect(x, y, this.thickness, height);
        }
        if ((this.mySideMask & 2) != 0) {
            g.fillRect(x, y, width, this.thickness);
        }
        if ((this.mySideMask & 4) != 0) {
            g.fillRect(x + width - this.thickness, y, this.thickness, height);
        }
        if ((this.mySideMask & 8) != 0) {
            g.fillRect(x, y + height - this.thickness, width, this.thickness);
        }
        g.setColor(oldColor);
    }

    public static @interface SideMask {
    }
}

