/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class SmartExpander {
    public static void installOn(final JTree tree) {
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                TreePath path2 = event.getPath();
                TreeModel model2 = tree.getModel();
                Object lastPathComponent = path2.getLastPathComponent();
                int childCount = model2.getChildCount(lastPathComponent);
                for (int i2 = 0; i2 < childCount; ++i2) {
                    Object child = model2.getChild(lastPathComponent, i2);
                    TreePath childPath = path2.pathByAddingChild(child);
                    if (!tree.isExpanded(childPath)) continue;
                    tree.collapsePath(childPath);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
            }
        });
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object lastPathComponent;
                TreePath path2 = event.getPath();
                TreeModel model2 = tree.getModel();
                if (model2.getChildCount(lastPathComponent = path2.getLastPathComponent()) == 1) {
                    TreePath firstChildPath = path2.pathByAddingChild(model2.getChild(lastPathComponent, 0));
                    tree.expandPath(firstChildPath);
                }
            }
        });
    }
}

