/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel<T>
extends AbstractListModel<T> {
    private List<T> myItems = new ArrayList<T>();
    private final Comparator<? super T> myComparator;

    public SortedListModel(Comparator<? super T> comparator) {
        this.myComparator = comparator;
    }

    public SortedListModel(Collection<? extends T> items2, Comparator<? super T> comparator) {
        this(comparator);
        this.addAll(items2);
    }

    public static <T> SortedListModel<T> create(Comparator<? super T> comparator) {
        return new SortedListModel<T>(comparator);
    }

    public int add(T item) {
        int index2 = this.myComparator != null ? Collections.binarySearch(this.myItems, item, this.myComparator) : this.myItems.size();
        index2 = index2 >= 0 ? index2 : -(index2 + 1);
        this.add(index2, item);
        return index2;
    }

    public int[] addAll(T[] items2) {
        return this.addAll(Arrays.asList(items2));
    }

    public int[] addAll(Iterator<? extends T> iterator2) {
        return this.addAll(ContainerUtil.collect(iterator2));
    }

    public int[] addAll(Collection<? extends T> items2) {
        int[] indices = new int[items2.size()];
        int i2 = 0;
        for (T item : items2) {
            int newIndex = this.add(item);
            for (int j = 0; j < i2; ++j) {
                if (indices[j] < newIndex) continue;
                int n = j;
                indices[n] = indices[n] + 1;
            }
            indices[i2] = newIndex;
            ++i2;
        }
        return indices;
    }

    public void remove(int index2) {
        this.myItems.remove(index2);
        this.fireRemoved(index2);
    }

    private void fireRemoved(int index2) {
        this.fireIntervalRemoved(this, index2, index2);
    }

    public void remove(T item) {
        int index2 = this.indexOf(item);
        if (index2 >= 0) {
            this.remove(index2);
        }
    }

    public int indexOf(T item) {
        int index2 = Collections.binarySearch(this.myItems, item, this.myComparator);
        return index2 >= 0 ? index2 : -1;
    }

    private void add(int index2, T item) {
        this.myItems.add(index2, item);
        this.fireIntervalAdded(this, index2, index2);
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index2) {
        return this.myItems.get(index2);
    }

    public void setAll(Collection<? extends T> items2) {
        int newSize;
        this.clear();
        this.myItems.addAll(items2);
        if (this.myComparator != null) {
            this.myItems.sort(this.myComparator);
        }
        if ((newSize = this.getSize()) > 0) {
            this.fireIntervalAdded(this, 0, newSize - 1);
        }
    }

    public void clear() {
        int oldSize = this.getSize();
        this.myItems = new ArrayList<T>();
        if (oldSize > 0) {
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    public List<T> getItems() {
        return this.myItems;
    }

    public T get(int index2) {
        return this.myItems.get(index2);
    }

    public void setAll(T[] items2) {
        this.setAll(Arrays.asList(items2));
    }

    public Iterator<T> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<T> {
        private final Iterator<T> myIterator;
        private int myCounter = -1;

        MyIterator() {
            this.myIterator = SortedListModel.this.myItems.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.myCounter;
            return this.myIterator.next();
        }

        @Override
        public void remove() {
            this.myIterator.remove();
            SortedListModel.this.fireRemoved(this.myCounter);
            --this.myCounter;
        }
    }
}

