/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.EditorComboBoxEditor;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class StringComboboxEditor
extends EditorComboBoxEditor {
    public static final Key<JComboBox> COMBO_BOX_KEY = Key.create("COMBO_BOX_KEY");
    public static final Key<Boolean> USE_PLAIN_PREFIX_MATCHER = Key.create("USE_PLAIN_PREFIX_MATCHER");
    private final Project myProject;

    public StringComboboxEditor(Project project2, FileType fileType, ComboBox comboBox) {
        this(project2, fileType, comboBox, false);
    }

    public StringComboboxEditor(Project project2, FileType fileType, ComboBox comboBox, boolean usePlainMatcher) {
        super(project2, fileType);
        this.myProject = project2;
        PsiFile file2 = PsiFileFactory.getInstance(project2).createFileFromText("a.dummy", FileTypes.PLAIN_TEXT, (CharSequence)"", 0L, true);
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        assert (document != null);
        document.putUserData(COMBO_BOX_KEY, comboBox);
        if (usePlainMatcher) {
            document.putUserData(USE_PLAIN_PREFIX_MATCHER, true);
        }
        super.setItem((Object)document);
    }

    protected void onEditorCreate(final EditorEx editor2) {
        Disposer.register(((EditorImpl)editor2).getDisposable(), new Disposable(){

            @Override
            public void dispose() {
                editor2.getDocument().putUserData(COMBO_BOX_KEY, null);
            }
        });
    }

    @NotNull
    public Object getItem() {
        String string2 = ((Document)super.getItem()).getText();
        if (string2 == null) {
            StringComboboxEditor.$$$reportNull$$$0(0);
        }
        return string2;
    }

    public void setItem(Object anObject) {
        if (anObject == null) {
            anObject = "";
        }
        if (anObject.equals(this.getItem())) {
            return;
        }
        String s = (String)anObject;
        WriteCommandAction.writeCommandAction(this.myProject).run(() -> this.getDocument().setText(s));
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getCaretModel().moveToOffset(s.length());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/StringComboboxEditor", "getItem"));
    }
}

