/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.debugger.UiDebuggerExtension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FocusDebugger
implements UiDebuggerExtension,
PropertyChangeListener,
ListSelectionListener {
    private JComponent myComponent;
    private JList<FocusElement> myLog;
    private DefaultListModel<FocusElement> myLogModel;
    private JEditorPane myAllocation;

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.init();
        }
        return this.myComponent;
    }

    private JComponent init() {
        JPanel result2 = new JPanel(new BorderLayout());
        this.myLogModel = new DefaultListModel();
        this.myLog = new JBList(this.myLogModel);
        this.myLog.setCellRenderer((ListCellRenderer<FocusElement>)((Object)new FocusElementRenderer()));
        this.myAllocation = new JEditorPane();
        DefaultCaret caret = new DefaultCaret();
        this.myAllocation.setCaret(caret);
        caret.setUpdatePolicy(1);
        this.myAllocation.setEditable(false);
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent(ScrollPaneFactory.createScrollPane(this.myLog));
        splitter.setSecondComponent(ScrollPaneFactory.createScrollPane((Component)this.myAllocation));
        this.myLog.addListSelectionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        result2.add((Component)splitter, "Center");
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new ClearAction());
        result2.add((Component)ActionManager.getInstance().createActionToolbar("FocusDbg", (ActionGroup)group2, true).getComponent(), "North");
        return result2;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.myLog.getSelectedIndex() == -1) {
            this.myAllocation.setText(null);
        } else {
            FocusElement element = this.myLog.getSelectedValue();
            StringWriter s = new StringWriter();
            PrintWriter writer = new PrintWriter(s);
            element.getAllocation().printStackTrace(writer);
            @NlsSafe String trace = s.toString();
            this.myAllocation.setText(trace);
        }
    }

    private boolean isInsideDebuggerDialog(Component c2) {
        Window debuggerWindow = SwingUtilities.getWindowAncestor(this.myComponent);
        if (!(debuggerWindow instanceof Dialog)) {
            return false;
        }
        return c2 == debuggerWindow || SwingUtilities.getWindowAncestor(c2) == debuggerWindow;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        boolean affectsDebugger = false;
        if (newValue instanceof Component && this.isInsideDebuggerDialog((Component)newValue)) {
            affectsDebugger = true;
        }
        if (oldValue instanceof Component && this.isInsideDebuggerDialog((Component)oldValue)) {
            affectsDebugger = true;
        }
        SimpleColoredText text2 = new SimpleColoredText();
        @NlsSafe String propertyName = evt.getPropertyName();
        text2.append(propertyName, FocusDebugger.maybeGrayOut(new SimpleTextAttributes(16, null), affectsDebugger));
        text2.append(" " + IdeBundle.message((String)"focus.debugger.label.newvalue", (Object[])new Object[0]), FocusDebugger.maybeGrayOut(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, affectsDebugger));
        text2.append(String.valueOf(evt.getNewValue()), FocusDebugger.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        text2.append(" " + IdeBundle.message((String)"focus.debugger.label.oldvalue", (Object[])new Object[0]) + evt.getOldValue(), FocusDebugger.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        this.myLogModel.addElement(new FocusElement(text2, new Throwable()));
        SwingUtilities.invokeLater(() -> {
            if (this.myLog != null && this.myLog.isShowing()) {
                int h = this.myLog.getFixedCellHeight();
                this.myLog.scrollRectToVisible(new Rectangle(0, this.myLog.getPreferredSize().height - h, this.myLog.getWidth(), h));
                if (this.myLog.getModel().getSize() > 0) {
                    this.myLog.setSelectedIndex(this.myLog.getModel().getSize() - 1);
                }
            }
        });
    }

    private static SimpleTextAttributes maybeGrayOut(SimpleTextAttributes attr, boolean greyOut) {
        return greyOut ? attr.derive(attr.getStyle(), (Color)JBColor.GRAY, attr.getBgColor(), attr.getWaveColor()) : attr;
    }

    @Override
    @NlsContexts.TabTitle
    public String getName() {
        return LangBundle.message("tab.title.focus", new Object[0]);
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
    }

    static class FocusElementRenderer
    extends ColoredListCellRenderer<FocusElement> {
        FocusElementRenderer() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected void customizeCellRenderer(@NotNull JList<? extends FocusElement> list2, FocusElement value, int index2, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                FocusElementRenderer.$$$reportNull$$$0(0);
            }
            this.clear();
            SimpleColoredText text2 = value.getText();
            @Nls ArrayList strings2 = text2.getTexts();
            ArrayList attributes = value.getText().getAttributes();
            for (int i2 = 0; i2 < strings2.size(); ++i2) {
                this.append((String)strings2.get(i2), (SimpleTextAttributes)attributes.get(i2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/debugger/extensions/FocusDebugger$FocusElementRenderer", "customizeCellRenderer"));
        }
    }

    class ClearAction
    extends AnAction {
        ClearAction() {
            super(IdeBundle.messagePointer((String)"action.AnAction.text.clear", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.AnAction.description.clear", (Object[])new Object[0]), AllIcons.Actions.Close);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            FocusDebugger.this.myLogModel.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/debugger/extensions/FocusDebugger$ClearAction", "actionPerformed"));
        }
    }

    static class FocusElement {
        private final SimpleColoredText myText;
        private final Throwable myAllocation;

        FocusElement(SimpleColoredText text2, Throwable allocation) {
            this.myText = text2;
            this.myAllocation = allocation;
        }

        public SimpleColoredText getText() {
            return this.myText;
        }

        public Throwable getAllocation() {
            return this.myAllocation;
        }
    }
}

