/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/icons/IconLoadMeasurer;", "", "()V", "actionIcon", "Lcom/intellij/ui/icons/IconLoadMeasurer$Counter;", "findIcon", "findIconLoad", "loadFromResources", "loadFromUrl", "pngDecoding", "pngLoading", "stats", "", "getStats", "()Ljava/util/List;", "svgCacheRead", "svgCacheWrite", "svgDecoding", "svgLoading", "svgPreBuiltLoad", "addLoading", "", "isSvg", "", "start", "", "Counter", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class IconLoadMeasurer {
    @NotNull
    public static final IconLoadMeasurer INSTANCE = new IconLoadMeasurer();
    @JvmField
    @NotNull
    public static final Counter svgDecoding = new Counter("svg-decode");
    @NotNull
    private static final Counter svgLoading = new Counter("svg-load");
    @JvmField
    @NotNull
    public static final Counter svgPreBuiltLoad = new Counter("svg-prebuilt");
    @JvmField
    @NotNull
    public static final Counter svgCacheWrite = new Counter("svg-cache-write");
    @JvmField
    @NotNull
    public static final Counter svgCacheRead = new Counter("svg-cache-read");
    @JvmField
    @NotNull
    public static final Counter pngDecoding = new Counter("png-decode");
    @NotNull
    private static final Counter pngLoading = new Counter("png-load");
    @JvmField
    @NotNull
    public static final Counter findIcon = new Counter("find-icon");
    @JvmField
    @NotNull
    public static final Counter findIconLoad = new Counter("find-icon-load");
    @JvmField
    @NotNull
    public static final Counter loadFromUrl = new Counter("load-from-url");
    @JvmField
    @NotNull
    public static final Counter loadFromResources = new Counter("load-from-resource");
    @JvmField
    @NotNull
    public static final Counter actionIcon = new Counter("action-icon");

    private IconLoadMeasurer() {
    }

    @NotNull
    public final List<Counter> getStats() {
        Object[] objectArray = new Counter[]{findIcon, findIconLoad, loadFromUrl, loadFromResources, svgLoading, svgDecoding, svgPreBuiltLoad, svgCacheRead, svgCacheWrite, pngLoading, pngDecoding, actionIcon};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void addLoading(boolean isSvg, long start) {
        (isSvg ? svgLoading : pngLoading).end(start);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0014\b\u0000\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/icons/IconLoadMeasurer$Counter;", "", "name", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "count", "", "getCount", "()I", "counter", "Ljava/util/concurrent/atomic/LongAdder;", "totalDuration", "end", "", "startTime", "", "getTotalDuration", "intellij.platform.util.ui"})
    public static final class Counter {
        @JvmField
        @NotNull
        public final String name;
        @NotNull
        private final LongAdder counter;
        @NotNull
        private final LongAdder totalDuration;

        public Counter(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.counter = new LongAdder();
            this.totalDuration = new LongAdder();
        }

        public final int getCount() {
            return (int)this.counter.sum();
        }

        public final long getTotalDuration() {
            return this.totalDuration.sum();
        }

        public final void end(long startTime) {
            if (startTime > 0L) {
                long duration = StartUpMeasurer.getCurrentTime() - startTime;
                this.counter.increment();
                this.totalDuration.add(duration);
            }
        }
    }
}

