/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.jna.JnaLoader;
import com.intellij.ui.mac.foundation.CoreGraphicsLibrary;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.FromNativeContext;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.Structure;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;

@NonNls
public final class CoreGraphics {
    private static final CoreGraphicsLibrary myCoreGraphicsLibrary;
    static final /* synthetic */ boolean $assertionsDisabled;

    private CoreGraphics() {
    }

    public static ID cgWindowListCreateImage(CGRect screenBounds, int windowOption, ID windowID, int imageOption) {
        return myCoreGraphicsLibrary.CGWindowListCreateImage(screenBounds, windowOption, windowID, imageOption);
    }

    static {
        boolean bl = $assertionsDisabled = !CoreGraphics.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !JnaLoader.isLoaded()) {
            throw new AssertionError((Object)"JNA library is not available");
        }
        myCoreGraphicsLibrary = Native.load("CoreGraphics", CoreGraphicsLibrary.class, Collections.singletonMap("jna.encoding", "UTF8"));
    }

    @Structure.FieldOrder(value={"origin", "size"})
    public static class CGRect
    extends Structure
    implements Structure.ByValue {
        public CGPoint origin;
        public CGSize size;

        public CGRect(double x, double y, double w, double h) {
            this.origin = new CGPoint(x, y);
            this.size = new CGSize(w, h);
        }
    }

    public static class CGFloat
    implements NativeMapped {
        private final double value;

        public CGFloat() {
            this(0.0);
        }

        public CGFloat(double d) {
            this.value = d;
        }

        @Override
        public Object fromNative(Object o, FromNativeContext fromNativeContext) {
            return switch (Native.LONG_SIZE) {
                case 4 -> new CGFloat(((Float)o).floatValue());
                case 8 -> new CGFloat((Double)o);
                default -> throw new IllegalStateException();
            };
        }

        @Override
        public Object toNative() {
            return switch (Native.LONG_SIZE) {
                case 4 -> Float.valueOf((float)this.value);
                case 8 -> this.value;
                default -> throw new IllegalStateException();
            };
        }

        @Override
        public Class<?> nativeType() {
            return switch (Native.LONG_SIZE) {
                case 4 -> Float.class;
                case 8 -> Double.class;
                default -> throw new IllegalStateException();
            };
        }
    }

    @Structure.FieldOrder(value={"width", "height"})
    public static class CGSize
    extends Structure
    implements Structure.ByValue {
        public CGFloat width;
        public CGFloat height;

        public CGSize() {
            this(0.0, 0.0);
        }

        public CGSize(double width, double height) {
            this.width = new CGFloat(width);
            this.height = new CGFloat(height);
        }
    }

    @Structure.FieldOrder(value={"x", "y"})
    public static class CGPoint
    extends Structure
    implements Structure.ByValue {
        public CGFloat x;
        public CGFloat y;

        public CGPoint() {
            this(0.0, 0.0);
        }

        public CGPoint(double x, double y) {
            this.x = new CGFloat(x);
            this.y = new CGFloat(y);
        }
    }
}

