/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ReflectionUtil;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacUtil {
    private static final Logger LOG = Logger.getInstance(MacUtil.class);

    private MacUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ID findWindowForTitle(@Nullable String title) {
        ID focusedWindow;
        block5: {
            if (title == null || title.isEmpty()) {
                return null;
            }
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            focusedWindow = null;
            try {
                String titleString;
                ID window;
                ID windowTitle;
                ID sharedApplication = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                ID windows = Foundation.invoke(sharedApplication, "windows", new Object[0]);
                ID windowEnumerator = Foundation.invoke(windows, "objectEnumerator", new Object[0]);
                do {
                    if (!ID.NIL.equals(window = Foundation.invoke(windowEnumerator, "nextObject", new Object[0]))) continue;
                    break block5;
                } while (ID.NIL.equals(windowTitle = Foundation.invoke(window, "title", new Object[0])) || !Objects.equals(titleString = Foundation.toStringViaUTF8(windowTitle), title));
                focusedWindow = window;
            }
            finally {
                Foundation.invoke(pool, "release", new Object[0]);
            }
        }
        return focusedWindow;
    }

    @Deprecated(forRemoval=true)
    public static void adjustFocusTraversal(@NotNull Disposable disposable) {
        if (disposable == null) {
            MacUtil.$$$reportNull$$$0(0);
        }
    }

    @NotNull
    public static ID getWindowFromJavaWindow(@Nullable Window w) {
        if (w == null) {
            ID iD = ID.NIL;
            if (iD == null) {
                MacUtil.$$$reportNull$$$0(1);
            }
            return iD;
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                Object cPlatformWindow = MacUtil.getPlatformWindow(w);
                if (cPlatformWindow != null) {
                    Field ptr = cPlatformWindow.getClass().getSuperclass().getDeclaredField("ptr");
                    ptr.setAccessible(true);
                    return new ID(ptr.getLong(cPlatformWindow));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug(e);
            }
        }
        ID iD = ID.NIL;
        if (iD == null) {
            MacUtil.$$$reportNull$$$0(2);
        }
        return iD;
    }

    @Nullable
    public static Object getPlatformWindow(@NotNull Window w) {
        if (w == null) {
            MacUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                Class<?> cWindowPeerClass;
                Method getPlatformWindowMethod;
                Object cPlatformWindow;
                Class<?> awtAccessor = Class.forName("sun.awt.AWTAccessor");
                Object componentAccessor = awtAccessor.getMethod("getComponentAccessor", new Class[0]).invoke(null, new Object[0]);
                Method getPeer = componentAccessor.getClass().getMethod("getPeer", Component.class);
                getPeer.setAccessible(true);
                Object peer = getPeer.invoke(componentAccessor, w);
                if (peer != null && (cPlatformWindow = (getPlatformWindowMethod = (cWindowPeerClass = peer.getClass()).getDeclaredMethod("getPlatformWindow", new Class[0])).invoke(peer, new Object[0])) != null) {
                    return cPlatformWindow;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.debug(e);
            }
        }
        return null;
    }

    public static void updateRootPane(@NotNull Window window, @NotNull JRootPane rootPane) {
        if (window == null) {
            MacUtil.$$$reportNull$$$0(4);
        }
        if (rootPane == null) {
            MacUtil.$$$reportNull$$$0(5);
        }
        try {
            Object platformWindow = MacUtil.getPlatformWindow(window);
            if (platformWindow == null) {
                return;
            }
            Field field = platformWindow.getClass().getDeclaredField("CLIENT_PROPERTY_APPLICATOR");
            field.setAccessible(true);
            Object clientPropertyApplicator = field.get(platformWindow);
            Method method2 = ReflectionUtil.getMethod(clientPropertyApplicator.getClass(), "attachAndApplyClientProperties", JComponent.class);
            if (method2 != null) {
                method2.invoke(clientPropertyApplicator, rootPane);
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    public static ID findWindowFromJavaWindow(Window w) {
        ID window;
        if (Registry.is("skip.untitled.windows.for.mac.messages") && !ID.NIL.equals(window = MacUtil.getWindowFromJavaWindow(w))) {
            return window;
        }
        return MacUtil.findWindowForTitle(MacUtil.getWindowTitle(w));
    }

    @Nullable
    public static String getWindowTitle(Window documentRoot) {
        String windowTitle = null;
        if (documentRoot instanceof Frame) {
            windowTitle = ((Frame)documentRoot).getTitle();
        } else if (documentRoot instanceof Dialog) {
            windowTitle = ((Dialog)documentRoot).getTitle();
        }
        return windowTitle;
    }

    @NotNull
    public static Runnable wakeUpNeo(@NotNull Object reason) {
        if (reason == null) {
            MacUtil.$$$reportNull$$$0(6);
        }
        return new ActivityImpl(reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowFromJavaWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustFocusTraversal";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformWindow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateRootPane";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wakeUpNeo";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }

    private static final class ActivityImpl
    extends AtomicReference<ID>
    implements Runnable {
        private static final ID processInfoCls = Foundation.getObjcClass("NSProcessInfo");
        private static final Pointer processInfoSel = Foundation.createSelector("processInfo");
        private static final Pointer beginActivityWithOptionsReasonSel = Foundation.createSelector("beginActivityWithOptions:reason:");
        private static final Pointer endActivitySel = Foundation.createSelector("endActivity:");
        private static final Pointer retainSel = Foundation.createSelector("retain");
        private static final Pointer releaseSel = Foundation.createSelector("release");

        private ActivityImpl(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(0);
            }
            super(ActivityImpl.begin(reason));
        }

        @Override
        public void run() {
            ActivityImpl.end(this.getAndSet(null));
        }

        private static ID getProcessInfo() {
            return Foundation.invoke(processInfoCls, processInfoSel, new Object[0]);
        }

        private static ID begin(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(1);
            }
            return Foundation.invoke(Foundation.invoke(ActivityImpl.getProcessInfo(), beginActivityWithOptionsReasonSel, 0xEFFFFFL, Foundation.nsString(reason.toString())), retainSel, new Object[0]);
        }

        private static void end(@Nullable ID activityToken) {
            if (activityToken == null) {
                return;
            }
            Foundation.invoke(ActivityImpl.getProcessInfo(), endActivitySel, activityToken);
            Foundation.invoke(activityToken, releaseSel, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "reason";
            objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil$ActivityImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "begin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NSActivityOptions {
        private static final long idleSystemSleepDisabled = 0x100000L;
        private static final long userInitiated = 0xFFFFFFL;
        private static final long userInitiatedAllowingIdleSystemSleep = 0xEFFFFFL;
        private static final long latencyCritical = 0xFF00000000L;

        private NSActivityOptions() {
        }
    }
}

