/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NSColor {
    @Nullable
    public static Color getHighlightColor() {
        if (!SystemInfo.isMac) {
            return null;
        }
        return NSColor._getNSColor("selectedControlColor");
    }

    @Nullable
    public static Color getAccentColor() {
        if (!SystemInfo.isMac || !SystemInfo.isOsVersionAtLeast("10.14")) {
            return null;
        }
        return NSColor._getNSColor("controlAccentColor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Color _getNSColor(@NotNull String selector) {
        if (selector == null) {
            NSColor.$$$reportNull$$$0(0);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID nsCol = Foundation.invoke(Foundation.invoke("NSColor", selector, new Object[0]), "colorUsingColorSpace:", Foundation.invoke("NSColorSpace", "genericRGBColorSpace", new Object[0]));
            if (nsCol.equals(ID.NIL)) {
                Color color = null;
                return color;
            }
            double nsRed = Foundation.invoke_fpret(nsCol, "redComponent", new Object[0]);
            double nsGreen = Foundation.invoke_fpret(nsCol, "greenComponent", new Object[0]);
            double nsBlue = Foundation.invoke_fpret(nsCol, "blueComponent", new Object[0]);
            double nsAlpha = Foundation.invoke_fpret(nsCol, "alphaComponent", new Object[0]);
            Color color = new Color((float)nsRed, (float)nsGreen, (float)nsBlue, (float)nsAlpha);
            return color;
        }
        finally {
            pool.drain();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/ui/mac/foundation/NSColor", "_getNSColor"));
    }
}

