/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NSDefaults {
    private static final Logger LOG = Logger.getInstance(NSDefaults.class);
    private static final String ourTouchBarDomain = "com.apple.touchbar.agent";
    private static final String ourPerAppKey = "PresentationModePerApp";
    private static final String ourGlobalKey = "PresentationModeGlobal";
    private static final String ourShowFnValue = "functionKeys";
    private static final String TEST_APP_ID = "com.apple.terminal";

    public static String readStringVal(String domain, String key) {
        Path result2 = new Path();
        result2.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result2.readStringVal(key);
    }

    public static boolean isDomainExists(String domain) {
        Path result2 = new Path();
        result2.myPath.add(new Path.Node("persistentDomainForName:", domain));
        return result2.lastValidPos() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPersistentDomain(@NotNull String domainName, @Nullable Map<String, Object> values2) {
        if (domainName == null) {
            NSDefaults.$$$reportNull$$$0(0);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults.equals(ID.NIL)) {
                return;
            }
            ID dict = Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
            if (values2 != null) {
                for (Map.Entry<String, Object> me : values2.entrySet()) {
                    Object val = me.getValue();
                    if (val instanceof String) {
                        Foundation.invoke(dict, "setObject:forKey:", Foundation.nsString((String)val), Foundation.nsString(me.getKey()));
                        continue;
                    }
                    if (val instanceof Map) {
                        ID internalDict = Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
                        Foundation.invoke(dict, "setObject:forKey:", internalDict, Foundation.nsString(me.getKey()));
                        continue;
                    }
                    LOG.error("unsupported type of domain value: " + val);
                }
            }
            Foundation.invoke(defaults, "setPersistentDomain:forName:", dict, Foundation.nsString(domainName));
        }
        finally {
            pool.drain();
        }
    }

    public static void removePersistentDomain(@NotNull String domainName) {
        if (domainName == null) {
            NSDefaults.$$$reportNull$$$0(1);
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults.equals(ID.NIL)) {
                return;
            }
            Foundation.invoke(defaults, "removePersistentDomainForName:", Foundation.nsString(domainName));
        }
        finally {
            pool.drain();
        }
    }

    public static boolean isShowFnKeysEnabled(String appId) {
        Path p = new Path();
        p.myPath.add(new Path.Node("persistentDomainForName:", ourTouchBarDomain));
        String sval = p.readStringVal(ourGlobalKey);
        if (sval != null && sval.equals(ourShowFnValue)) {
            return true;
        }
        p.myPath.add(new Path.Node("objectForKey:", ourPerAppKey));
        sval = p.readStringVal(appId);
        return sval != null && sval.equals(ourShowFnValue);
    }

    public static boolean isFnShowsAppControls() {
        Path p = new Path();
        p.myPath.add(new Path.Node("persistentDomainForName:", ourTouchBarDomain));
        p.myPath.add(new Path.Node("objectForKey:", "PresentationModeFnModes"));
        String sval = p.readStringVal(ourShowFnValue);
        return sval != null && sval.equals("app");
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val) {
        return NSDefaults.setShowFnKeysEnabled(appId, val, false);
    }

    public static boolean setShowFnKeysEnabled(String appId, boolean val, boolean performExtraDebugChecks) {
        if (!NSDefaults.isDomainExists(ourTouchBarDomain)) {
            HashMap<String, Object> vals = new HashMap<String, Object>();
            vals.put(ourPerAppKey, new HashMap());
            NSDefaults.createPersistentDomain(ourTouchBarDomain, vals);
            if (!NSDefaults.isDomainExists(ourTouchBarDomain)) {
                LOG.error("can't create domain 'com.apple.touchbar.agent'");
                return false;
            }
        }
        Path path2 = new Path();
        path2.myPath.add(new Path.Node("persistentDomainForName:", ourTouchBarDomain));
        path2.myPath.add(new Path.Node("objectForKey:", ourPerAppKey));
        String sval = path2.readStringVal(appId);
        boolean settingEnabled = sval != null && sval.equals(ourShowFnValue);
        String initDesc = "appId='" + appId + "', value (requested be set) ='" + val + "', initial path (tail) value = '" + sval + "', path='" + path2 + "'";
        if (val == settingEnabled) {
            if (performExtraDebugChecks) {
                LOG.error("nothing to change: " + initDesc);
            }
            return false;
        }
        path2.writeStringValue(appId, val ? ourShowFnValue : null);
        if (performExtraDebugChecks) {
            boolean isFNEnabled;
            sval = path2.readStringVal(appId, true);
            boolean bl = isFNEnabled = sval != null && sval.equals(ourShowFnValue);
            if (val != isFNEnabled) {
                LOG.error("can't write value '" + val + "' (was written just now, but read '" + sval + "'): " + initDesc);
            } else {
                LOG.error("value '" + val + "' was written from second attempt: " + initDesc);
            }
        }
        return true;
    }

    public static String testTouchBarSettingsWrite() {
        if (NSDefaults.isDomainExists(ourTouchBarDomain)) {
            NSDefaults.removePersistentDomain(ourTouchBarDomain);
            if (NSDefaults.isDomainExists(ourTouchBarDomain)) {
                return "can't delete domain: com.apple.touchbar.agent";
            }
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put("TestNSDefaultsKey", "TestNSDefaultsValue");
        vals.put(ourPerAppKey, new HashMap());
        NSDefaults.createPersistentDomain(ourTouchBarDomain, vals);
        if (!NSDefaults.isDomainExists(ourTouchBarDomain)) {
            return "can't create domain: com.apple.touchbar.agent";
        }
        boolean enabled = NSDefaults.isShowFnKeysEnabled(TEST_APP_ID);
        NSDefaults.setShowFnKeysEnabled(TEST_APP_ID, !enabled);
        if (NSDefaults.isShowFnKeysEnabled(TEST_APP_ID) == enabled) {
            return "can't write com.apple.touchbar.agent.PresentationModePerApp=" + !enabled;
        }
        NSDefaults.setShowFnKeysEnabled(TEST_APP_ID, enabled);
        return NSDefaults.isShowFnKeysEnabled(TEST_APP_ID) == enabled ? null : "can't write com.apple.touchbar.agent.PresentationModePerApp=" + enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDarkMenuBar() {
        assert (SystemInfoRt.isMac);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            if (defaults.equals(ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            ID valObj = Foundation.invoke(defaults, "objectForKey:", Foundation.nsString("AppleInterfaceStyle"));
            if (valObj.equals(ID.NIL)) {
                boolean bl = false;
                return bl;
            }
            String sval = Foundation.toStringViaUTF8(valObj);
            boolean bl = sval != null && sval.equals("Dark");
            return bl;
        }
        finally {
            pool.drain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _listAllKeys() {
        ArrayList<String> res = new ArrayList<String>(100);
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            ID allKeysDict = Foundation.invoke(defaults, "dictionaryRepresentation", new Object[0]);
            ID allKeysArr = Foundation.invoke(allKeysDict, "allKeys", new Object[0]);
            ID count2 = Foundation.invoke(allKeysArr, "count", new Object[0]);
            for (int c2 = 0; c2 < count2.intValue(); ++c2) {
                ID nsKeyName = Foundation.invoke(allKeysArr, "objectAtIndex:", c2);
                String keyName = Foundation.toStringViaUTF8(nsKeyName);
                res.add(keyName);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            pool.drain();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "domainName";
        objectArray2[1] = "com/intellij/ui/mac/foundation/NSDefaults";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPersistentDomain";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removePersistentDomain";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Path {
        @NotNull
        private final ArrayList<Node> myPath = new ArrayList();

        private Path() {
        }

        public String toString() {
            return this.myPath.stream().map(Node::toString).collect(Collectors.joining(" | "));
        }

        String readStringVal(@NotNull String key) {
            if (key == null) {
                Path.$$$reportNull$$$0(0);
            }
            return this.readStringVal(key, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String readStringVal(@NotNull String key, boolean doSynchronize) {
            if (key == null) {
                Path.$$$reportNull$$$0(1);
            }
            if (this.myPath.isEmpty()) {
                return null;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults.equals(ID.NIL)) {
                    String string2 = null;
                    return string2;
                }
                if (doSynchronize) {
                    Foundation.invoke(defaults, "synchronize", new Object[0]);
                }
                this._readPath(defaults);
                Node tail = this.myPath.get(this.myPath.size() - 1);
                if (!tail.isValid()) {
                    String string3 = null;
                    return string3;
                }
                ID valObj = Foundation.invoke(tail.cachedNodeObj, "objectForKey:", Foundation.nsString(key));
                if (valObj.equals(ID.NIL)) {
                    String string4 = null;
                    return string4;
                }
                String string5 = Foundation.toStringViaUTF8(valObj);
                return string5;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeStringValue(@NotNull String key, String val) {
            if (key == null) {
                Path.$$$reportNull$$$0(2);
            }
            if (this.myPath.isEmpty()) {
                return;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults.equals(ID.NIL)) {
                    return;
                }
                this._readPath(defaults);
                int pos = this.myPath.size() - 1;
                Node child = this.myPath.get(pos--);
                if (!child.isValid() && val == null) {
                    return;
                }
                child.writeStringValue(key, val);
                while (pos >= 0) {
                    Node parent2 = this.myPath.get(pos--);
                    ID mnode = Foundation.invoke(parent2.cachedNodeObj, "mutableCopy", new Object[0]);
                    Foundation.invoke(mnode, "setObject:forKey:", child.cachedNodeObj, Foundation.nsString(child.myNodeName));
                    parent2.cachedNodeObj = mnode;
                    child = parent2;
                }
                String topWriteSelector = child.isDomain() ? "setPersistentDomain:forName:" : "setObject:forKey:";
                Foundation.invoke(defaults, topWriteSelector, child.cachedNodeObj, Foundation.nsString(child.myNodeName));
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastValidPos() {
            if (this.myPath.isEmpty()) {
                return -1;
            }
            Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
            try {
                ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
                if (defaults.equals(ID.NIL)) {
                    int n = -1;
                    return n;
                }
                this._readPath(defaults);
                for (int pos = 0; pos < this.myPath.size(); ++pos) {
                    Node pn = this.myPath.get(pos);
                    if (pn.isValid()) continue;
                    int n = pos - 1;
                    return n;
                }
                int n = this.myPath.size() - 1;
                return n;
            }
            finally {
                pool.drain();
                this._resetPathCache();
            }
        }

        private void _readPath(ID parent2) {
            if (this.myPath.isEmpty()) {
                return;
            }
            for (Node pn : this.myPath) {
                pn.readNode(parent2);
                if (!pn.isValid()) {
                    return;
                }
                parent2 = pn.cachedNodeObj;
            }
        }

        private void _resetPathCache() {
            for (Node pn : this.myPath) {
                pn.cachedNodeObj = ID.NIL;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/ui/mac/foundation/NSDefaults$Path";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readStringVal";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeStringValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class Node {
            @NotNull
            private final String mySelector;
            @NotNull
            private final String myNodeName;
            @NotNull
            private ID cachedNodeObj;

            Node(@NotNull String selector, @NotNull String nodeName) {
                if (selector == null) {
                    Node.$$$reportNull$$$0(0);
                }
                if (nodeName == null) {
                    Node.$$$reportNull$$$0(1);
                }
                this.cachedNodeObj = ID.NIL;
                this.mySelector = selector;
                this.myNodeName = nodeName;
            }

            public String toString() {
                return String.format("sel='%s' nodeName='%s'", this.mySelector, this.myNodeName);
            }

            boolean isValid() {
                return !this.cachedNodeObj.equals(ID.NIL);
            }

            boolean isDomain() {
                return this.mySelector.equals("persistentDomainForName:");
            }

            void readNode(ID parent2) {
                this.cachedNodeObj = ID.NIL;
                if (parent2 == null || parent2.equals(ID.NIL)) {
                    return;
                }
                ID nodeObj = Foundation.invoke(parent2, this.mySelector, Foundation.nsString(this.myNodeName));
                if (nodeObj.equals(ID.NIL)) {
                    return;
                }
                this.cachedNodeObj = nodeObj;
            }

            @NotNull
            private static ID _createDictionary() {
                ID iD = Foundation.invoke("NSMutableDictionary", "new", new Object[0]);
                if (iD == null) {
                    Node.$$$reportNull$$$0(2);
                }
                return iD;
            }

            void writeStringValue(@NotNull String key, String val) {
                ID mnode;
                if (key == null) {
                    Node.$$$reportNull$$$0(3);
                }
                if (!this.isValid()) {
                    if (val == null) {
                        return;
                    }
                    mnode = Node._createDictionary();
                } else {
                    mnode = Foundation.invoke(this.cachedNodeObj, "mutableCopy", new Object[0]);
                }
                if (mnode.equals(ID.NIL)) {
                    return;
                }
                if (val != null) {
                    Foundation.invoke(mnode, "setObject:forKey:", Foundation.nsString(val), Foundation.nsString(key));
                } else {
                    Foundation.invoke(mnode, "removeObjectForKey:", Foundation.nsString(key));
                }
                this.cachedNodeObj = mnode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selector";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodeName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/mac/foundation/NSDefaults$Path$Node";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/mac/foundation/NSDefaults$Path$Node";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "_createDictionary";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "writeStringValue";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 2 -> new IllegalStateException(string2);
                };
            }
        }
    }
}

