/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PaintUtil {
    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(0);
        }
        return PaintUtil.getParityMode(usrValue, ScaleContext.create((Graphics2D)g), null);
    }

    /*
     * WARNING - void declaration
     */
    public static ParityMode getParityMode(double usrValue, @NotNull ScaleContext ctx, @Nullable RoundingMode roundingMode) {
        void rm;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(1);
        }
        int devValue = PaintUtil.devValue(usrValue, PaintUtil.getScale(ctx), (RoundingMode)((Object)(rm == null ? RoundingMode.ROUND : rm)));
        return ParityMode.of(devValue);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(2);
        }
        return PaintUtil.alignToInt(usrValue, ScaleContext.create((Graphics2D)g), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable RoundingMode roundingMode) {
        void rm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(3);
        }
        return PaintUtil.alignToInt(usrValue, ScaleContext.create(g), (RoundingMode)rm, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull Graphics2D g, @Nullable ParityMode parityMode) {
        void pm;
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(4);
        }
        return PaintUtil.alignToInt(usrValue, ScaleContext.create(g), null, (ParityMode)pm);
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull ScaleContext ctx, @Nullable RoundingMode rm, @Nullable ParityMode parityMode) {
        void pm;
        double scale;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(5);
        }
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        if ((scale = PaintUtil.getScale(ctx)) == 0.0) {
            return 0.0;
        }
        int devValue = PaintUtil.devValue(usrValue, scale, pm != null && rm == RoundingMode.ROUND ? RoundingMode.FLOOR : rm);
        if (pm != null && ParityMode.of(devValue) != pm) {
            devValue += rm == RoundingMode.FLOOR ? -1 : 1;
        }
        return (double)devValue / scale;
    }

    public static int alignIntToInt(int usrValue, @NotNull ScaleContext ctx, @NotNull RoundingMode rm, @Nullable ParityMode pm) {
        int result2;
        int maxAttempts;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(6);
        }
        if (rm == null) {
            PaintUtil.$$$reportNull$$$0(7);
        }
        if (rm != RoundingMode.FLOOR && rm != RoundingMode.CEIL) {
            throw new IllegalArgumentException("Invalid value of rounding mode: " + rm + ", only FLOOR and CEIL are supported");
        }
        int attempts = 0;
        int n = maxAttempts = pm == null ? 4 : 8;
        for (result2 = usrValue; result2 >= 0 && PaintUtil.isNotSuitablyAlignedToInt(result2, ctx, pm); result2 += rm == RoundingMode.FLOOR ? -1 : 1) {
            if (++attempts <= maxAttempts) continue;
            return usrValue;
        }
        return result2;
    }

    private static boolean isNotSuitablyAlignedToInt(int value, @NotNull ScaleContext ctx, @Nullable ParityMode pm) {
        double scaled;
        int rounded;
        if (ctx == null) {
            PaintUtil.$$$reportNull$$$0(8);
        }
        boolean aligned = Math.abs((double)(rounded = (int)Math.round(scaled = PaintUtil.devValue((double)value, ctx))) - scaled) < 1.0E-4;
        boolean parityMatches = pm == null || ParityMode.of(rounded) == pm;
        return !aligned || !parityMatches;
    }

    /*
     * WARNING - void declaration
     */
    public static double alignToInt(double usrValue, @NotNull ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(9);
        }
        return PaintUtil.alignToInt(usrValue, (ScaleContext)ctx, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull Graphics2D graphics2D) {
        void g;
        if (graphics2D == null) {
            PaintUtil.$$$reportNull$$$0(10);
        }
        return PaintUtil.devValue(usrValue, ScaleContext.create((Graphics2D)g));
    }

    /*
     * WARNING - void declaration
     */
    public static double devValue(double usrValue, @NotNull ScaleContext scaleContext) {
        void ctx;
        if (scaleContext == null) {
            PaintUtil.$$$reportNull$$$0(11);
        }
        return usrValue * PaintUtil.getScale((ScaleContext)ctx);
    }

    private static int devValue(double usrValue, double scale, @Nullable RoundingMode rm) {
        if (rm == null) {
            rm = RoundingMode.ROUND;
        }
        return rm.round(usrValue * scale);
    }

    public static double devPixel(Graphics2D g) {
        return 1.0 / PaintUtil.devValue(1.0, g);
    }

    private static double getScale(ScaleContext ctx) {
        double scale;
        double d = scale = ctx.getScale(ScaleType.USR_SCALE) == 0.0 ? 0.0 : ctx.getScale(DerivedScaleType.PIX_SCALE) / ctx.getScale(ScaleType.USR_SCALE);
        if (scale <= 0.0) {
            // empty if block
        }
        return scale;
    }

    @Nullable
    public static AffineTransform alignTxToInt(@NotNull Graphics2D g, @Nullable Point2D offset2, boolean alignX, boolean alignY, RoundingMode rm) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(12);
        }
        try {
            AffineTransform tx = g.getTransform();
            if (PaintUtil.isFractionalScale(tx)) {
                double scaleX = tx.getScaleX();
                double scaleY = tx.getScaleY();
                AffineTransform alignedTx = new AffineTransform();
                double trX = tx.getTranslateX();
                double trY = tx.getTranslateY();
                if (alignX) {
                    double offX = trX + (offset2 != null ? offset2.getX() * scaleX : 0.0);
                    trX += (double)rm.round(offX) - offX;
                }
                if (alignY) {
                    double offY = trY + (offset2 != null ? offset2.getY() * scaleY : 0.0);
                    trY += (double)rm.round(offY) - offY;
                }
                alignedTx.translate(trX, trY);
                alignedTx.scale(scaleX, scaleY);
                assert (tx.getShearX() == 0.0 && tx.getShearY() == 0.0);
                g.setTransform(alignedTx);
                return tx;
            }
        }
        catch (Exception e) {
            Logger.getInstance(PaintUtil.class).error(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Shape alignClipToInt(@NotNull Graphics2D g, boolean alignH, boolean alignV, RoundingMode xyRM, RoundingMode whRM) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(13);
        }
        AffineTransform transform2 = g.getTransform();
        double scaleX = transform2.getScaleX();
        double scaleY = transform2.getScaleY();
        g.scale(1.0 / scaleX, 1.0 / scaleY);
        try {
            Shape clip = g.getClip();
            if (clip instanceof Rectangle2D) {
                Rectangle2D rect2 = (Rectangle2D)clip;
                if (PaintUtil.isFractionalScale(transform2)) {
                    double x = rect2.getX();
                    double y = rect2.getY();
                    double w = rect2.getWidth();
                    double h = rect2.getHeight();
                    if (alignH) {
                        x = PaintUtil.alignToInt(rect2.getX(), g, xyRM);
                        w = PaintUtil.alignToInt(rect2.getX() + rect2.getWidth(), g, whRM) - x;
                    }
                    if (alignV) {
                        y = PaintUtil.alignToInt(rect2.getY(), g, xyRM);
                        h = PaintUtil.alignToInt(rect2.getY() + rect2.getHeight(), g, whRM) - y;
                    }
                    g.setClip(new Rectangle2D.Double(x, y, w, h));
                    Shape shape = clip;
                    return shape;
                }
            }
            Shape shape = null;
            return shape;
        }
        finally {
            g.scale(scaleX, scaleY);
        }
    }

    @NotNull
    public static Point2D getFractOffsetInRootPane(@NotNull JComponent comp) {
        if (comp == null) {
            PaintUtil.$$$reportNull$$$0(14);
        }
        if (!comp.isShowing() || !PaintUtil.isFractionalScale(comp.getGraphicsConfiguration().getDefaultTransform())) {
            return new Point2D.Double();
        }
        int x = 0;
        int y = 0;
        while (!(comp instanceof JRootPane) && comp != null) {
            x += comp.getX();
            y += comp.getY();
            comp = (JComponent)comp.getParent();
        }
        double scale = JBUIScale.sysScale(comp);
        double sx = (double)x * scale;
        double sy = (double)y * scale;
        return new Point2D.Double((sx - (double)((int)sx)) / scale, (sy - (double)((int)sy)) / scale);
    }

    @NotNull
    public static Point2D negate(@NotNull Point2D pt) {
        if (pt == null) {
            PaintUtil.$$$reportNull$$$0(15);
        }
        return new Point2D.Double(-pt.getX(), -pt.getY());
    }

    public static boolean isFractionalScale(@NotNull AffineTransform tx) {
        if (tx == null) {
            PaintUtil.$$$reportNull$$$0(16);
        }
        double scaleX = tx.getScaleX();
        double scaleY = tx.getScaleY();
        return scaleX != (double)((int)scaleX) || scaleY != (double)((int)scaleY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintWithAA(@NotNull Graphics2D g, @NotNull Object valueAA, @NotNull Runnable paint2) {
        if (g == null) {
            PaintUtil.$$$reportNull$$$0(17);
        }
        if (valueAA == null) {
            PaintUtil.$$$reportNull$$$0(18);
        }
        if (paint2 == null) {
            PaintUtil.$$$reportNull$$$0(19);
        }
        if (valueAA == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            paint2.run();
            return;
        }
        Object key = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, valueAA);
        try {
            paint2.run();
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, key);
        }
    }

    @NotNull
    public static Point2D insets2offset(@Nullable Insets in) {
        return in == null ? new Point2D.Double(0.0, 0.0) : new Point2D.Double(in.left, in.top);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pt";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tx";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/paint/PaintUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParityMode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "alignToInt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "alignIntToInt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotSuitablyAlignedToInt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "devValue";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "alignTxToInt";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "alignClipToInt";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getFractOffsetInRootPane";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "negate";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isFractionalScale";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "paintWithAA";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum RoundingMode {
        FLOOR{

            @Override
            public int round(double value) {
                return (int)Math.floor(value);
            }
        }
        ,
        CEIL{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value);
            }
        }
        ,
        ROUND{

            @Override
            public int round(double value) {
                return (int)Math.round(value);
            }
        }
        ,
        ROUND_FLOOR_BIAS{

            @Override
            public int round(double value) {
                return (int)Math.ceil(value - 0.5);
            }
        };


        public abstract int round(double var1);
    }

    public static enum ParityMode {
        EVEN,
        ODD;


        public boolean even() {
            return this == EVEN;
        }

        public static ParityMode of(int value) {
            return value % 2 == 0 ? EVEN : ODD;
        }

        public static ParityMode invert(ParityMode pm) {
            return pm == EVEN ? ODD : EVEN;
        }
    }
}

