/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J&\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u00152\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0002J\u001a\u0010!\u001a\u00020\u00052\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0007J(\u0010(\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00160\u00152\u0010\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0007J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020*H\u0007J\u0018\u0010+\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fH\u0007J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0007J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016H\u0007J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0005H\u0007J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u001f\u00100\u001a\u0002H1\"\b\b\u0000\u00101*\u0002022\u0006\u00103\u001a\u0002H1H\u0007\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u0005H\u0007J\u0010\u00107\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0010\u00108\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u00106\u001a\u00020\u0005H\u0007J\u0012\u00106\u001a\u00020*2\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0012\u00106\u001a\u00020\u00052\b\u0010<\u001a\u0004\u0018\u00010=H\u0007J\u0012\u00106\u001a\u00020\u00052\b\u0010>\u001a\u0004\u0018\u00010?H\u0007J\u0012\u00106\u001a\u00020\u00052\b\u0010>\u001a\u0004\u0018\u00010@H\u0007J\u0012\u00106\u001a\u00020\u00052\b\u0010A\u001a\u0004\u0018\u00010BH\u0007R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00160\u00150\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/ui/scale/JBUIScale;", "", "()V", "DEBUG_USER_SCALE_FACTOR", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "DEF_SYSTEM_FONT_SIZE", "DISCRETE_SCALE_RESOLUTION", "PROPERTY_CHANGE_SUPPORT", "Ljava/beans/PropertyChangeSupport;", "SCALE_VERBOSE", "", "USER_SCALE_FACTOR_PROPERTY", "", "isUsrHiDPI", "isUsrHiDPI$annotations", "()Z", "screenScale", "getScreenScale", "()F", "systemFontData", "Lkotlin/Pair;", "", "systemScaleFactor", "userScaleFactor", "addUserScaleChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "computeSystemFontData", "uiDefaults", "Ljava/util/function/Supplier;", "Ljavax/swing/UIDefaults;", "computeSystemScaleFactor", "computeUserScaleFactor", "value", "discreteScale", "scale", "getFontScale", "fontSize", "getSystemFontData", "isHiDPI", "", "preload", "removeUserScaleChangeListener", "f", "i", "scaleFontSize", "scaleIcon", "T", "Lcom/intellij/util/ui/JBScalableIcon;", "icon", "(Lcom/intellij/util/ui/JBScalableIcon;)Lcom/intellij/util/ui/JBScalableIcon;", "setSystemScaleFactor", "sysScale", "setUserScaleFactor", "setUserScaleFactorForTest", "setUserScaleFactorProperty", "context", "Lcom/intellij/ui/scale/ScaleContext;", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "Ljava/awt/Graphics;", "gc", "Ljava/awt/GraphicsConfiguration;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nJBUIScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBUIScale.kt\ncom/intellij/ui/scale/JBUIScale\n+ 2 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n19#2,5:430\n19#2,5:435\n8#3:440\n8#3:441\n8#3:442\n1#4:443\n*S KotlinDebug\n*F\n+ 1 JBUIScale.kt\ncom/intellij/ui/scale/JBUIScale\n*L\n42#1:430,5\n49#1:435,5\n100#1:440\n191#1:441\n214#1:442\n*E\n"})
public final class JBUIScale {
    @NotNull
    public static final JBUIScale INSTANCE = new JBUIScale();
    @JvmField
    @ApiStatus.Internal
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    @NotNull
    private static final String USER_SCALE_FACTOR_PROPERTY = "JBUIScale.userScaleFactor";
    @NotNull
    private static final SynchronizedClearableLazy<Float> userScaleFactor = new SynchronizedClearableLazy(userScaleFactor.1.INSTANCE);
    @NotNull
    private static final SynchronizedClearableLazy<Float> systemScaleFactor = new SynchronizedClearableLazy(systemScaleFactor.1.INSTANCE);
    @NotNull
    private static final PropertyChangeSupport PROPERTY_CHANGE_SUPPORT = new PropertyChangeSupport(INSTANCE);
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    @JvmField
    public static float DEF_SYSTEM_FONT_SIZE = 12.0f;
    @NotNull
    private static SynchronizedClearableLazy<Pair<String, Integer>> systemFontData = new SynchronizedClearableLazy(systemFontData.1.INSTANCE);
    @ApiStatus.Internal
    @JvmField
    @NotNull
    public static final SynchronizedClearableLazy<Float> DEBUG_USER_SCALE_FACTOR = new SynchronizedClearableLazy(DEBUG_USER_SCALE_FACTOR.1.INSTANCE);

    private JBUIScale() {
    }

    @ApiStatus.Internal
    public final void preload(@NotNull Supplier<UIDefaults> uiDefaults) {
        Activity activity$iv;
        boolean $i$f$runActivity;
        ActivityCategory category$iv;
        String name$iv;
        Intrinsics.checkNotNullParameter(uiDefaults, (String)"uiDefaults");
        if (!systemScaleFactor.isInitialized()) {
            name$iv = "system scale factor computation";
            category$iv = ActivityCategory.DEFAULT;
            $i$f$runActivity = false;
            activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity(name$iv, category$iv) : null;
            boolean bl = false;
            float it = INSTANCE.computeSystemScaleFactor(uiDefaults);
            boolean bl2 = false;
            systemScaleFactor.setValue(Float.valueOf(it));
            Unit result$iv = Unit.INSTANCE;
            Activity activity = activity$iv;
            if (activity != null) {
                activity.end();
            }
        }
        name$iv = "user scale factor computation";
        category$iv = ActivityCategory.DEFAULT;
        $i$f$runActivity = false;
        activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity(name$iv, category$iv) : null;
        boolean bl = false;
        float result$iv = ((Number)userScaleFactor.getValue()).floatValue();
        Activity activity = activity$iv;
        if (activity != null) {
            activity.end();
        }
        JBUIScale.getSystemFontData(uiDefaults);
    }

    @JvmStatic
    public static final void addUserScaleChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        PROPERTY_CHANGE_SUPPORT.addPropertyChangeListener(USER_SCALE_FACTOR_PROPERTY, listener2);
    }

    @JvmStatic
    public static final void removeUserScaleChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        PROPERTY_CHANGE_SUPPORT.removePropertyChangeListener(USER_SCALE_FACTOR_PROPERTY, listener2);
    }

    private final Pair<String, Integer> computeSystemFontData(Supplier<UIDefaults> uiDefaults) {
        Font winFont;
        Object object;
        Object object2;
        if (GraphicsEnvironment.isHeadless()) {
            return new Pair((Object)"Dialog", (Object)12);
        }
        Font font = null;
        if (SystemInfoRt.isMac) {
            font = new Font(".SF NS Text", 0, 13);
            DEF_SYSTEM_FONT_SIZE = font.getSize();
        } else {
            Font font2;
            Supplier<UIDefaults> supplier2 = uiDefaults;
            if (supplier2 == null) {
                Font font3 = UIManager.getFont("Label.font");
                font2 = font3;
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"getFont(\"Label.font\")");
            } else {
                UIDefaults uIDefaults = supplier2.get();
                Intrinsics.checkNotNull((Object)uIDefaults);
                Font font4 = uIDefaults.getFont("Label.font");
                font2 = font4;
                Intrinsics.checkNotNullExpressionValue((Object)font4, (String)"uiDefaults.get()!!.getFont(\"Label.font\")");
            }
            font = font2;
        }
        JBUIScale $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JBUIScale.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        Logger log = logger;
        boolean isScaleVerbose = SCALE_VERBOSE;
        if (isScaleVerbose) {
            String string2 = "Label font: %s, %d";
            object2 = new Object[]{font.getFontName(), font.getSize()};
            String string3 = String.format(string2, Arrays.copyOf(object2, ((Object[])object2).length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            log.info(string3);
        }
        if (SystemInfoRt.isLinux) {
            Object value = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/DPI");
            if (isScaleVerbose) {
                object2 = "gnome.Xft/DPI: %s";
                object = new Object[]{value};
                String string4 = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                log.info(string4);
            }
            if (value instanceof Integer) {
                int dpi = ((Number)value).intValue() / 1024;
                if (dpi < 50) {
                    dpi = 50;
                }
                float scale = JreHiDpiUtil.isJreHiDPIEnabled() ? 1.0f : this.discreteScale((float)dpi / 96.0f);
                DEF_SYSTEM_FONT_SIZE = (float)font.getSize() / scale;
                if (isScaleVerbose) {
                    String string5 = "DEF_SYSTEM_FONT_SIZE: %.2f";
                    Object[] objectArray = new Object[]{Float.valueOf(DEF_SYSTEM_FONT_SIZE)};
                    String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
                    log.info(string6);
                }
            } else if (!SystemInfo.isJetBrainsJvm) {
                float size = DEF_SYSTEM_FONT_SIZE * this.getScreenScale();
                Font font5 = font.deriveFont(size);
                Intrinsics.checkNotNullExpressionValue((Object)font5, (String)"font.deriveFont(size)");
                font = font5;
                if (isScaleVerbose) {
                    object = "(Not-JB JRE) reset font size: %.2f";
                    Object[] objectArray = new Object[]{Float.valueOf(size)};
                    String string7 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
                    log.info(string7);
                }
            }
        } else if (SystemInfoRt.isWindows && (winFont = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) != null) {
            font = winFont;
            if (isScaleVerbose) {
                object2 = "Windows sys font: %s, %d";
                object = new Object[]{winFont.getFontName(), winFont.getSize()};
                String string8 = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(format, *args)");
                log.info(string8);
            }
        }
        Pair result2 = new Pair((Object)font.getName(), (Object)font.getSize());
        if (isScaleVerbose) {
            String string9 = "systemFontData: %s, %d";
            object = new Object[]{result2.getFirst(), result2.getSecond()};
            String string10 = String.format(string9, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(format, *args)");
            log.info(string10);
        }
        return result2;
    }

    private final float computeSystemScaleFactor(Supplier<UIDefaults> uiDefaults) {
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            return 1.0f;
        }
        if (JreHiDpiUtil.isJreHiDPIEnabled()) {
            GraphicsConfiguration gc;
            GraphicsDevice gd;
            GraphicsDevice graphicsDevice;
            try {
                graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            catch (HeadlessException ignore) {
                graphicsDevice = null;
            }
            GraphicsDevice graphicsDevice2 = gd = graphicsDevice;
            GraphicsConfiguration graphicsConfiguration = gc = graphicsDevice2 != null ? graphicsDevice2.getDefaultConfiguration() : null;
            if (gc == null || gc.getDevice().getType() == 1) {
                return 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        float result2 = JBUIScale.getFontScale(((Number)JBUIScale.getSystemFontData(uiDefaults).getSecond()).intValue());
        JBUIScale $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JBUIScale.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        logger.info("System scale factor: " + result2 + " (" + (JreHiDpiUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        return result2;
    }

    @JvmStatic
    @TestOnly
    public static final void setSystemScaleFactor(float sysScale) {
        systemScaleFactor.setValue(Float.valueOf(sysScale));
    }

    @JvmStatic
    @TestOnly
    public static final void setUserScaleFactorForTest(float value) {
        INSTANCE.setUserScaleFactorProperty(value);
    }

    private final void setUserScaleFactorProperty(float value) {
        Float oldValue = userScaleFactor.getValueIfInitialized();
        if (Intrinsics.areEqual((Float)oldValue, (float)value)) {
            return;
        }
        userScaleFactor.setValue(Float.valueOf(value));
        JBUIScale $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JBUIScale.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        logger.info("User scale factor: " + value);
        PROPERTY_CHANGE_SUPPORT.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, oldValue, Float.valueOf(value));
    }

    @JvmStatic
    public static final float getFontScale(float fontSize) {
        return fontSize / DEF_SYSTEM_FONT_SIZE;
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final float setUserScaleFactor(float value) {
        float scale = value;
        Float factor = DEBUG_USER_SCALE_FACTOR.getValue();
        if (factor != null) {
            if (Intrinsics.areEqual((float)scale, (Float)factor)) {
                INSTANCE.setUserScaleFactorProperty(factor.floatValue());
            }
            return factor.floatValue();
        }
        scale = INSTANCE.computeUserScaleFactor(scale);
        INSTANCE.setUserScaleFactorProperty(scale);
        return scale;
    }

    private final float computeUserScaleFactor(float value) {
        float scale = value;
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            return 1.0f;
        }
        if ((scale = this.discreteScale(scale)) < 1.0f && ((Number)systemScaleFactor.getValue()).floatValue() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfoRt.isLinux && scale == 1.25f && DEF_SYSTEM_FONT_SIZE == 12.0f) {
            return 1.0f;
        }
        return scale;
    }

    private final float discreteScale(float scale) {
        return (float)MathKt.roundToInt((float)(scale / 0.25f)) * 0.25f;
    }

    @JvmStatic
    public static final float sysScale() {
        return ((Number)systemScaleFactor.getValue()).floatValue();
    }

    @JvmStatic
    public static final float sysScale(@Nullable Component component2) {
        return component2 == null ? INSTANCE.sysScale() : JBUIScale.sysScale(component2.getGraphicsConfiguration());
    }

    @JvmStatic
    public static final float sysScale(@Nullable GraphicsConfiguration gc) {
        if (JreHiDpiUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() != 1) {
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return ((Number)systemScaleFactor.getValue()).floatValue();
    }

    @JvmStatic
    public static final float scale(float f) {
        return f * ((Number)userScaleFactor.getValue()).floatValue();
    }

    @JvmStatic
    public static final int scale(int i2) {
        return MathKt.roundToInt((float)(((Number)userScaleFactor.getValue()).floatValue() * (float)i2));
    }

    @JvmStatic
    @NotNull
    public static final <T extends JBScalableIcon> T scaleIcon(@NotNull T icon2) {
        Intrinsics.checkNotNullParameter(icon2, (String)"icon");
        JBScalableIcon jBScalableIcon = icon2.withIconPreScaled(false);
        Intrinsics.checkNotNull((Object)jBScalableIcon, (String)"null cannot be cast to non-null type T of com.intellij.ui.scale.JBUIScale.scaleIcon");
        return (T)jBScalableIcon;
    }

    @JvmStatic
    public static final int scaleFontSize(float fontSize) {
        return JBUIScale.scaleFontSize(fontSize, ((Number)userScaleFactor.getValue()).floatValue());
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final int scaleFontSize(float fontSize, float userScaleFactor2) {
        float f = userScaleFactor2;
        return (int)(f == 1.25f ? fontSize * 1.34f : (f == 1.75f ? fontSize * 1.67f : fontSize * userScaleFactor2));
    }

    private final float getScreenScale() {
        int n;
        try {
            n = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (HeadlessException ignored) {
            n = 96;
        }
        int dpi = n;
        return this.discreteScale((float)dpi / 96.0f);
    }

    @JvmStatic
    @NotNull
    public static final Pair<String, Integer> getSystemFontData(@Nullable Supplier<UIDefaults> uiDefaults) {
        Pair<String, Integer> pair;
        if (uiDefaults == null) {
            return systemFontData.getValue();
        }
        Pair<String, Integer> pair2 = systemFontData.getValueIfInitialized();
        if (pair2 != null) {
            Pair<String, Integer> it = pair2;
            boolean bl = false;
            return it;
        }
        Pair<String, Integer> it = pair = INSTANCE.computeSystemFontData(uiDefaults);
        boolean bl = false;
        systemFontData.setValue(it);
        return pair;
    }

    @JvmStatic
    public static final float sysScale(@Nullable Graphics g) {
        return JBUIScale.sysScale(g instanceof Graphics2D ? (Graphics2D)g : null);
    }

    @JvmStatic
    public static final float sysScale(@Nullable Graphics2D g) {
        block5: {
            block4: {
                if (g == null) break block4;
                if (JreHiDpiUtil.isJreHiDPIEnabled()) break block5;
            }
            return INSTANCE.sysScale();
        }
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
            return Math.abs((float)g.getTransform().getScaleX());
        }
        return JBUIScale.sysScale(gc);
    }

    @JvmStatic
    public static final double sysScale(@Nullable ScaleContext context2) {
        ScaleContext scaleContext = context2;
        return scaleContext != null ? scaleContext.getScale(ScaleType.SYS_SCALE) : (double)INSTANCE.sysScale();
    }

    @JvmStatic
    public static final boolean isHiDPI(double scale) {
        return !(scale == 1.0);
    }

    public static final boolean isUsrHiDPI() {
        return JBUIScale.isHiDPI(JBUIScale.scale(1.0f));
    }

    @JvmStatic
    public static /* synthetic */ void isUsrHiDPI$annotations() {
    }

    public static final /* synthetic */ float access$computeUserScaleFactor(JBUIScale $this, float value) {
        return $this.computeUserScaleFactor(value);
    }

    public static final /* synthetic */ SynchronizedClearableLazy access$getSystemScaleFactor$p() {
        return systemScaleFactor;
    }

    public static final /* synthetic */ float access$computeSystemScaleFactor(JBUIScale $this, Supplier uiDefaults) {
        return $this.computeSystemScaleFactor(uiDefaults);
    }

    public static final /* synthetic */ Pair access$computeSystemFontData(JBUIScale $this, Supplier uiDefaults) {
        return $this.computeSystemFontData(uiDefaults);
    }
}

