/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.ui.svg.ImageValue;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/svg/ImageValueExternalizer;", "Lorg/h2/mvstore/type/BasicDataType;", "Lcom/intellij/ui/svg/ImageValue;", "()V", "createStorage", "", "size", "", "(I)[Lcom/intellij/ui/svg/ImageValue;", "getMemory", "obj", "read", "buff", "Ljava/nio/ByteBuffer;", "write", "", "Lorg/h2/mvstore/WriteBuffer;", "intellij.platform.util.ui"})
final class ImageValueExternalizer
extends BasicDataType<ImageValue> {
    @NotNull
    public static final ImageValueExternalizer INSTANCE = new ImageValueExternalizer();

    private ImageValueExternalizer() {
    }

    public int getMemory(@NotNull ImageValue obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return (obj.data.length + 2) * 4;
    }

    @NotNull
    public ImageValue[] createStorage(int size) {
        return new ImageValue[size];
    }

    @NotNull
    public ImageValue read(@NotNull ByteBuffer buff) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        int actualWidth = 0;
        int actualHeight = 0;
        int format = buff.get() & 0xFF;
        if (format < 254) {
            actualWidth = format;
            actualHeight = format;
        } else if (format == 255) {
            actualHeight = actualWidth = DataUtils.readVarInt((ByteBuffer)buff);
        } else {
            actualWidth = DataUtils.readVarInt((ByteBuffer)buff);
            actualHeight = DataUtils.readVarInt((ByteBuffer)buff);
        }
        int[] ints = new int[actualWidth * actualHeight];
        buff.asIntBuffer().get(ints);
        buff.position(buff.position() + ints.length * 4);
        return new ImageValue(ints, actualWidth, actualHeight);
    }

    public void write(@NotNull WriteBuffer buff, @NotNull ImageValue obj) {
        Intrinsics.checkNotNullParameter((Object)buff, (String)"buff");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj.w == obj.h) {
            if (obj.w < 254) {
                buff.put((byte)obj.w);
            } else {
                buff.put((byte)-1);
                buff.putVarInt(obj.w);
            }
        } else {
            buff.put((byte)-2);
            buff.putVarInt(obj.w);
            buff.putVarInt(obj.h);
        }
        buff.put(obj.data);
    }
}

