/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.mvstore.MvstoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.ImageKeyDescriptor;
import com.intellij.ui.svg.ImageValue;
import com.intellij.ui.svg.ImageValueExternalizer;
import com.intellij.ui.svg.SvgCacheManagerKt;
import com.intellij.ui.svg.SvgCacheMapper;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.DataType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0010J&\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0012R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/svg/SvgCacheManager;", "", "dbFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "classifierToMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/h2/mvstore/MVMap;", "", "Lcom/intellij/ui/svg/ImageValue;", "mapBuilder", "Lorg/h2/mvstore/MVMap$Builder;", "store", "Lorg/h2/mvstore/MVStore;", "close", "", "loadFromCache", "Ljava/awt/image/BufferedImage;", "themeDigest", "", "imageBytes", "mapper", "Lcom/intellij/ui/svg/SvgCacheMapper;", "save", "storeLoadedImage", "image", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SvgCacheManager {
    @NotNull
    private final MVStore store;
    @NotNull
    private final ConcurrentHashMap<Float, MVMap<long[], ImageValue>> classifierToMap;
    @NotNull
    private final MVMap.Builder<long[], ImageValue> mapBuilder;

    public SvgCacheManager(@NotNull Path dbFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        this.classifierToMap = new ConcurrentHashMap(10);
        this.store = MvstoreKt.openOrRecreateStore(dbFile, (Function0<? extends Logger>)((Function0)1.INSTANCE));
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.keyType((DataType)ImageKeyDescriptor.INSTANCE);
        mapBuilder.valueType((DataType)ImageValueExternalizer.INSTANCE);
        this.mapBuilder = mapBuilder;
    }

    public final void close() {
        this.store.close();
    }

    public final void save() {
        this.store.commit();
    }

    @Nullable
    public final BufferedImage loadFromCache(@NotNull byte[] themeDigest, @NotNull byte[] imageBytes, @NotNull SvgCacheMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)themeDigest, (String)"themeDigest");
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        long[] key = SvgCacheManagerKt.access$getCacheKey(imageBytes, themeDigest);
        MVMap map2 = SvgCacheManagerKt.access$getMap(mapper, this.classifierToMap, this.store, (MVMap.MapBuilder)this.mapBuilder);
        try {
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            ImageValue imageValue = (ImageValue)map2.get((Object)key);
            if (imageValue == null) {
                return null;
            }
            ImageValue data2 = imageValue;
            BufferedImage image = SvgCacheManagerKt.access$readImage(data2);
            IconLoadMeasurer.svgCacheRead.end(start);
            return image;
        }
        catch (Throwable e) {
            SvgCacheManagerKt.access$getLOG().error(e);
            try {
                map2.remove((Object)key);
            }
            catch (Exception e1) {
                SvgCacheManagerKt.access$getLOG().error("Cannot remove invalid entry", e1);
            }
            return null;
        }
    }

    public final void storeLoadedImage(@NotNull byte[] themeDigest, @NotNull byte[] imageBytes, @NotNull SvgCacheMapper mapper, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)themeDigest, (String)"themeDigest");
        Intrinsics.checkNotNullParameter((Object)imageBytes, (String)"imageBytes");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        long[] key = SvgCacheManagerKt.access$getCacheKey(imageBytes, themeDigest);
        MVMap map2 = SvgCacheManagerKt.access$getMap(mapper, this.classifierToMap, this.store, (MVMap.MapBuilder)this.mapBuilder);
        map2.put((Object)key, (Object)SvgCacheManagerKt.access$writeImage(image));
    }
}

