/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.ImageValue;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgCacheMapper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.xxh3.Xxh3;
import sun.awt.image.SunWritableRaster;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001av\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0013\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001e\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u00130\u00192\u0006\u0010\u001b\u001a\u00020\u001c2$\u0010\u001d\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u0013\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u001eH\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002\u001a \u0010\u001f\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u001a\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0007H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "ZERO_POINT", "Ljava/awt/Point;", "createImage", "Ljava/awt/image/BufferedImage;", "w", "", "h", "dataBuffer", "Ljava/awt/image/DataBufferInt;", "getCacheKey", "", "imageBytes", "", "themeDigest", "getMap", "Lorg/h2/mvstore/MVMap;", "K", "V", "mapper", "Lcom/intellij/ui/svg/SvgCacheMapper;", "classifierToMap", "", "", "store", "Lorg/h2/mvstore/MVStore;", "mapBuilder", "Lorg/h2/mvstore/MVMap$MapBuilder;", "readImage", "value", "Lcom/intellij/ui/svg/ImageValue;", "Ljava/awt/Image;", "buffer", "Ljava/nio/ByteBuffer;", "writeImage", "image", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nSvgCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgCacheManager.kt\ncom/intellij/ui/svg/SvgCacheManagerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n10#2:236\n*S KotlinDebug\n*F\n+ 1 SvgCacheManager.kt\ncom/intellij/ui/svg/SvgCacheManagerKt\n*L\n28#1:236\n*E\n"})
public final class SvgCacheManagerKt {
    @NotNull
    private static final Point ZERO_POINT = new Point(0, 0);

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SvgCacheManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        return logger;
    }

    private static final long[] getCacheKey(byte[] imageBytes, byte[] themeDigest) {
        long[] lArray = new long[]{Xxh3.hash((byte[])imageBytes), Xxh3.seededHash((byte[])imageBytes, (long)4812324275L), Xxh3.hash((byte[])themeDigest)};
        return lArray;
    }

    private static final BufferedImage createImage(int w, int h, DataBufferInt dataBuffer) {
        ColorModel colorModel = ColorModel.getRGBdefault();
        Intrinsics.checkNotNull((Object)colorModel, (String)"null cannot be cast to non-null type java.awt.image.DirectColorModel");
        DirectColorModel colorModel2 = (DirectColorModel)colorModel;
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, w, h, w, colorModel2.getMasks(), ZERO_POINT);
        return new BufferedImage(colorModel2, raster, false, null);
    }

    private static final BufferedImage readImage(ImageValue value) {
        DataBufferInt dataBuffer = new DataBufferInt(value.data, value.data.length);
        SunWritableRaster.makeTrackable(dataBuffer);
        return SvgCacheManagerKt.createImage(value.w, value.h, dataBuffer);
    }

    @NotNull
    public static final Image readImage(@NotNull ByteBuffer buffer, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        DataBufferInt dataBuffer = new DataBufferInt(w * h);
        buffer.asIntBuffer().get(SunWritableRaster.stealData(dataBuffer, 0));
        SunWritableRaster.makeTrackable(dataBuffer);
        return SvgCacheManagerKt.createImage(w, h, dataBuffer);
    }

    private static final ImageValue writeImage(BufferedImage image) {
        DataBuffer dataBuffer;
        int w = image.getWidth();
        int h = image.getHeight();
        if (image.getType() == 2) {
            dataBuffer = image.getRaster().getDataBuffer();
        } else {
            BufferedImage convertedImage = new BufferedImage(w, h, 2);
            Graphics2D g = convertedImage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            dataBuffer = convertedImage.getRaster().getDataBuffer();
        }
        DataBuffer dataBuffer2 = dataBuffer;
        Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] nArray = SunWritableRaster.stealData((DataBufferInt)dataBuffer2, 0);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"stealData(dataBuffer as DataBufferInt, 0)");
        return new ImageValue(nArray, w, h);
    }

    private static final <K, V> MVMap<K, V> getMap(SvgCacheMapper mapper, Map<Float, MVMap<K, V>> classifierToMap, MVStore store, MVMap.MapBuilder<MVMap<K, V>, K, V> mapBuilder) {
        MVMap mVMap = classifierToMap.computeIfAbsent(Float.valueOf(mapper.getKey$intellij_platform_util_ui()), arg_0 -> SvgCacheManagerKt.getMap$lambda$0((Function1)new Function1<Float, MVMap<K, V>>(store, mapper, mapBuilder){
            final /* synthetic */ MVStore $store;
            final /* synthetic */ SvgCacheMapper $mapper;
            final /* synthetic */ MVMap.MapBuilder<MVMap<K, V>, K, V> $mapBuilder;
            {
                this.$store = $store;
                this.$mapper = $mapper;
                this.$mapBuilder = $mapBuilder;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final MVMap<K, V> invoke(@NotNull Float it) {
                MVMap mVMap;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MVStore mVStore = this.$store;
                MVStore mVStore2 = this.$store;
                SvgCacheMapper svgCacheMapper = this.$mapper;
                MVMap.MapBuilder<MVMap<K, V>, K, V> mapBuilder = this.$mapBuilder;
                MVStore mVStore3 = mVStore;
                synchronized (mVStore3) {
                    boolean bl = false;
                    mVMap = mVStore2.openMap(svgCacheMapper.getName$intellij_platform_util_ui(), mapBuilder);
                }
                return mVMap;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mVMap, (String)"K, V> getMap(mapper: Svg\u2026me, mapBuilder)\n    }\n  }");
        return mVMap;
    }

    private static final MVMap getMap$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (MVMap)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ long[] access$getCacheKey(byte[] imageBytes, byte[] themeDigest) {
        return SvgCacheManagerKt.getCacheKey(imageBytes, themeDigest);
    }

    public static final /* synthetic */ MVMap access$getMap(SvgCacheMapper mapper, Map classifierToMap, MVStore store, MVMap.MapBuilder mapBuilder) {
        return SvgCacheManagerKt.getMap(mapper, classifierToMap, store, mapBuilder);
    }

    public static final /* synthetic */ BufferedImage access$readImage(ImageValue value) {
        return SvgCacheManagerKt.readImage(value);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return SvgCacheManagerKt.getLOG();
    }

    public static final /* synthetic */ ImageValue access$writeImage(BufferedImage image) {
        return SvgCacheManagerKt.writeImage(image);
    }
}

