/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.util.xml.dom.StaxFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVG12DOMImplementation;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericText;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a\u001c\u0010\u0004\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u001a\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u001c"}, d2={"buildDocument", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "reader", "Ljavax/xml/stream/XMLStreamReader;", "createSvgDocument", "inputStream", "Ljava/io/InputStream;", "uri", "", "data", "", "xmlStreamReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "getRawName", "prefix", "localName", "isAllXMLWhitespace", "", "value", "processElementFragment", "", "document", "factory", "Lorg/apache/batik/anim/dom/SVGDOMImplementation;", "parent", "Lorg/w3c/dom/Element;", "readAttributes", "element", "intellij.platform.util.ui"})
public final class SvgDocumentFactoryKt {
    @ApiStatus.Internal
    @NotNull
    public static final SVGOMDocument createSvgDocument(@NotNull InputStream inputStream, @Nullable String uri) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return SvgDocumentFactoryKt.createSvgDocument(StaxFactory.createXmlStreamReader((InputStream)inputStream), uri);
    }

    public static /* synthetic */ SVGOMDocument createSvgDocument$default(InputStream inputStream, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return SvgDocumentFactoryKt.createSvgDocument(inputStream, string2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final SVGOMDocument createSvgDocument(@NotNull byte[] data2, @Nullable String uri) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return SvgDocumentFactoryKt.createSvgDocument(StaxFactory.createXmlStreamReader((byte[])data2), uri);
    }

    public static /* synthetic */ SVGOMDocument createSvgDocument$default(byte[] byArray, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return SvgDocumentFactoryKt.createSvgDocument(byArray, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SVGOMDocument createSvgDocument(XMLStreamReader2 xmlStreamReader, String uri) {
        SVGOMDocument sVGOMDocument;
        try {
            sVGOMDocument = SvgDocumentFactoryKt.buildDocument((XMLStreamReader)xmlStreamReader);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            xmlStreamReader.close();
        }
        SVGOMDocument result2 = sVGOMDocument;
        if (uri != null) {
            result2.setDocumentURI(uri);
        }
        return result2;
    }

    private static final SVGOMDocument buildDocument(XMLStreamReader reader) {
        int state = reader.getEventType();
        if (7 != state) {
            throw new IOException("Incorrect state: " + state);
        }
        SVGOMDocument document = null;
        while (state != 8) {
            switch (state) {
                case 7: {
                    boolean bl;
                    boolean bl2 = bl = document == null;
                    if (!_Assertions.ENABLED || bl) break;
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    SVGDOMImplementation sVGDOMImplementation;
                    String version = null;
                    int n = reader.getAttributeCount();
                    for (int i2 = 0; i2 < n; ++i2) {
                        String localName = reader.getAttributeLocalName(i2);
                        String prefix = reader.getAttributePrefix(i2);
                        Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
                        if (!(((CharSequence)prefix).length() == 0) || !Intrinsics.areEqual((Object)localName, (Object)"version")) continue;
                        version = reader.getAttributeValue(i2);
                        break;
                    }
                    CharSequence charSequence = version;
                    if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual(version, (Object)"1.0") || Intrinsics.areEqual(version, (Object)"1.1")) {
                        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
                        Intrinsics.checkNotNull((Object)dOMImplementation, (String)"null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        sVGDOMImplementation = (SVGDOMImplementation)dOMImplementation;
                    } else if (Intrinsics.areEqual(version, (Object)"1.2")) {
                        DOMImplementation dOMImplementation = SVG12DOMImplementation.getDOMImplementation();
                        Intrinsics.checkNotNull((Object)dOMImplementation, (String)"null cannot be cast to non-null type org.apache.batik.anim.dom.SVGDOMImplementation");
                        sVGDOMImplementation = (SVGDOMImplementation)dOMImplementation;
                    } else {
                        throw new IOException("Unsupported SVG version: " + version);
                    }
                    SVGDOMImplementation implementation = sVGDOMImplementation;
                    String localName = reader.getLocalName();
                    String string3 = reader.getNamespaceURI();
                    String string4 = reader.getPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)localName, (String)"localName");
                    Document document2 = implementation.createDocument(string3, SvgDocumentFactoryKt.getRawName(string4, localName), null);
                    Intrinsics.checkNotNull((Object)document2, (String)"null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMDocument");
                    document = (SVGOMDocument)document2;
                    Element element = document.getDocumentElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(element, reader);
                    if (!Intrinsics.areEqual((Object)localName, (Object)"svg")) {
                        throw new IOException("Root element does not match that requested:\nRequested: svg\nFound: " + localName);
                    }
                    SvgDocumentFactoryKt.processElementFragment(reader, document, implementation, element);
                    break;
                }
                case 4: {
                    String badContent = reader.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)badContent, (String)"badContent");
                    if (SvgDocumentFactoryKt.isAllXMLWhitespace(badContent)) break;
                    throw new IOException("Unexpected XMLStream event at Document level: CHARACTERS (" + badContent + ")");
                }
                default: {
                    throw new IOException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (!reader.hasNext()) {
                throw new IOException("Unexpected end-of-XMLStreamReader");
            }
            state = reader.next();
        }
        SVGOMDocument sVGOMDocument = document;
        Intrinsics.checkNotNull(sVGOMDocument);
        return sVGOMDocument;
    }

    private static final void processElementFragment(XMLStreamReader reader, SVGOMDocument document, SVGDOMImplementation factory2, Element parent2) {
        int depth = 1;
        Node current = parent2;
        block7: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element element = factory2.createElementNS((AbstractDocument)document, reader.getNamespaceURI(), reader.getLocalName());
                    Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                    SvgDocumentFactoryKt.readAttributes(element, reader);
                    current.appendChild(element);
                    current = element;
                    ++depth;
                    continue block7;
                }
                case 2: {
                    Intrinsics.checkNotNullExpressionValue((Object)current.getParentNode(), (String)"current.parentNode");
                    --depth;
                    continue block7;
                }
                case 12: {
                    current.appendChild((Node)new GenericCDATASection(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 4: 
                case 6: {
                    if (reader.isWhiteSpace()) continue block7;
                    current.appendChild((Node)new GenericText(reader.getText(), (AbstractDocument)document));
                    continue block7;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block7;
                }
            }
            throw new IOException("Unexpected XMLStream event: " + reader.getEventType());
        }
    }

    private static final void readAttributes(Element element, XMLStreamReader reader) {
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String localName = reader.getAttributeLocalName(i2);
            String prefix = reader.getAttributePrefix(i2);
            String string2 = reader.getAttributeNamespace(i2);
            Intrinsics.checkNotNullExpressionValue((Object)localName, (String)"localName");
            element.setAttributeNS(string2, SvgDocumentFactoryKt.getRawName(prefix, localName), reader.getAttributeValue(i2));
        }
    }

    private static final String getRawName(String prefix, String localName) {
        CharSequence charSequence = prefix;
        return charSequence == null || charSequence.length() == 0 ? localName : prefix + ":" + localName;
    }

    private static final boolean isAllXMLWhitespace(String value) {
        int i2 = value.length();
        while (--i2 >= 0) {
            char c2 = value.charAt(i2);
            if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r') continue;
            return false;
        }
        return true;
    }
}

