/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.Stores;
import com.intellij.ui.svg.SvgCacheManagerKt;
import com.intellij.ui.svg.SvgCacheMapper;
import java.awt.Image;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.h2.mvstore.DataUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ikv.Ikv;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;", "", "dbDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "darkStores", "Lcom/intellij/ui/svg/Stores;", "lightStores", "loadFromCache", "Ljava/awt/Image;", "key", "", "mapper", "Lcom/intellij/ui/svg/SvgCacheMapper;", "intellij.platform.util.ui"})
public final class SvgPrebuiltCacheManager {
    @NotNull
    private final Stores lightStores;
    @NotNull
    private final Stores darkStores;

    public SvgPrebuiltCacheManager(@NotNull Path dbDir) {
        Intrinsics.checkNotNullParameter((Object)dbDir, (String)"dbDir");
        this.lightStores = new Stores(dbDir, "");
        this.darkStores = new Stores(dbDir, "-d");
    }

    @Nullable
    public final Image loadFromCache(int key, @NotNull SvgCacheMapper mapper) {
        Ikv.SizeUnawareIkv sizeUnawareIkv;
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        Stores list2 = mapper.isDark ? this.darkStores : this.lightStores;
        float f = mapper.scale;
        if (f == 1.0f) {
            sizeUnawareIkv = list2.getS1().getOrCreate();
        } else if (f == 1.25f) {
            sizeUnawareIkv = list2.getS1_25().getOrCreate();
        } else if (f == 1.5f) {
            sizeUnawareIkv = list2.getS1_5().getOrCreate();
        } else if (f == 2.0f) {
            sizeUnawareIkv = list2.getS2().getOrCreate();
        } else if (f == 2.5f) {
            sizeUnawareIkv = list2.getS2_5().getOrCreate();
        } else {
            return null;
        }
        Ikv.SizeUnawareIkv store = sizeUnawareIkv;
        ByteBuffer byteBuffer = store.getUnboundedValue(key);
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer data2 = byteBuffer;
        int actualWidth = 0;
        int actualHeight = 0;
        int format = data2.get() & 0xFF;
        if (format < 254) {
            actualWidth = format;
            actualHeight = format;
        } else if (format == 255) {
            actualHeight = actualWidth = DataUtils.readVarInt((ByteBuffer)data2);
        } else {
            actualWidth = DataUtils.readVarInt((ByteBuffer)data2);
            actualHeight = DataUtils.readVarInt((ByteBuffer)data2);
        }
        Image image = SvgCacheManagerKt.readImage(data2, actualWidth, actualHeight);
        IconLoadMeasurer.svgPreBuiltLoad.end(start);
        return image;
    }
}

