/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.ui.svg.SvgDocumentFactoryKt;
import com.intellij.ui.svg.SvgTranscoder;
import com.intellij.ui.svg.SvgTranscoderKt;
import com.intellij.util.ImageLoader;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGFeatureStrings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J$\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0014\u0010\u0013\u001a\u00020\t2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u000fH\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000fH\u0016J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\b\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\u0003H\u0016J&\u0010/\u001a\u0002002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u00101\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u00102\u001a\u00020\u0007H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u00104\u001a\u000205H\u0016J\u0012\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u00109\u001a\u000207H\u0016J\u0012\u0010:\u001a\u00020\t2\b\u0010 \u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010;\u001a\u00020\t2\b\u0010<\u001a\u0004\u0018\u00010=H\u0016J0\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003H\u0002J\u0012\u0010D\u001a\u00020\t2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u001c\u0010G\u001a\u00020\t2\b\u0010H\u001a\u0004\u0018\u00010I2\b\u0010J\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010K\u001a\u00020\u001a2\u0006\u0010L\u001a\u00020\u0007H\u0016J\u0012\u0010M\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010N\u001a\u0002072\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010O\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010O\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\b\u0010P\u001a\u0004\u0018\u00010\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/intellij/ui/svg/SvgTranscoder;", "Lorg/apache/batik/bridge/UserAgent;", "width", "", "height", "(FF)V", "currentTransform", "Ljava/awt/geom/AffineTransform;", "checkLoadExternalResource", "", "resourceUrl", "Lorg/apache/batik/util/ParsedURL;", "documentUrl", "checkLoadScript", "scriptType", "", "scriptURL", "docURL", "deselectAll", "displayError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "displayMessage", "message", "getAlternateStyleSheet", "", "getBolderFontWeight", "f", "getBrokenLinkDocument", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "Lorg/w3c/dom/Element;", "url", "getClientAreaLocationOnScreen", "Ljava/awt/Point;", "getDefaultFontFamily", "getEventDispatcher", "getExternalResourceSecurity", "Lorg/apache/batik/bridge/ExternalResourceSecurity;", "getFontFamilyResolver", "Lorg/apache/batik/bridge/FontFamilyResolver;", "getLanguages", "getLighterFontWeight", "getMedia", "getMediumFontSize", "getPixelToMM", "getPixelUnitToMillimeter", "getScriptSecurity", "Lorg/apache/batik/bridge/NoLoadScriptSecurity;", "scriptUrl", "getTransform", "getUserStyleSheetURI", "getViewportSize", "Ljava/awt/Dimension;", "hasFeature", "", "s", "isXMLParserValidating", "loadDocument", "openLink", "elt", "Lorg/w3c/dom/svg/SVGAElement;", "setImageSize", "docWidth", "docHeight", "overriddenWidth", "overriddenHeight", "iconMaxSize", "setSVGCursor", "cursor", "Ljava/awt/Cursor;", "setTextSelection", "start", "Lorg/apache/batik/bridge/Mark;", "end", "setTransform", "value", "showAlert", "showConfirm", "showPrompt", "defaultValue", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SvgTranscoder
implements UserAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float width;
    private float height;
    @Nullable
    private AffineTransform currentTransform;
    @NotNull
    private static final Lazy<Float> iconMaxSize$delegate;

    private SvgTranscoder(float width, float height) {
        this.width = width;
        this.height = height;
    }

    private final void setImageSize(float docWidth, float docHeight, float overriddenWidth, float overriddenHeight, float iconMaxSize2) {
        if (overriddenWidth > 0.0f && overriddenHeight > 0.0f) {
            this.width = overriddenWidth;
            this.height = overriddenHeight;
        } else if (overriddenHeight > 0.0f) {
            this.width = docWidth * overriddenHeight / docHeight;
            this.height = overriddenHeight;
        } else if (overriddenWidth > 0.0f) {
            this.width = overriddenWidth;
            this.height = docHeight * overriddenWidth / docWidth;
        } else {
            this.width = docWidth;
            this.height = docHeight;
        }
        if (iconMaxSize2 > 0.0f && this.height > iconMaxSize2) {
            this.width = docWidth * iconMaxSize2 / docHeight;
            this.height = iconMaxSize2;
        }
        if (iconMaxSize2 > 0.0f && this.width > iconMaxSize2) {
            this.width = iconMaxSize2;
            this.height = docHeight * iconMaxSize2 / docWidth;
        }
    }

    @NotNull
    public String getMedia() {
        return "screen";
    }

    @NotNull
    public SVGOMDocument getBrokenLinkDocument(@NotNull Element e, @NotNull String url, @NotNull String message) {
        String fallbackIcon;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SvgTranscoderKt.access$logger().warn(url + " " + message);
        String string2 = fallbackIcon = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <rect x=\"1\" y=\"1\" width=\"14\" height=\"14\" fill=\"none\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"1\" x2=\"15\" y2=\"15\" stroke=\"red\" stroke-width=\"2\"/>\n  <line x1=\"1\" y1=\"15\" x2=\"15\" y2=\"1\" stroke=\"red\" stroke-width=\"2\"/>\n</svg>\n";
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return SvgDocumentFactoryKt.createSvgDocument$default(byArray, null, 2, null);
    }

    @NotNull
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.currentTransform;
        Intrinsics.checkNotNull((Object)affineTransform);
        return affineTransform;
    }

    @NotNull
    public Void setTransform(@NotNull AffineTransform value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new IllegalStateException();
    }

    @NotNull
    public Dimension getViewportSize() {
        return new Dimension((int)this.width, (int)this.height);
    }

    public void displayError(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SvgTranscoderKt.access$logger().debug(e);
    }

    public void displayMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SvgTranscoderKt.access$logger().debug(message);
    }

    @NotNull
    public NoLoadScriptSecurity getScriptSecurity(@Nullable String scriptType, @Nullable ParsedURL scriptUrl, @Nullable ParsedURL documentUrl) {
        return new NoLoadScriptSecurity(scriptType);
    }

    @NotNull
    public ExternalResourceSecurity getExternalResourceSecurity(@NotNull ParsedURL resourceUrl, @Nullable ParsedURL documentUrl) {
        Intrinsics.checkNotNullParameter((Object)resourceUrl, (String)"resourceUrl");
        return () -> SvgTranscoder.getExternalResourceSecurity$lambda$0(this, resourceUrl, documentUrl);
    }

    public void showAlert(@Nullable String message) {
    }

    @Nullable
    public Void showPrompt(@Nullable String message) {
        return null;
    }

    @Nullable
    public Void showPrompt(@Nullable String message, @Nullable String defaultValue) {
        return null;
    }

    public boolean showConfirm(@Nullable String message) {
        return false;
    }

    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    @NotNull
    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    public float getLighterFontWeight(float f) {
        return SvgTranscoderKt.access$getStandardLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return SvgTranscoderKt.access$getStandardBolderFontWeight(f);
    }

    @NotNull
    public String getLanguages() {
        return "en";
    }

    @Nullable
    public Void getAlternateStyleSheet() {
        return null;
    }

    @Nullable
    public Void getUserStyleSheetURI() {
        return null;
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    @Nullable
    public Void getEventDispatcher() {
        return null;
    }

    public void openLink(@Nullable SVGAElement elt) {
    }

    public void setSVGCursor(@Nullable Cursor cursor) {
    }

    public void setTextSelection(@Nullable Mark start, @Nullable Mark end) {
    }

    public void deselectAll() {
    }

    @NotNull
    public Point getClientAreaLocationOnScreen() {
        return new Point();
    }

    public boolean hasFeature(@Nullable String s) {
        return CollectionsKt.contains((Iterable)SvgTranscoderKt.access$getSupportedFeatures$p(), (Object)s);
    }

    public void checkLoadScript(@Nullable String scriptType, @NotNull ParsedURL scriptURL, @Nullable ParsedURL docURL) {
        Intrinsics.checkNotNullParameter((Object)scriptURL, (String)"scriptURL");
        throw new SecurityException("NO_EXTERNAL_RESOURCE_ALLOWED");
    }

    public void checkLoadExternalResource(@NotNull ParsedURL resourceUrl, @Nullable ParsedURL documentUrl) {
        Intrinsics.checkNotNullParameter((Object)resourceUrl, (String)"resourceUrl");
        if (!Intrinsics.areEqual((Object)"data", (Object)resourceUrl.getProtocol())) {
            throw new SecurityException("NO_EXTERNAL_RESOURCE_ALLOWED");
        }
    }

    public void loadDocument(@Nullable String url) {
    }

    @NotNull
    public FontFamilyResolver getFontFamilyResolver() {
        DefaultFontFamilyResolver defaultFontFamilyResolver = DefaultFontFamilyResolver.SINGLETON;
        Intrinsics.checkNotNullExpressionValue((Object)defaultFontFamilyResolver, (String)"SINGLETON");
        return (FontFamilyResolver)defaultFontFamilyResolver;
    }

    private static final void getExternalResourceSecurity$lambda$0(SvgTranscoder this$0, ParsedURL $resourceUrl, ParsedURL $documentUrl) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resourceUrl, (String)"$resourceUrl");
        this$0.checkLoadExternalResource($resourceUrl, $documentUrl);
    }

    @JvmStatic
    @NotNull
    public static final ImageLoader.Dimension2DDouble getDocumentSize(float scale, @NotNull Document document) {
        return Companion.getDocumentSize(scale, document);
    }

    public /* synthetic */ SvgTranscoder(float width, float height, DefaultConstructorMarker $constructor_marker) {
        this(width, height);
    }

    static {
        SVGFeatureStrings.addSupportedFeatureStrings((Set)SvgTranscoderKt.access$getSupportedFeatures$p());
        iconMaxSize$delegate = LazyKt.lazy((Function0)Companion.iconMaxSize.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u0004J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0016H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/svg/SvgTranscoder$Companion;", "", "()V", "iconMaxSize", "", "getIconMaxSize$intellij_platform_util_ui", "()F", "iconMaxSize$delegate", "Lkotlin/Lazy;", "createImage", "Ljava/awt/image/BufferedImage;", "scale", "input", "Ljava/io/InputStream;", "data", "", "document", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "overriddenWidth", "overriddenHeight", "getDocumentSize", "Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "Lorg/w3c/dom/Document;", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        public final float getIconMaxSize$intellij_platform_util_ui() {
            Lazy lazy = iconMaxSize$delegate;
            return ((Number)lazy.getValue()).floatValue();
        }

        @JvmStatic
        @NotNull
        public final ImageLoader.Dimension2DDouble getDocumentSize(float scale, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            BridgeContext bridgeContext = SvgTranscoderKt.access$createBridgeContext(document, new SvgTranscoder(16.0f, 16.0f, null));
            new GVTBuilder().build(bridgeContext, document);
            Dimension2D size = bridgeContext.getDocumentSize();
            return new ImageLoader.Dimension2DDouble(size.getWidth() * (double)scale, size.getHeight() * (double)scale);
        }

        @NotNull
        public final BufferedImage createImage(float scale, @NotNull byte[] data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            return com.intellij.ui.svg.SvgTranscoder$Companion.createImage$default(this, scale, SvgDocumentFactoryKt.createSvgDocument(data2, null), 0.0f, 0.0f, 12, null);
        }

        @NotNull
        public final BufferedImage createImage(float scale, @NotNull InputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return com.intellij.ui.svg.SvgTranscoder$Companion.createImage$default(this, scale, SvgDocumentFactoryKt.createSvgDocument(input, null), 0.0f, 0.0f, 12, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BufferedImage createImage(float scale, @NotNull SVGOMDocument document, float overriddenWidth, float overriddenHeight) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            SvgTranscoder transcoder = new SvgTranscoder(overriddenWidth == -1.0f ? 16.0f : overriddenWidth, overriddenHeight == -1.0f ? 16.0f : overriddenHeight, null);
            BridgeContext bridgeContext = SvgTranscoderKt.access$createBridgeContext((Document)document, transcoder);
            try {
                String string2;
                GraphicsNode graphicsNode = new GVTBuilder().build(bridgeContext, (Document)document);
                Intrinsics.checkNotNull((Object)graphicsNode);
                GraphicsNode gvtRoot = graphicsNode;
                float docWidth = (float)bridgeContext.getDocumentSize().getWidth();
                float docHeight = (float)bridgeContext.getDocumentSize().getHeight();
                float normalizingScale = 1.0f;
                String string3 = document.getURL();
                boolean bl = string3 != null ? StringsKt.contains$default((CharSequence)string3, (CharSequence)"@2x", (boolean)false, (int)2, null) : false;
                Object object = document.getRootElement();
                if (object != null && (object = object.getAttributes()) != null && (object = object.getNamedItem("data-scaled")) != null && (object = object.getNodeValue()) != null) {
                    Object object2 = object;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string4 = ((String)object2).toLowerCase(locale);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                } else {
                    string2 = null;
                }
                if (bl & StringsKt.equals$default(string2, (String)"true", (boolean)false, (int)2, null)) {
                    normalizingScale = 2.0f;
                }
                float imageScale = scale / normalizingScale;
                transcoder.setImageSize(docWidth * imageScale, docHeight * imageScale, overriddenWidth, overriddenHeight, this.getIconMaxSize$intellij_platform_util_ui());
                AffineTransform transform2 = SvgTranscoderKt.access$computeTransform(document, gvtRoot, bridgeContext, docWidth, docHeight, transcoder.width, transcoder.height);
                transcoder.currentTransform = transform2;
                BufferedImage bufferedImage = SvgTranscoderKt.access$render((int)(transcoder.width + 0.5f), (int)(transcoder.height + 0.5f), transform2, gvtRoot);
                return bufferedImage;
            }
            finally {
                bridgeContext.dispose();
            }
        }

        public static /* synthetic */ BufferedImage createImage$default(Companion companion, float f, SVGOMDocument sVGOMDocument, float f2, float f3, int n, Object object) {
            if ((n & 4) != 0) {
                f2 = -1.0f;
            }
            if ((n & 8) != 0) {
                f3 = -1.0f;
            }
            return companion.createImage(f, sVGOMDocument, f2, f3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

