/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.SvgDocumentLoader;
import com.intellij.ui.svg.SvgTranscoder;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGSVGElement;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a@\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u001a\r\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bH\u0002\u001a(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"DATA_SCALED_ATTR", "", "identityTransform", "Ljava/awt/geom/AffineTransform;", "supportedFeatures", "Ljava/util/HashSet;", "computeTransform", "document", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "gvtRoot", "Lorg/apache/batik/gvt/GraphicsNode;", "context", "Lorg/apache/batik/bridge/BridgeContext;", "docWidth", "", "docHeight", "width", "height", "createBridgeContext", "Lorg/w3c/dom/Document;", "transcoder", "Lcom/intellij/ui/svg/SvgTranscoder;", "getStandardBolderFontWeight", "f", "getStandardLighterFontWeight", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "render", "Ljava/awt/image/BufferedImage;", "offScreenWidth", "", "offScreenHeight", "usr2dev", "intellij.platform.util.ui"})
public final class SvgTranscoderKt {
    @NotNull
    private static final AffineTransform identityTransform = new AffineTransform();
    @NotNull
    private static final HashSet<String> supportedFeatures = new HashSet();
    @NotNull
    private static final String DATA_SCALED_ATTR = "data-scaled";

    private static final Logger logger() {
        Logger logger = Logger.getInstance(SvgTranscoder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(SvgTranscoder::class.java)");
        return logger;
    }

    private static final AffineTransform computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context2, float docWidth, float docHeight, float width, float height) {
        CanvasGraphicsNode cgn;
        Object object;
        AffineTransform preserveAspectRatioMatrix = null;
        SVGSVGElement root = document.getRootElement();
        String viewBox = root.getAttributeNS(null, "viewBox");
        Intrinsics.checkNotNullExpressionValue((Object)viewBox, (String)"viewBox");
        if (((CharSequence)viewBox).length() > 0) {
            String aspectRatio = root.getAttributeNS(null, "preserveAspectRatio");
            AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)((Element)root), (String)viewBox, (String)aspectRatio, (float)width, (float)height, (BridgeContext)context2);
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getPreserveAspectRatioTr\u2026, width, height, context)");
            preserveAspectRatioMatrix = affineTransform;
        } else {
            float scale = Math.min(width / docWidth, height / docHeight);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(scale, scale);
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getScaleInstance(scale.t\u2026uble(), scale.toDouble())");
            preserveAspectRatioMatrix = affineTransform;
        }
        Object object2 = (object = gvtRoot instanceof CompositeGraphicsNode ? (CompositeGraphicsNode)gvtRoot : null) != null && (object = object.getChildren()) != null ? CollectionsKt.firstOrNull((List)object) : null;
        CanvasGraphicsNode canvasGraphicsNode = cgn = object2 instanceof CanvasGraphicsNode ? (CanvasGraphicsNode)object2 : null;
        if (cgn == null) {
            return preserveAspectRatioMatrix;
        }
        cgn.setViewingTransform(preserveAspectRatioMatrix);
        return new AffineTransform();
    }

    private static final BufferedImage render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        BufferedImage image = new BufferedImage(offScreenWidth, offScreenHeight, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(image));
        g.setTransform(identityTransform);
        g.setClip(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, offScreenWidth, offScreenHeight);
        g.setComposite(AlphaComposite.SrcOver);
        g.transform(usr2dev);
        gvtRoot.paint(g);
        g.dispose();
        return image;
    }

    private static final float getStandardLighterFontWeight(float f) {
        return switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100, 200 -> 100.0f;
            case 300 -> 200.0f;
            case 400 -> 300.0f;
            case 500, 600, 700, 800, 900 -> 400.0f;
            default -> throw new IllegalArgumentException("Bad Font Weight: " + f);
        };
    }

    private static final float getStandardBolderFontWeight(float f) {
        return switch ((int)((f + (float)50) / (float)100) * 100) {
            case 100, 200, 300, 400, 500 -> 600.0f;
            case 600 -> 700.0f;
            case 700 -> 800.0f;
            case 800 -> 900.0f;
            case 900 -> 900.0f;
            default -> throw new IllegalArgumentException("Bad Font Weight: " + f);
        };
    }

    private static final BridgeContext createBridgeContext(Document document, SvgTranscoder transcoder) {
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMDocument");
        BridgeContext bridgeContext = ((SVGOMDocument)document).isSVG12() ? (BridgeContext)new SVG12BridgeContext((UserAgent)transcoder, (DocumentLoader)SvgDocumentLoader.INSTANCE) : new BridgeContext((UserAgent)transcoder, (DocumentLoader)SvgDocumentLoader.INSTANCE);
        return bridgeContext;
    }

    public static final /* synthetic */ BridgeContext access$createBridgeContext(Document document, SvgTranscoder transcoder) {
        return SvgTranscoderKt.createBridgeContext(document, transcoder);
    }

    public static final /* synthetic */ AffineTransform access$computeTransform(SVGOMDocument document, GraphicsNode gvtRoot, BridgeContext context2, float docWidth, float docHeight, float width, float height) {
        return SvgTranscoderKt.computeTransform(document, gvtRoot, context2, docWidth, docHeight, width, height);
    }

    public static final /* synthetic */ BufferedImage access$render(int offScreenWidth, int offScreenHeight, AffineTransform usr2dev, GraphicsNode gvtRoot) {
        return SvgTranscoderKt.render(offScreenWidth, offScreenHeight, usr2dev, gvtRoot);
    }

    public static final /* synthetic */ Logger access$logger() {
        return SvgTranscoderKt.logger();
    }

    public static final /* synthetic */ float access$getStandardLighterFontWeight(float f) {
        return SvgTranscoderKt.getStandardLighterFontWeight(f);
    }

    public static final /* synthetic */ float access$getStandardBolderFontWeight(float f) {
        return SvgTranscoderKt.getStandardBolderFontWeight(f);
    }

    public static final /* synthetic */ HashSet access$getSupportedFeatures$p() {
        return supportedFeatures;
    }
}

