/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.notification.impl.ui.StickyButton;
import com.intellij.notification.impl.ui.StickyButtonUI;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorButtonBase
extends StickyButton {
    @Nullable
    protected Color myColor;

    protected ColorButtonBase(@NotNull @NlsContexts.Button String text2, @NotNull Color color) {
        if (text2 == null) {
            ColorButtonBase.$$$reportNull$$$0(0);
        }
        if (color == null) {
            ColorButtonBase.$$$reportNull$$$0(1);
        }
        super(FileColorManagerImpl.getAlias(text2));
        this.myColor = color;
        this.setUI(this.createUI());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorButtonBase.this.doPerformAction(e);
            }
        });
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    public void setUI(ButtonUI ui) {
        if (this.myColor == null) {
            return;
        }
        super.setUI(ui);
    }

    protected abstract void doPerformAction(ActionEvent var1);

    @NotNull
    Color getColor() {
        assert (this.myColor != null);
        Color color = this.myColor;
        if (color == null) {
            ColorButtonBase.$$$reportNull$$$0(2);
        }
        return color;
    }

    public void setColor(@NotNull Color color) {
        if (color == null) {
            ColorButtonBase.$$$reportNull$$$0(3);
        }
        this.myColor = color;
    }

    public Color getForeground() {
        if (this.getModel().isSelected()) {
            return JBColor.foreground();
        }
        if (this.getModel().isRollover()) {
            return JBColor.GRAY;
        }
        return this.getColor();
    }

    protected ButtonUI createUI() {
        return new ColorButtonUI();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/ColorButtonBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/ColorButtonBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setColor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }

    protected static class ColorButtonUI
    extends StickyButtonUI<ColorButtonBase> {
        protected ColorButtonUI() {
        }

        protected Color getBackgroundColor(@NotNull ColorButtonBase button2) {
            if (button2 == null) {
                ColorButtonUI.$$$reportNull$$$0(0);
            }
            return button2.getColor();
        }

        protected Color getFocusColor(@NotNull ColorButtonBase button2) {
            if (button2 == null) {
                ColorButtonUI.$$$reportNull$$$0(1);
            }
            return StartupUiUtil.isUnderDarcula() ? button2.getColor().brighter() : button2.getColor().darker();
        }

        protected Color getSelectionColor(@NotNull ColorButtonBase button2) {
            if (button2 == null) {
                ColorButtonUI.$$$reportNull$$$0(2);
            }
            return button2.getColor();
        }

        protected Color getRolloverColor(@NotNull ColorButtonBase button2) {
            if (button2 == null) {
                ColorButtonUI.$$$reportNull$$$0(3);
            }
            return button2.getColor();
        }

        protected int getArcSize() {
            return JBUIScale.scale(15);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "button";
            objectArray2[1] = "com/intellij/ui/tabs/ColorButtonBase$ColorButtonUI";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBackgroundColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFocusColor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectionColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRolloverColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

