/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.tabs.ColorButtonBase;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSelectionComponent
extends JPanel {
    private final Map<String, ColorButton> myColorToButtonMap = new LinkedHashMap<String, ColorButton>();
    private final ButtonGroup myButtonGroup = new ButtonGroup();
    private static final String CUSTOM_COLOR_ID = "Custom";

    public ColorSelectionComponent() {
        super(new GridLayout(1, 0, 5, 5));
        this.setOpaque(false);
    }

    public void setSelectedColor(@NlsContexts.Button String colorName) {
        AbstractButton button2 = (AbstractButton)((Object)this.myColorToButtonMap.get(colorName));
        if (button2 != null) {
            button2.setSelected(true);
        }
    }

    private void addCustomColorButton() {
        CustomColorButton customButton = new CustomColorButton();
        this.myButtonGroup.add((AbstractButton)((Object)customButton));
        this.add((Component)((Object)customButton));
        this.myColorToButtonMap.put(CUSTOM_COLOR_ID, customButton);
    }

    private void addColorButton(@NotNull @NonNls String colorID, @NotNull @NlsContexts.Button String name, @NotNull Color color) {
        if (colorID == null) {
            ColorSelectionComponent.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ColorSelectionComponent.$$$reportNull$$$0(1);
        }
        if (color == null) {
            ColorSelectionComponent.$$$reportNull$$$0(2);
        }
        ColorButton colorButton = new ColorButton(name, color);
        this.myButtonGroup.add((AbstractButton)((Object)colorButton));
        this.add((Component)((Object)colorButton));
        this.myColorToButtonMap.put(colorID, colorButton);
    }

    public void setCustomButtonColor(@NotNull Color color) {
        if (color == null) {
            ColorSelectionComponent.$$$reportNull$$$0(3);
        }
        CustomColorButton button2 = (CustomColorButton)this.myColorToButtonMap.get(CUSTOM_COLOR_ID);
        button2.setColor(color);
        button2.setSelected(true);
        button2.repaint();
    }

    @Nullable
    @NonNls
    public String getSelectedColorName() {
        for (String name : this.myColorToButtonMap.keySet()) {
            ColorButton button2 = this.myColorToButtonMap.get(name);
            if (!button2.isSelected()) continue;
            if (button2 instanceof CustomColorButton) {
                String colorHexString = ColorUtil.toHex(button2.getColor());
                String colorID = FileColorManagerImpl.getColorID(button2.getColor());
                return colorID == null ? colorHexString : colorID;
            }
            return name;
        }
        return null;
    }

    public void initDefault(@NotNull FileColorManager manager, @Nullable @NlsContexts.Button String selectedColorName) {
        if (manager == null) {
            ColorSelectionComponent.$$$reportNull$$$0(4);
        }
        for (String id : manager.getColorIDs()) {
            this.addColorButton(id, manager.getColorName(id), Objects.requireNonNull(manager.getColor(id)));
        }
        this.addCustomColorButton();
        this.setSelectedColor(selectedColorName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/ColorSelectionComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addColorButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setCustomButtonColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomColorButton
    extends ColorButton {
        private CustomColorButton() {
            super(IdeBundle.message((String)"settings.file.color.custom.name", (Object[])new Object[0]), JBColor.WHITE);
            this.myColor = null;
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            RelativePoint location2 = new RelativePoint((Component)((Object)this), new Point(this.getWidth() / 2, this.getHeight()));
            ColorListener listener2 = new ColorListener(){

                public void colorChanged(Color color, Object source) {
                    if (color != null) {
                        myColor = color;
                    }
                    this.setSelected(myColor != null);
                    this.revalidate();
                    this.repaint();
                }
            };
            ColorPicker.showColorPickerPopup(null, (Color)this.myColor, (ColorListener)listener2, (RelativePoint)location2);
        }

        @Override
        protected ButtonUI createUI() {
            return new ColorButtonBase.ColorButtonUI(){

                @Nullable
                protected Color getUnfocusedBorderColor(@NotNull ColorButtonBase button2) {
                    if (button2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (StartupUiUtil.isUnderDarcula()) {
                        return JBColor.GRAY;
                    }
                    return super.getUnfocusedBorderColor((AbstractButton)((Object)button2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/ui/tabs/ColorSelectionComponent$CustomColorButton$2", "getUnfocusedBorderColor"));
                }
            };
        }

        @Override
        public Color getForeground() {
            return this.getModel().isSelected() ? JBColor.BLACK : JBColor.GRAY;
        }

        @Override
        @NotNull
        Color getColor() {
            Color color = this.myColor == null ? JBColor.WHITE : this.myColor;
            if (color == null) {
                CustomColorButton.$$$reportNull$$$0(0);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/ColorSelectionComponent$CustomColorButton", "getColor"));
        }
    }

    private static class ColorButton
    extends ColorButtonBase {
        protected ColorButton(@NlsContexts.Button String text2, Color color) {
            super(text2, color);
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
        }
    }
}

