/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.ui.tabs.PerTeamFileColorModelStorageManager;
import com.intellij.ui.tabs.PerUserFileColorModelStorageManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorManagerImpl
extends FileColorManager {
    private static final String FC_ENABLED = "FileColorsEnabled";
    private static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    private static final String EXP_UI_FC_TABS_ENABLED = "ExpUIFileColorsForTabsEnabled";
    private static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private final NotNullLazyValue<FileColorsModel> myInitializedModel;
    private static final Map<String, Color> ourDefaultColors = Map.of("Blue", JBColor.namedColor("FileColor.Blue", new JBColor(15398655, 5199211)), "Green", JBColor.namedColor("FileColor.Green", new JBColor(15727335, 4805706)), "Orange", JBColor.namedColor("FileColor.Orange", new JBColor(16181724, 8413266)), "Rose", JBColor.namedColor("FileColor.Rose", new JBColor(15916250, 7230299)), "Violet", JBColor.namedColor("FileColor.Violet", new JBColor(15130865, 5458519)), "Yellow", JBColor.namedColor("FileColor.Yellow", new JBColor(0xFFFFE4, 5196609)), "Gray", JBColor.namedColor("FileColor.Gray", new JBColor(0xF5F5F5, 4540490)));

    public FileColorManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myModel = new FileColorsModel(project2);
        this.myInitializedModel = NotNullLazyValue.createValue(() -> {
            project2.getService(PerTeamFileColorModelStorageManager.class);
            project2.getService(PerUserFileColorModelStorageManager.class);
            return this.myModel;
        });
    }

    @Override
    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    @ApiStatus.Internal
    public static void setEnabledForTabs(boolean enabled) {
        if (ExperimentalUI.isNewUI()) {
            PropertiesComponent.getInstance().setValue(EXP_UI_FC_TABS_ENABLED, Boolean.toString(enabled));
        } else {
            PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
        }
    }

    @Override
    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    @ApiStatus.Internal
    public static boolean _isEnabledForTabs() {
        if (ExperimentalUI.isNewUI()) {
            return PropertiesComponent.getInstance().getBoolean(EXP_UI_FC_TABS_ENABLED, false);
        }
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    @Override
    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    @Override
    @Nullable
    public Color getColor(@NotNull @NonNls String id) {
        Color color;
        if (id == null) {
            FileColorManagerImpl.$$$reportNull$$$0(1);
        }
        return (color = ourDefaultColors.get(id)) == null ? ColorUtil.fromHex(id, null) : color;
    }

    @Override
    @NotNull
    @Nls
    public String getColorName(@NotNull @NonNls String id) {
        if (id == null) {
            FileColorManagerImpl.$$$reportNull$$$0(2);
        }
        String string2 = ourDefaultColors.containsKey(id) ? IdeBundle.message((String)("color.name." + id.toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]) : IdeBundle.message((String)"settings.file.color.custom.name", (Object[])new Object[0]);
        if (string2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public Collection<@NonNls String> getColorIDs() {
        return ContainerUtil.sorted(ourDefaultColors.keySet());
    }

    @Override
    public Collection<@Nls String> getColorNames() {
        ArrayList<String> list2 = new ArrayList<String>(ourDefaultColors.size());
        for (String key : ourDefaultColors.keySet()) {
            list2.add(IdeBundle.message((String)("color.name." + key.toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]));
        }
        list2.sort(null);
        return list2;
    }

    @Override
    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return null;
    }

    @Override
    @Nullable
    public Color getRendererBackground(PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    @Override
    public void addScopeColor(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(4);
        }
        if (colorName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(5);
        }
        this.myInitializedModel.getValue().add(scopeName, colorName, isProjectLevel);
    }

    @Override
    @Nullable
    public Color getFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = this.myInitializedModel.getValue().getColor(file2, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Override
    @Nullable
    public Color getScopeColor(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(7);
        }
        if (!this.isEnabled()) {
            return null;
        }
        String colorName = this.myInitializedModel.getValue().getScopeColor(scopeName, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Override
    public boolean isShared(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorManagerImpl.$$$reportNull$$$0(8);
        }
        return this.myInitializedModel.getValue().isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        FileColorsModel fileColorsModel = this.myInitializedModel.getValue();
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(9);
        }
        return fileColorsModel;
    }

    @NotNull
    FileColorsModel getUninitializedModel() {
        FileColorsModel fileColorsModel = this.myModel;
        if (fileColorsModel == null) {
            FileColorManagerImpl.$$$reportNull$$$0(10);
        }
        return fileColorsModel;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        List<FileColorConfiguration> list2 = this.myInitializedModel.getValue().getLocalConfigurations();
        if (list2 == null) {
            FileColorManagerImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myInitializedModel.getValue().getProjectLevelConfigurations();
    }

    @Nullable
    @NonNls
    public static String getColorID(@NotNull Color color) {
        if (color == null) {
            FileColorManagerImpl.$$$reportNull$$$0(12);
        }
        for (Map.Entry<String, Color> entry : ourDefaultColors.entrySet()) {
            if (!color.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nls
    static String getAlias(@Nls String text2) {
        return StartupUiUtil.isUnderDarcula() && text2.equals(IdeBundle.message((String)"color.name.yellow", (Object[])new Object[0])) ? IdeBundle.message((String)"color.name.brown", (Object[])new Object[0]) : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationLevelConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColorName";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeColor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isShared";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColorID";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

