/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.options.CheckBoxConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorsConfigurable;
import com.intellij.ui.tabs.FileColorsTableModel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0003\f\u0011\u0014\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0012\u0010\u001b\u001a\f0\u001c\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/intellij/ui/tabs/FileColorsConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "colorsTableModel", "Lcom/intellij/ui/tabs/FileColorsTableModel;", "configurables", "", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "enabledFileColors", "com/intellij/ui/tabs/FileColorsConfigurable$enabledFileColors$1", "Lcom/intellij/ui/tabs/FileColorsConfigurable$enabledFileColors$1;", "manager", "Lcom/intellij/ui/tabs/FileColorManagerImpl;", "useInEditorTabs", "com/intellij/ui/tabs/FileColorsConfigurable$useInEditorTabs$1", "Lcom/intellij/ui/tabs/FileColorsConfigurable$useInEditorTabs$1;", "useInProjectView", "com/intellij/ui/tabs/FileColorsConfigurable$useInProjectView$1", "Lcom/intellij/ui/tabs/FileColorsConfigurable$useInProjectView$1;", "apply", "", "createComponent", "Ljavax/swing/JPanel;", "disposeUIResources", "getDisplayName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getHelpTopic", "getId", "isModified", "", "reset", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileColorsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileColorsConfigurable.kt\ncom/intellij/ui/tabs/FileColorsConfigurable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,504:1\n1747#2,3:505\n1855#2,2:508\n1855#2,2:510\n1855#2,2:512\n*S KotlinDebug\n*F\n+ 1 FileColorsConfigurable.kt\ncom/intellij/ui/tabs/FileColorsConfigurable\n*L\n146#1:505,3\n147#1:508,2\n148#1:510,2\n149#1:512,2\n*E\n"})
public final class FileColorsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final enabledFileColors.1 enabledFileColors;
    @NotNull
    private final useInEditorTabs.1 useInEditorTabs;
    @NotNull
    private final useInProjectView.1 useInProjectView;
    @NotNull
    private final FileColorManagerImpl manager;
    @NotNull
    private final FileColorsTableModel colorsTableModel;
    @NotNull
    private final List<UnnamedConfigurable> configurables;

    public FileColorsConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.enabledFileColors = new CheckBoxConfigurable(this){
            final /* synthetic */ FileColorsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected JCheckBox createCheckBox() {
                JCheckBox checkBox = new JCheckBox(IdeBundle.message((String)"settings.file.colors.enable.file.colors", (Object[])new Object[0]));
                checkBox.addChangeListener(arg_0 -> enabledFileColors.1.createCheckBox$lambda$0(this.this$0, checkBox, arg_0));
                return checkBox;
            }

            protected boolean getSelectedState() {
                return FileColorsConfigurable.access$getManager$p(this.this$0).isEnabled();
            }

            protected void setSelectedState(boolean state) {
                FileColorsConfigurable.access$getManager$p(this.this$0).setEnabled(state);
            }

            private static final void createCheckBox$lambda$0(FileColorsConfigurable this$0, JCheckBox $checkBox, ChangeEvent it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$checkBox, (String)"$checkBox");
                JCheckBox jCheckBox = FileColorsConfigurable.access$getUseInEditorTabs$p(this$0).getCheckBox();
                if (jCheckBox != null) {
                    jCheckBox.setEnabled($checkBox.isSelected());
                }
                JCheckBox jCheckBox2 = FileColorsConfigurable.access$getUseInProjectView$p(this$0).getCheckBox();
                if (jCheckBox2 != null) {
                    jCheckBox2.setEnabled($checkBox.isSelected());
                }
            }
        };
        this.useInEditorTabs = new CheckBoxConfigurable(this){
            final /* synthetic */ FileColorsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected JCheckBox createCheckBox() {
                JCheckBox checkBox = new JCheckBox(IdeBundle.message((String)"settings.file.colors.use.in.editor.tabs", (Object[])new Object[0]));
                checkBox.setEnabled(false);
                return checkBox;
            }

            protected boolean getSelectedState() {
                return FileColorsConfigurable.access$getManager$p(this.this$0).isEnabledForTabs();
            }

            protected void setSelectedState(boolean state) {
                FileColorManagerImpl.setEnabledForTabs(state);
            }

            public void apply() {
                super.apply();
                UISettings.Companion.getInstance().fireUISettingsChanged();
            }
        };
        this.useInProjectView = new CheckBoxConfigurable(this){
            final /* synthetic */ FileColorsConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected JCheckBox createCheckBox() {
                JCheckBox checkBox = new JCheckBox(IdeBundle.message((String)"settings.file.colors.use.in.project.view", (Object[])new Object[0]));
                checkBox.setEnabled(false);
                return checkBox;
            }

            protected boolean getSelectedState() {
                return FileColorsConfigurable.access$getManager$p(this.this$0).isEnabledForProjectView();
            }

            protected void setSelectedState(boolean state) {
                FileColorManagerImpl.setEnabledForProjectView(state);
            }
        };
        FileColorManager fileColorManager = FileColorManager.getInstance(project2);
        Intrinsics.checkNotNull((Object)fileColorManager, (String)"null cannot be cast to non-null type com.intellij.ui.tabs.FileColorManagerImpl");
        this.manager = (FileColorManagerImpl)fileColorManager;
        this.colorsTableModel = new FileColorsTableModel(this.manager);
        Object[] objectArray = new UnnamedConfigurable[]{(UnnamedConfigurable)this.enabledFileColors, this.colorsTableModel, (UnnamedConfigurable)this.useInEditorTabs, (UnnamedConfigurable)this.useInProjectView};
        this.configurables = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getId() {
        return "reference.settings.ide.settings.file-colors";
    }

    @NotNull
    public String getDisplayName() {
        String string2 = IdeBundle.message((String)"configurable.file.colors", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"configurable.file.colors\")");
        return string2;
    }

    @NotNull
    public String getHelpTopic() {
        return this.getId();
    }

    @NotNull
    public JPanel createComponent() {
        this.disposeUIResources();
        JPanel north = new JPanel((LayoutManager)new HorizontalLayout(10));
        north.setBorder(JBUI.Borders.emptyBottom(5));
        north.add("LEFT", this.enabledFileColors.createComponent());
        north.add("LEFT", this.useInEditorTabs.createComponent());
        north.add("LEFT", this.useInProjectView.createComponent());
        JPanel south = new JPanel((LayoutManager)new VerticalLayout(5));
        south.setBorder(JBUI.Borders.emptyTop(5));
        south.add("TOP", ComponentPanelBuilder.createCommentComponent((String)IdeBundle.message((String)"settings.file.colors.description", (Object[])new Object[0]), (boolean)true));
        String string2 = IdeBundle.message((String)"settings.file.colors.manage.scopes", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"settings.file.colors.manage.scopes\")");
        south.add("TOP", (Component)new ActionLink(string2, (Function1)new Function1<ActionEvent, Unit>(south, this){
            final /* synthetic */ JPanel $south;
            final /* synthetic */ FileColorsConfigurable this$0;
            {
                this.$south = $south;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.$south));
                if (settings != null) {
                    Settings it2 = settings;
                    boolean bl = false;
                    try {
                        if (!it2.select(it2.find("project.scopes")).isRejected()) {
                            return;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                EditScopesDialog.showDialog(FileColorsConfigurable.access$getManager$p(this.this$0).getProject(), null, true);
            }
        }));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add("North", north);
        panel2.add("Center", this.colorsTableModel.createComponent());
        panel2.add("South", south);
        return panel2;
    }

    public boolean isModified() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.configurables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
                    boolean bl2 = false;
                    if (!it.isModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void apply() {
        Iterable $this$forEach$iv = this.configurables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            it.apply();
        }
    }

    public void reset() {
        Iterable $this$forEach$iv = this.configurables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            it.reset();
        }
    }

    public void disposeUIResources() {
        Iterable $this$forEach$iv = this.configurables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnnamedConfigurable it = (UnnamedConfigurable)element$iv;
            boolean bl = false;
            it.disposeUIResources();
        }
    }

    public static final /* synthetic */ FileColorManagerImpl access$getManager$p(FileColorsConfigurable $this) {
        return $this.manager;
    }

    public static final /* synthetic */ useInEditorTabs.1 access$getUseInEditorTabs$p(FileColorsConfigurable $this) {
        return $this.useInEditorTabs;
    }

    public static final /* synthetic */ useInProjectView.1 access$getUseInProjectView$p(FileColorsConfigurable $this) {
        return $this.useInProjectView;
    }
}

