/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myApplicationLevelConfigurations;
    private final List<FileColorConfiguration> myProjectLevelConfigurations;
    private final Map<String, String> myPredefinedScopeNameToPropertyKey;
    private final Map<String, String> myPredefinedScopeNameToColor;
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project2) {
        if (project2 == null) {
            FileColorsModel.$$$reportNull$$$0(0);
        }
        this.myApplicationLevelConfigurations = ContainerUtil.createConcurrentList();
        this.myProjectLevelConfigurations = ContainerUtil.createConcurrentList();
        this.myPredefinedScopeNameToPropertyKey = new HashMap<String, String>();
        this.myPredefinedScopeNameToColor = new HashMap<String, String>();
        this.myProject = project2;
        this.initPredefinedAndGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project2, @NotNull List<? extends FileColorConfiguration> applicationLevel, @NotNull List<? extends FileColorConfiguration> projectLevel) {
        if (project2 == null) {
            FileColorsModel.$$$reportNull$$$0(1);
        }
        if (applicationLevel == null) {
            FileColorsModel.$$$reportNull$$$0(2);
        }
        if (projectLevel == null) {
            FileColorsModel.$$$reportNull$$$0(3);
        }
        this.myApplicationLevelConfigurations = ContainerUtil.createConcurrentList();
        this.myProjectLevelConfigurations = ContainerUtil.createConcurrentList();
        this.myPredefinedScopeNameToPropertyKey = new HashMap<String, String>();
        this.myPredefinedScopeNameToColor = new HashMap<String, String>();
        this.myProject = project2;
        this.myApplicationLevelConfigurations.addAll(applicationLevel);
        this.myProjectLevelConfigurations.addAll(projectLevel);
        this.initPredefinedAndGlobalScopes();
    }

    private void initPredefinedAndGlobalScopes() {
        String colorName;
        for (NamedScope scope : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            String scopeName = scope.getScopeId();
            colorName = scope.getDefaultColorName();
            if (StringUtil.isEmpty(colorName)) continue;
            this.myPredefinedScopeNameToColor.put(scopeName, colorName);
            Object propertyKey = "Non-Project Files".equals(scopeName) ? "file.colors.enable.non.project" : ("Tests".equals(scopeName) ? "file.colors.enable.tests" : "file.colors.enable.custom." + scopeName);
            this.myPredefinedScopeNameToPropertyKey.put(scopeName, (String)propertyKey);
        }
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        for (String scopeName : this.myPredefinedScopeNameToPropertyKey.keySet()) {
            if (this.findConfiguration(scopeName, false) != null || (colorName = this.getColorNameForScope(propertyComponent, scopeName, this.myPredefinedScopeNameToPropertyKey)).isEmpty()) continue;
            Color color = ColorUtil.fromHex(colorName, null);
            String colorID = color == null ? null : FileColorManagerImpl.getColorID(color);
            this.myApplicationLevelConfigurations.add(new FileColorConfiguration(scopeName, colorID == null ? colorName : colorID));
        }
    }

    private String getColorNameForScope(PropertiesComponent propertyComponent, String scopeName, Map<String, String> scopeNameMap) {
        String colorName = propertyComponent.getValue(scopeNameMap.get(scopeName));
        if (colorName == null && (colorName = propertyComponent.getValue(scopeName)) == null) {
            colorName = this.myPredefinedScopeNameToColor.get(scopeName);
        }
        return colorName;
    }

    @NotNull
    Element save(boolean isProjectLevel) {
        Element e = new Element("state");
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            String propertyKey;
            String scopeName = configuration.getScopeName();
            String string2 = propertyKey = isProjectLevel ? null : this.myPredefinedScopeNameToPropertyKey.get(scopeName);
            if (propertyKey == null) {
                configuration.save(e);
                continue;
            }
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue(propertyKey, configuration.getColorID(), this.myPredefinedScopeNameToColor.get(scopeName));
            PropertiesComponent.getInstance().setValue(scopeName, null);
        }
        Element element = e;
        if (element == null) {
            FileColorsModel.$$$reportNull$$$0(4);
        }
        return element;
    }

    public void load(@NotNull Element e, boolean isProjectLevel) {
        if (e == null) {
            FileColorsModel.$$$reportNull$$$0(5);
        }
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        configurations.clear();
        ArrayList<FileColorConfiguration> newConfigurations = new ArrayList<FileColorConfiguration>();
        HashMap<String, String> predefinedScopeNameToPropertyKey = new HashMap<String, String>(this.myPredefinedScopeNameToPropertyKey);
        for (Element child : e.getChildren(FILE_COLOR)) {
            FileColorConfiguration configuration = FileColorConfiguration.load(child);
            if (configuration == null) continue;
            if (!isProjectLevel) {
                predefinedScopeNameToPropertyKey.remove(configuration.getScopeName());
            }
            newConfigurations.add(configuration);
        }
        if (!isProjectLevel) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                String colorName = this.getColorNameForScope(properties, scopeName, predefinedScopeNameToPropertyKey);
                if (StringUtil.isEmpty(colorName)) continue;
                newConfigurations.add(new FileColorConfiguration(scopeName, colorName));
            }
        }
        configurations.addAll(newConfigurations);
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> applicationLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myApplicationLevelConfigurations) {
            applicationLevel.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> projectLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myProjectLevelConfigurations) {
            projectLevel.add(configuration.clone());
        }
        return new FileColorsModel(this.myProject, applicationLevel, projectLevel);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations;
        if (configuration == null) {
            FileColorsModel.$$$reportNull$$$0(6);
        }
        List<FileColorConfiguration> list2 = configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(7);
        }
        if (colorName == null) {
            FileColorsModel.$$$reportNull$$$0(8);
        }
        this.add(new FileColorConfiguration(scopeName, colorName), isProjectLevel);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull String scopeName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(9);
        }
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(10);
        }
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileColorsModel.$$$reportNull$$$0(11);
        }
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        return virtualFile2 == null ? null : this.getColor(virtualFile2, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file2, Project project2) {
        if (file2 == null) {
            FileColorsModel.$$$reportNull$$$0(12);
        }
        if (!file2.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(file2);
        if (configuration != null && configuration.isValid(project2)) {
            return configuration.getColorID();
        }
        return null;
    }

    @Nullable
    public String getScopeColor(@NotNull String scopeName, Project project2) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(13);
        }
        FileColorConfiguration configuration = null;
        Iterator<FileColorConfiguration> iterator2 = this.getConfigurations();
        while (iterator2.hasNext()) {
            FileColorConfiguration each = iterator2.next();
            if (!scopeName.equals(each.getScopeName())) continue;
            configuration = each;
            break;
        }
        if (configuration != null && configuration.isValid(project2)) {
            return configuration.getColorID();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        if (colored == null) {
            FileColorsModel.$$$reportNull$$$0(14);
        }
        Iterator<FileColorConfiguration> iterator2 = this.getConfigurations();
        while (iterator2.hasNext()) {
            FileColorConfiguration configuration = iterator2.next();
            NamedScope scope = NamedScopesHolder.getScope(this.myProject, configuration.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder(this.myProject, configuration.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    @NotNull
    private Iterator<FileColorConfiguration> getConfigurations() {
        Iterator<FileColorConfiguration> iterator2 = ContainerUtil.concatIterators(this.myApplicationLevelConfigurations.iterator(), this.myProjectLevelConfigurations.iterator());
        if (iterator2 == null) {
            FileColorsModel.$$$reportNull$$$0(15);
        }
        return iterator2;
    }

    public boolean isProjectLevel(@NotNull FileColorConfiguration configuration) {
        if (configuration == null) {
            FileColorsModel.$$$reportNull$$$0(16);
        }
        return this.myProjectLevelConfigurations.contains(configuration);
    }

    public void setConfigurations(@NotNull List<? extends FileColorConfiguration> configurations, boolean isProjectLevel) {
        if (configurations == null) {
            FileColorsModel.$$$reportNull$$$0(17);
        }
        List<FileColorConfiguration> myConfigurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        myConfigurations.clear();
        myConfigurations.addAll(configurations);
        if (!isProjectLevel) {
            HashMap<String, String> predefinedScopeNameToPropertyKey = new HashMap<String, String>(this.myPredefinedScopeNameToPropertyKey);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            for (FileColorConfiguration fileColorConfiguration : configurations) {
                String propertyKey = (String)predefinedScopeNameToPropertyKey.remove(fileColorConfiguration.getScopeName());
                if (propertyKey == null) continue;
                propertiesComponent.setValue(propertyKey, fileColorConfiguration.getColorID());
            }
            for (String string2 : predefinedScopeNameToPropertyKey.keySet()) {
                propertiesComponent.setValue((String)predefinedScopeNameToPropertyKey.get(string2), "");
                propertiesComponent.setValue(string2, null);
            }
        }
    }

    public boolean isColored(@NotNull String scopeName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(18);
        }
        return this.findConfiguration(scopeName, isProjectLevel) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return new ArrayList<FileColorConfiguration>(this.myApplicationLevelConfigurations);
    }

    @NotNull
    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return new ArrayList<FileColorConfiguration>(this.myProjectLevelConfigurations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevel";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorsModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colored";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorsModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isProjectLevel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isColored";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 15 -> new IllegalStateException(string2);
        };
    }
}

