/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.ComboBoxColorRenderer;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorsConfigurableKt;
import com.intellij.ui.tabs.ScopeListPopupStep;
import com.intellij.ui.tabs.TableColorRenderer;
import com.intellij.ui.tabs.TableHeaderRenderer;
import com.intellij.ui.tabs.TableScopeRenderer;
import com.intellij.util.ui.EditableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J&\u0010#\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0011\u0010&\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b'0\u001fJ\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001bH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020\u001bH\u0002J\b\u0010/\u001a\u00020\u001bH\u0016J\u0017\u00100\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u00101J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016J\u0018\u00104\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0016J\b\u00108\u001a\u00020\u0012H\u0016J\u0014\u00109\u001a\u0004\u0018\u00010\u00162\b\u0010:\u001a\u0004\u0018\u000103H\u0002J \u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u0019H\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0002J\"\u0010@\u001a\u00020\u00122\b\u0010:\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/ui/tabs/FileColorsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/util/ui/EditableModel;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "manager", "Lcom/intellij/ui/tabs/FileColorManagerImpl;", "(Lcom/intellij/ui/tabs/FileColorManagerImpl;)V", "local", "", "Lcom/intellij/ui/tabs/FileColorConfiguration;", "getManager", "()Lcom/intellij/ui/tabs/FileColorManagerImpl;", "shared", "table", "Ljavax/swing/JTable;", "addRow", "", "addScopeColor", "", "scope", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "color", "", "apply", "canExchangeRows", "", "oldRow", "", "newRow", "copy", "configuration", "", "list", "createComponent", "Ljavax/swing/JComponent;", "exchangeRows", "oldIndex", "newIndex", "getColors", "Lorg/jetbrains/annotations/Nls;", "getColumnClass", "Ljava/lang/Class;", "column", "getColumnCount", "getColumnName", "getConfiguration", "row", "getRowCount", "getSharedIndex", "(I)Ljava/lang/Integer;", "getValueAt", "", "isCellEditable", "isModified", "onRowInserted", "removeRow", "reset", "resolveCustomColor", "value", "resolveDuplicate", "scopeName", "colorName", "toSharedList", "selectRow", "setValueAt", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFileColorsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileColorsConfigurable.kt\ncom/intellij/ui/tabs/FileColorsTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,504:1\n1549#2:505\n1620#2,3:506\n350#2,7:510\n1#3:509\n37#4,2:517\n12583#5,2:519\n12583#5,2:521\n*S KotlinDebug\n*F\n+ 1 FileColorsConfigurable.kt\ncom/intellij/ui/tabs/FileColorsTableModel\n*L\n169#1:505\n169#1:506,3\n198#1:510,7\n363#1:517,2\n383#1:519,2\n384#1:521,2\n*E\n"})
final class FileColorsTableModel
extends AbstractTableModel
implements EditableModel,
UnnamedConfigurable {
    @NotNull
    private final FileColorManagerImpl manager;
    @NotNull
    private final List<FileColorConfiguration> local;
    @NotNull
    private final List<FileColorConfiguration> shared;
    @Nullable
    private JTable table;

    public FileColorsTableModel(@NotNull FileColorManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.local = new ArrayList();
        this.shared = new ArrayList();
    }

    @NotNull
    public final FileColorManagerImpl getManager() {
        return this.manager;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileColorConfiguration> copy(List<? extends FileColorConfiguration> list2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileColorConfiguration fileColorConfiguration = (FileColorConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.copy((FileColorConfiguration)it));
        }
        return (List)destination$iv$iv;
    }

    private final FileColorConfiguration copy(FileColorConfiguration configuration) {
        return new FileColorConfiguration(configuration.getScopeName(), configuration.getColorID());
    }

    private final void selectRow(int row) {
        JTable jTable = this.table;
        if (jTable == null) {
            return;
        }
        JTable table = jTable;
        table.setRowSelectionInterval(row, row);
        table.scrollRectToVisible(table.getCellRect(row, 0, true));
    }

    private final FileColorConfiguration getConfiguration(int row) {
        Integer n = this.getSharedIndex(row);
        if (n == null) {
            return null;
        }
        int index2 = n;
        return index2 < 0 ? this.local.get(row) : this.shared.get(index2);
    }

    private final Integer getSharedIndex(int row) {
        if (row < 0) {
            return null;
        }
        int index2 = row - this.local.size();
        return index2 < this.shared.size() ? Integer.valueOf(index2) : null;
    }

    private final String resolveCustomColor(Object value) {
        String string2;
        String string3 = value instanceof String ? (String)value : null;
        if (string3 == null) {
            return null;
        }
        String name = string3;
        if (this.manager.getColor(name) != null) {
            return name;
        }
        JTable jTable = this.table;
        if (jTable == null) {
            return null;
        }
        JTable parent2 = jTable;
        Color color = ColorChooser.chooseColor((Component)parent2, (String)IdeBundle.message((String)"settings.file.colors.dialog.choose.color", (Object[])new Object[0]), null);
        if (color != null) {
            Color it = color;
            boolean bl = false;
            string2 = ColorUtil.toHex(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean resolveDuplicate(String scopeName, String colorName, boolean toSharedList) {
        boolean update2;
        FileColorConfiguration configuration;
        int index2;
        block17: {
            Object object;
            Object oldColor;
            boolean bl;
            String title;
            JTable parent2;
            block21: {
                block20: {
                    block19: {
                        Object object2;
                        block18: {
                            block16: {
                                String string2;
                                Object[] it;
                                List<FileColorConfiguration> list2;
                                block15: {
                                    int n;
                                    List<FileColorConfiguration> $this$indexOfFirst$iv = list2 = toSharedList ? this.shared : this.local;
                                    boolean $i$f$indexOfFirst = false;
                                    int index$iv = 0;
                                    Iterator<FileColorConfiguration> iterator2 = $this$indexOfFirst$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        Object[] item$iv;
                                        it = item$iv = iterator2.next();
                                        boolean bl2 = false;
                                        if (Intrinsics.areEqual((Object)it.getScopeName(), (Object)scopeName)) {
                                            n = index$iv;
                                            break block15;
                                        }
                                        ++index$iv;
                                    }
                                    n = index2 = -1;
                                }
                                if (index2 < 0) {
                                    return false;
                                }
                                JTable jTable = this.table;
                                if (jTable == null) {
                                    return false;
                                }
                                parent2 = jTable;
                                Project project2 = this.manager.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"manager.project");
                                NamedScope namedScope = FileColorsConfigurableKt.access$findScope(scopeName, project2);
                                Intrinsics.checkNotNull((Object)namedScope);
                                String presentableName = namedScope.getPresentableName();
                                if (toSharedList) {
                                    it = new Object[]{presentableName};
                                    string2 = IdeBundle.message((String)"settings.file.colors.dialog.warning.shared", (Object[])it);
                                } else {
                                    it = new Object[]{presentableName};
                                    string2 = IdeBundle.message((String)"settings.file.colors.dialog.warning.local", (Object[])it);
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (toSharedList) {\n  \u2026\", presentableName)\n    }");
                                title = string2;
                                configuration = list2.get(index2);
                                if (!Intrinsics.areEqual((Object)configuration.getColorID(), (Object)colorName)) break block16;
                                bl = Messages.showYesNoDialog((Component)parent2, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.append", (Object[])new Object[0]), (String)title, (Icon)Messages.getWarningIcon()) != 0;
                                break block17;
                            }
                            object2 = this.manager.getColor(configuration.getColorID());
                            if (object2 == null) break block18;
                            Color it = object2;
                            boolean bl3 = false;
                            String string3 = ColorUtil.toHex(it);
                            object2 = string3;
                            if (string3 != null) break block19;
                        }
                        object2 = oldColor = "";
                    }
                    if ((object = this.manager.getColor(colorName)) == null) break block20;
                    Color it = object;
                    boolean bl4 = false;
                    String string4 = ColorUtil.toHex(it);
                    object = string4;
                    if (string4 != null) break block21;
                }
                object = "";
            }
            Object newColor = object;
            Object[] objectArray = new Object[]{oldColor, newColor};
            bl = update2 = Messages.showOkCancelDialog((Component)parent2, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.replace", (Object[])objectArray), (String)title, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.update", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon()) == 0;
        }
        if (!update2) {
            return false;
        }
        configuration.setColorID(colorName);
        int row = toSharedList ? this.local.size() + index2 : index2;
        this.fireTableRowsUpdated(row, row);
        this.selectRow(row);
        return true;
    }

    private final void onRowInserted(int row) {
        this.fireTableRowsInserted(row, row);
        this.selectRow(row);
    }

    public final void addScopeColor(@NotNull NamedScope scope, @Nullable String color) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string2 = this.resolveCustomColor(color);
        if (string2 == null) {
            return;
        }
        String colorName = string2;
        String string3 = scope.getScopeId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scope.scopeId");
        if (this.resolveDuplicate(string3, colorName, false)) {
            return;
        }
        this.local.add(0, new FileColorConfiguration(scope.getScopeId(), colorName));
        this.onRowInserted(0);
    }

    @NotNull
    public final List<String> getColors() {
        List list2 = new ArrayList();
        Collection collection = list2;
        Collection<String> collection2 = this.manager.getColorNames();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"manager.colorNames");
        CollectionsKt.addAll((Collection)collection, (Iterable)collection2);
        ((Collection)list2).add(IdeBundle.message((String)"settings.file.color.custom.name", (Object[])new Object[0]));
        return list2;
    }

    @Override
    public int getColumnCount() {
        return FileColorsConfigurableKt.access$getColumns$p().length;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getName();
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getType();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getEditable();
    }

    @Override
    public int getRowCount() {
        return this.local.size() + this.shared.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int row, int column) {
        return switch (column) {
            case 0 -> {
                FileColorConfiguration v0 = this.getConfiguration(row);
                if (v0 != null) {
                    yield v0.getScopeName();
                }
                yield null;
            }
            case 1 -> this.getConfiguration(row);
            case 2 -> row >= this.local.size();
            default -> null;
        };
    }

    @Override
    public void setValueAt(@Nullable Object value, int row, int column) {
        switch (column) {
            case 1: {
                FileColorConfiguration fileColorConfiguration = this.getConfiguration(row);
                if (fileColorConfiguration == null) {
                    return;
                }
                FileColorConfiguration configuration = fileColorConfiguration;
                String string2 = this.resolveCustomColor(value);
                if (string2 == null) {
                    return;
                }
                configuration.setColorID(string2);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 2: {
                Integer n = this.getSharedIndex(row);
                if (n == null) {
                    return;
                }
                int index2 = n;
                if (index2 < 0) {
                    FileColorConfiguration configuration = this.local.remove(row);
                    this.fireTableRowsDeleted(row, row);
                    String string3 = configuration.getScopeName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configuration.scopeName");
                    String string4 = configuration.getColorID();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"configuration.colorID");
                    if (this.resolveDuplicate(string3, string4, true)) {
                        return;
                    }
                    this.shared.add(0, configuration);
                    this.onRowInserted(this.local.size());
                    break;
                }
                if (index2 >= this.shared.size()) break;
                FileColorConfiguration configuration = this.shared.remove(index2);
                this.fireTableRowsDeleted(row, row);
                String string5 = configuration.getScopeName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"configuration.scopeName");
                String string6 = configuration.getColorID();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"configuration.colorID");
                if (this.resolveDuplicate(string5, string6, false)) {
                    return;
                }
                this.local.add(configuration);
                this.onRowInserted(this.local.size() - 1);
            }
        }
    }

    @NotNull
    public Void addRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRow(int row) {
        Integer n = this.getSharedIndex(row);
        if (n == null) {
            return;
        }
        int index2 = n;
        if (index2 < 0) {
            this.local.remove(row);
        } else {
            this.shared.remove(index2);
        }
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void exchangeRows(int oldRow, int newRow) {
        if (oldRow == newRow) {
            return;
        }
        Integer n = this.getSharedIndex(oldRow);
        if (n == null) {
            return;
        }
        int oldIndex = n;
        Integer n2 = this.getSharedIndex(newRow);
        if (n2 == null) {
            return;
        }
        int newIndex = n2;
        if (oldIndex < 0 && newIndex < 0) {
            this.exchangeRows(this.local, oldRow, newRow);
        } else {
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            this.exchangeRows(this.shared, oldIndex, newIndex);
        }
        this.fireTableRowsUpdated(oldRow, oldRow);
        this.fireTableRowsUpdated(newRow, newRow);
    }

    private final void exchangeRows(List<FileColorConfiguration> list2, int oldIndex, int newIndex) {
        int maxIndex = RangesKt.coerceAtLeast((int)oldIndex, (int)newIndex);
        int minIndex = RangesKt.coerceAtMost((int)oldIndex, (int)newIndex);
        FileColorConfiguration maxConfiguration = list2.remove(maxIndex);
        FileColorConfiguration minConfiguration = list2.remove(minIndex);
        list2.add(minIndex, maxConfiguration);
        list2.add(maxIndex, minConfiguration);
    }

    @Override
    public boolean canExchangeRows(int oldRow, int newRow) {
        if (oldRow == newRow) {
            return true;
        }
        Integer n = this.getSharedIndex(oldRow);
        if (n == null) {
            return false;
        }
        int oldIndex = n;
        Integer n2 = this.getSharedIndex(newRow);
        if (n2 == null) {
            return false;
        }
        int newIndex = n2;
        return oldIndex < 0 == newIndex < 0;
    }

    @NotNull
    public JComponent createComponent() {
        JCheckBox editorCheckBox;
        DefaultCellEditor editorWrapper;
        JCheckBox rendererCheckBox;
        JBTable table = new JBTable((TableModel)this);
        table.setShowGrid(false);
        TableHoverListener.DEFAULT.removeFrom((JComponent)table);
        table.getEmptyText().setText(IdeBundle.message((String)"settings.file.colors.no.colors.specified", (Object[])new Object[0]));
        table.getEmptyText().appendSecondaryText(IdeBundle.message((String)"settings.file.colors.add.colors.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, arg_0 -> FileColorsTableModel.createComponent$lambda$5(this, table, arg_0));
        String string2 = KeymapUtil.getShortcutsText((Shortcut[])CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD).getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutsText(CommonA\u2026l.Buttons.ADD).shortcuts)");
        String shortcut = string2;
        if (((CharSequence)shortcut).length() > 0) {
            table.getEmptyText().appendText(" (" + shortcut + ")");
        }
        this.table = (JTable)table;
        table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
        table.setDefaultRenderer(String.class, (TableCellRenderer)new TableScopeRenderer(this.manager));
        Collection $this$toTypedArray$iv = this.getColors();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ComboBox editor2 = new ComboBox((Object[])thisCollection$iv.toArray(new String[0]));
        editor2.setRenderer((ListCellRenderer)new ComboBoxColorRenderer(this.manager));
        table.setDefaultEditor(FileColorConfiguration.class, (TableCellEditor)new DefaultCellEditor((JComboBox)editor2));
        table.setDefaultRenderer(FileColorConfiguration.class, (TableCellRenderer)new TableColorRenderer(this.manager));
        TableCellRenderer booleanRenderer = table.getDefaultRenderer(Boolean.class);
        JCheckBox jCheckBox = rendererCheckBox = booleanRenderer instanceof JCheckBox ? (JCheckBox)((Object)booleanRenderer) : null;
        if (jCheckBox != null) {
            jCheckBox.setHorizontalAlignment(2);
        }
        TableCellEditor booleanEditor = table.getDefaultEditor(Boolean.class);
        DefaultCellEditor defaultCellEditor = editorWrapper = booleanEditor instanceof DefaultCellEditor ? (DefaultCellEditor)booleanEditor : null;
        Component component2 = defaultCellEditor != null ? defaultCellEditor.getComponent() : null;
        JCheckBox jCheckBox2 = editorCheckBox = component2 instanceof JCheckBox ? (JCheckBox)component2 : null;
        if (jCheckBox2 != null) {
            jCheckBox2.setHorizontalAlignment(2);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)table)).setAddAction(arg_0 -> FileColorsTableModel.createComponent$lambda$7(this, arg_0)).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setMoveUpActionUpdater(arg_0 -> FileColorsTableModel.createComponent$lambda$9(table, this, arg_0)).setMoveDownActionUpdater(arg_0 -> FileColorsTableModel.createComponent$lambda$11(table, this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createDecorator(table)\n \u2026 } }\n      .createPanel()");
        return jPanel;
    }

    public boolean isModified() {
        return !Intrinsics.areEqual(this.local, this.manager.getApplicationLevelConfigurations()) || !Intrinsics.areEqual(this.shared, this.manager.getProjectLevelConfigurations());
    }

    public void apply() {
        this.manager.getModel().setConfigurations(this.copy(this.local), false);
        this.manager.getModel().setConfigurations(this.copy(this.shared), true);
    }

    public void reset() {
        this.local.clear();
        List<FileColorConfiguration> list2 = this.manager.getApplicationLevelConfigurations();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.applicationLevelConfigurations");
        this.local.addAll((Collection<FileColorConfiguration>)this.copy(list2));
        this.shared.clear();
        List<FileColorConfiguration> list3 = this.manager.getProjectLevelConfigurations();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"manager.projectLevelConfigurations");
        this.shared.addAll((Collection<FileColorConfiguration>)this.copy(list3));
        this.fireTableDataChanged();
    }

    private static final void createComponent$lambda$5(FileColorsTableModel this$0, JBTable $table, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ScopeListPopupStep(this$0));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance().createList\u2026ScopeListPopupStep(this))");
        ListPopup popup2 = listPopup;
        popup2.showInCenterOf((Component)$table);
    }

    private static final void createComponent$lambda$7(FileColorsTableModel this$0, AnActionButton it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ScopeListPopupStep(this$0));
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"getInstance().createList\u2026ScopeListPopupStep(this))");
            ListPopup popup2 = listPopup;
            RelativePoint relativePoint = it.getPreferredPopupPoint();
            if (relativePoint == null) break block0;
            RelativePoint point = relativePoint;
            boolean bl = false;
            popup2.show(point);
        }
    }

    private static final boolean createComponent$lambda$9(JBTable $table, FileColorsTableModel this$0, AnActionEvent it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int[] nArray = $table.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
            int[] $this$all$iv = nArray;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                int element$iv;
                int it2 = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (this$0.canExchangeRows(it2, it2 - 1)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final boolean createComponent$lambda$11(JBTable $table, FileColorsTableModel this$0, AnActionEvent it) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int[] nArray = $table.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
            int[] $this$all$iv = nArray;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                int element$iv;
                int it2 = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (this$0.canExchangeRows(it2, it2 + 1)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }
}

