/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class CodeWriter
extends PrintWriter {
    private final int myIndent;
    private int myIndentLevel = 0;
    private boolean myNewLineStarted = true;

    public CodeWriter(PrintWriter writer) {
        super(writer);
        this.myIndent = 2;
    }

    @Override
    public void print(@NonNls String s) {
        this.possiblyIndent(s);
        super.print(s);
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (CodeWriter.isOpenBrace(s, i2)) {
                ++this.myIndentLevel;
            }
            if (!CodeWriter.isCloseBrace(s, i2)) continue;
            --this.myIndentLevel;
        }
    }

    private static boolean isCloseBrace(String s, int index2) {
        char c2 = s.charAt(index2);
        return c2 == ')' || c2 == ']' || c2 == '}';
    }

    private static boolean isOpenBrace(String s, int index2) {
        char c2 = s.charAt(index2);
        return c2 == '(' || c2 == '[' || c2 == '{';
    }

    @Override
    public void println() {
        ((PrintWriter)this.out).println();
        this.myNewLineStarted = true;
    }

    private void possiblyIndent(String s) {
        if (this.myNewLineStarted) {
            int firstNonBlank;
            int i2;
            for (i2 = 0; i2 < s.length() && s.charAt(i2) == ' '; ++i2) {
            }
            int n = firstNonBlank = i2 < s.length() && s.charAt(i2) != ' ' ? i2 : -1;
            if (firstNonBlank >= 0) {
                if (CodeWriter.isCloseBrace(s, firstNonBlank)) {
                    --this.myIndentLevel;
                }
                int blanksToPrint = this.myIndent * this.myIndentLevel - firstNonBlank;
                for (int j = 0; j < blanksToPrint; ++j) {
                    this.write(" ");
                }
                if (CodeWriter.isCloseBrace(s, firstNonBlank)) {
                    ++this.myIndentLevel;
                }
            }
            this.myNewLineStarted = false;
        }
    }

    @Override
    public void println(String s) {
        StringTokenizer st = new StringTokenizer(s, "\r\n", false);
        while (st.hasMoreTokens()) {
            super.println(st.nextToken());
        }
    }
}

