/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final long DEFAULT_SHELL_ENV_READING_TIMEOUT_MILLIS = 20000L;
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String DESKTOP_STARTUP_ID = "DESKTOP_STARTUP_ID";
    public static final String BASH_EXECUTABLE_NAME = "bash";
    public static final String SHELL_VARIABLE_NAME = "SHELL";
    private static final String SHELL_INTERACTIVE_ARGUMENT = "-i";
    public static final String SHELL_LOGIN_ARGUMENT = "-l";
    public static final String SHELL_COMMAND_ARGUMENT = "-c";
    public static final String SHELL_SOURCE_COMMAND = "source";
    public static final String SHELL_ENV_COMMAND = "/usr/bin/env";
    public static final String ENV_ZERO_ARGUMENT = "-0";
    public static final String MacOS_LOADER_BINARY = "printenv";
    private static final String SHLVL = "SHLVL";
    private static final AtomicReference<CompletableDeferred<Map<String, String>>> ourEnvGetter = new AtomicReference();
    public static final String DISABLE_OMZ_AUTO_UPDATE = "DISABLE_AUTO_UPDATE";
    private static final String INTELLIJ_ENVIRONMENT_READER = "INTELLIJ_ENVIRONMENT_READER";

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map2;
        CompletableDeferred<Map<String, String>> getter = ourEnvGetter.get();
        if (getter == null && !ourEnvGetter.compareAndSet(null, getter = CompletableDeferredKt.CompletableDeferred(EnvironmentUtil.getSystemEnv()))) {
            getter = ourEnvGetter.get();
        }
        try {
            map2 = FutureKt.asCompletableFuture(getter).join();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
        if (map2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @ApiStatus.Internal
    @Nullable
    public static Boolean loadEnvironment(@NotNull Job parentJob) {
        Boolean result2;
        CompletableDeferred<Job> envFuture;
        block6: {
            if (parentJob == null) {
                EnvironmentUtil.$$$reportNull$$$0(1);
            }
            if (!EnvironmentUtil.shouldLoadShellEnv()) {
                ourEnvGetter.set(CompletableDeferredKt.CompletableDeferred(EnvironmentUtil.getSystemEnv()));
                return null;
            }
            envFuture = CompletableDeferredKt.CompletableDeferred(parentJob);
            ourEnvGetter.set(envFuture);
            result2 = Boolean.TRUE;
            try {
                Map<String, String> env = EnvironmentUtil.getShellEnv(Long.getLong("ij.load.shell.env.timeout", 20000L));
                EnvironmentUtil.setCharsetVar(env);
                envFuture.complete((Job)((Object)Collections.unmodifiableMap(env)));
            }
            catch (Throwable t) {
                result2 = Boolean.FALSE;
                LOG.warn("can't get shell environment", t);
                if (!(t instanceof ExceptionWithAttachments)) break block6;
                for (Attachment attachment : ((ExceptionWithAttachments)((Object)t)).getAttachments()) {
                    LOG.warn(attachment.getPath() + ":\n" + attachment.getDisplayText());
                }
            }
        }
        if (result2 == Boolean.FALSE) {
            envFuture.complete((Job)((Object)EnvironmentUtil.getSystemEnv()));
        }
        return result2;
    }

    private static boolean shouldLoadShellEnv() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        if (!Boolean.parseBoolean(System.getProperty("ij.load.shell.env", "true"))) {
            LOG.info("loading shell env is turned off");
            return false;
        }
        String shLvl = System.getenv(SHLVL);
        try {
            if (shLvl != null && Integer.parseInt(shLvl) > 0) {
                LOG.info("loading shell env is skipped: IDE has been launched from a terminal (SHLVL=" + shLvl + ')');
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOG.info("loading shell env is skipped: IDE has been launched with malformed SHLVL=" + shLvl);
            return false;
        }
        return true;
    }

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map2 = Collections.unmodifiableMap(CollectionFactory.createCaseInsensitiveStringMap(System.getenv()));
            if (map2 == null) {
                EnvironmentUtil.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (SystemInfoRt.isXWindow) {
            Map<String, String> env = System.getenv();
            if (env.containsKey(DESKTOP_STARTUP_ID)) {
                env = new HashMap<String, String>(env);
                env.remove(DESKTOP_STARTUP_ID);
                env = Collections.unmodifiableMap(env);
            }
            Map<String, String> map3 = env;
            if (map3 == null) {
                EnvironmentUtil.$$$reportNull$$$0(3);
            }
            return map3;
        }
        Map<String, String> map4 = System.getenv();
        if (map4 == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return map4;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidName(@Nullable String name) {
        return name != null && !name.isEmpty() && name.indexOf(0) == -1 && name.indexOf(61, SystemInfoRt.isWindows ? 1 : 0) == -1;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isValidValue(@Nullable String value) {
        return value != null && value.indexOf(0) == -1;
    }

    private static Map<String, String> getShellEnv(long timeoutMillis) throws IOException {
        return new ShellEnvReader(timeoutMillis).readShellEnv(null, null);
    }

    @ApiStatus.Experimental
    @NotNull
    public static List<String> buildShellProcessCommand(@NotNull String shell, boolean isLogin, boolean isInteractive, boolean isCommand) {
        if (shell == null) {
            EnvironmentUtil.$$$reportNull$$$0(6);
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(shell);
        if (isLogin && !shell.endsWith("/tcsh") && !shell.endsWith("/csh")) {
            commands.add(SHELL_LOGIN_ARGUMENT);
        }
        if (isInteractive && !shell.endsWith("/fish")) {
            commands.add(SHELL_INTERACTIVE_ARGUMENT);
        }
        if (isCommand) {
            commands.add(SHELL_COMMAND_ARGUMENT);
        }
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            EnvironmentUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, String> parseEnv(String @NotNull [] lines2) {
        if (lines2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(8);
        }
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", SHLVL, DISABLE_OMZ_AUTO_UPDATE, INTELLIJ_ENVIRONMENT_READER));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines2) {
            if (line.isEmpty()) continue;
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new RuntimeException("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            EnvironmentUtil.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    @NotNull
    private static Map<String, String> parseEnv(@NotNull String text2) {
        if (text2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(10);
        }
        return EnvironmentUtil.parseEnv(text2.split("\u0000"));
    }

    private static int waitAndTerminateAfter(@NotNull Process process2, long timeoutMillis) {
        Integer exitCode;
        if (process2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(11);
        }
        if ((exitCode = EnvironmentUtil.waitFor(process2, timeoutMillis)) != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        if (!SystemInfoRt.isWindows) {
            UnixProcessManager.sendSigIntToProcessTree(process2);
            exitCode = EnvironmentUtil.waitFor(process2, 1000L);
            if (exitCode != null) {
                return exitCode;
            }
            LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        }
        if (SystemInfoRt.isWindows) {
            WinProcessManager.kill(process2, true);
        } else {
            UnixProcessManager.sendSigKillToProcessTree(process2);
        }
        exitCode = EnvironmentUtil.waitFor(process2, 1000L);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process2, long timeoutMillis) {
        if (process2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(12);
        }
        try {
            if (process2.waitFor(timeoutMillis, TimeUnit.MILLISECONDS)) {
                return process2.exitValue();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for process", e);
        }
        return null;
    }

    private static void setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(13);
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, Charset.defaultCharset());
            LOG.info("LC_CTYPE=" + value);
        }
    }

    private static boolean checkIfLocaleAvailable(String candidateLanguageTerritory) {
        Locale[] available;
        for (Locale l : available = Locale.getAvailableLocales()) {
            if (!Objects.equals(l.toString(), candidateLanguageTerritory)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        String languageTerritoryFromLocale;
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(14);
        }
        if (charset == null) {
            EnvironmentUtil.$$$reportNull$$$0(15);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String languageTerritory = "en_US";
        if (!language.isEmpty() && !country.isEmpty() && EnvironmentUtil.checkIfLocaleAvailable(languageTerritoryFromLocale = language + '_' + country)) {
            languageTerritory = languageTerritoryFromLocale;
        }
        String result2 = languageTerritory + '.' + charset.name();
        env.put(LC_CTYPE, result2);
        String string2 = result2;
        if (string2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(16);
        }
        return string2;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            EnvironmentUtil.$$$reportNull$$$0(17);
        }
        return !env.isEmpty() && (env.containsKey(LANG) || env.containsKey(LC_ALL) || env.containsKey(LC_CTYPE));
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(18);
        }
        EnvironmentUtil.inlineParentOccurrences(envs, EnvironmentUtil.getEnvironmentMap());
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs, @NotNull Map<String, String> parentEnv) {
        if (envs == null) {
            EnvironmentUtil.$$$reportNull$$$0(19);
        }
        if (parentEnv == null) {
            EnvironmentUtil.$$$reportNull$$$0(20);
        }
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = parentEnv.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    public static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    @TestOnly
    static Map<String, String> testLoader() throws IOException {
        return EnvironmentUtil.getShellEnv(20000L);
    }

    @TestOnly
    static Map<String, String> testParser(@NotNull String lines2) {
        if (lines2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(21);
        }
        try {
            return EnvironmentUtil.parseEnv(lines2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentJob";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shell";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ShellEnvReader {
        private final long myTimeoutMillis;

        public ShellEnvReader() {
            this(20000L);
        }

        public ShellEnvReader(long timeoutMillis) {
            this.myTimeoutMillis = timeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Map<String, String> readShellEnv(@Nullable Path file2, @Nullable Map<String, String> additionalEnvironment) throws IOException {
            String reader = SystemInfoRt.isMac ? PathManager.findBinFileWithException(EnvironmentUtil.MacOS_LOADER_BINARY).toAbsolutePath().toString() : "/usr/bin/env' '-0";
            Path envDataFileDir = Files.createTempDirectory("ij-env-tmp-dir", new FileAttribute[0]);
            Path envDataFile = envDataFileDir.resolve("ij-shell-env-data.tmp");
            StringBuilder readerCmd = new StringBuilder();
            if (file2 != null) {
                if (!Files.exists(file2, new LinkOption[0])) {
                    throw new NoSuchFileException(file2.toString());
                }
                readerCmd.append(EnvironmentUtil.SHELL_SOURCE_COMMAND).append(" \"").append(file2).append("\" && ");
            }
            readerCmd.append("'").append(reader).append("' > '").append(envDataFile.toAbsolutePath()).append("'");
            List<String> command2 = this.getShellProcessCommand();
            int idx = command2.indexOf(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
            if (idx >= 0) {
                command2.set(idx + 1, command2.get(idx + 1) + ';' + readerCmd);
            } else {
                command2.add(EnvironmentUtil.SHELL_COMMAND_ARGUMENT);
                command2.add(readerCmd.toString());
            }
            LOG.info("loading shell env: " + String.join((CharSequence)" ", command2));
            Map<String, String> map2 = this.runProcessAndReadOutputAndEnvs(command2, null, additionalEnvironment, envDataFile).getValue();
            Map<String, String> map3 = map2;
            if (map3 == null) {
                ShellEnvReader.$$$reportNull$$$0(0);
            }
            return map3;
            finally {
                ShellEnvReader.deleteTempFile(envDataFile);
                ShellEnvReader.deleteTempFile(envDataFileDir);
            }
        }

        @NotNull
        protected final Map.Entry<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command2, @Nullable Path workingDir, @Nullable Map<String, String> scriptEnvironment, @NotNull Path envDataFile) throws IOException {
            if (command2 == null) {
                ShellEnvReader.$$$reportNull$$$0(1);
            }
            if (envDataFile == null) {
                ShellEnvReader.$$$reportNull$$$0(2);
            }
            return this.runProcessAndReadOutputAndEnvs(command2, workingDir, (? super Map<String, String> it) -> {
                if (scriptEnvironment != null) {
                    it.putAll(scriptEnvironment);
                }
            }, envDataFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected final Map.Entry<String, Map<String, String>> runProcessAndReadOutputAndEnvs(@NotNull List<String> command2, @Nullable Path workingDir, @NotNull @NotNull Consumer<? super @NotNull Map<String, String>> scriptEnvironmentProcessor, @NotNull Path envDataFile) throws IOException {
            String log;
            if (command2 == null) {
                ShellEnvReader.$$$reportNull$$$0(3);
            }
            if (scriptEnvironmentProcessor == null) {
                ShellEnvReader.$$$reportNull$$$0(4);
            }
            if (envDataFile == null) {
                ShellEnvReader.$$$reportNull$$$0(5);
            }
            ProcessBuilder builder2 = new ProcessBuilder(command2);
            scriptEnvironmentProcessor.accept(builder2.environment());
            if (workingDir != null) {
                builder2.directory(workingDir.toFile());
            }
            builder2.environment().put(EnvironmentUtil.DISABLE_OMZ_AUTO_UPDATE, "true");
            builder2.environment().put(EnvironmentUtil.INTELLIJ_ENVIRONMENT_READER, "true");
            Path logFile = Files.createTempFile("ij-shell-env-log.", ".tmp", new FileAttribute[0]);
            Process process2 = builder2.redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.to(logFile.toFile())).start();
            int exitCode = EnvironmentUtil.waitAndTerminateAfter(process2, this.myTimeoutMillis);
            String envData = Files.exists(envDataFile, new LinkOption[0]) ? new String(Files.readAllBytes(envDataFile), Charset.defaultCharset()) : "";
            String string2 = log = Files.exists(logFile, new LinkOption[0]) ? new String(Files.readAllBytes(logFile), Charset.defaultCharset()) : "(no log file)";
            if (exitCode != 0 || envData.isEmpty()) {
                if (!log.isEmpty()) {
                    LOG.info("stdout/stderr: " + log);
                }
                throw new EnvironmentReaderException("command " + command2 + ", exit code: " + exitCode, envData, log);
            }
            AbstractMap.SimpleImmutableEntry<String, Map<String, String>> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, Map<String, String>>(log, EnvironmentUtil.parseEnv(envData));
            AbstractMap.SimpleImmutableEntry<String, Map<String, String>> simpleImmutableEntry2 = simpleImmutableEntry;
            if (simpleImmutableEntry2 == null) {
                ShellEnvReader.$$$reportNull$$$0(6);
            }
            return simpleImmutableEntry2;
            finally {
                ShellEnvReader.deleteTempFile(logFile);
            }
        }

        private static void deleteTempFile(@Nullable Path file2) {
            try {
                if (file2 != null) {
                    Files.delete(file2);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
            catch (IOException e) {
                LOG.warn("Cannot delete temporary file", e);
            }
        }

        @NotNull
        protected List<String> getShellProcessCommand() {
            String shellScript = this.getShell();
            if (shellScript == null || shellScript.isEmpty()) {
                throw new RuntimeException("empty $SHELL");
            }
            if (!Files.isExecutable(Paths.get(shellScript, new String[0]))) {
                throw new RuntimeException("$SHELL points to a missing or non-executable file: " + shellScript);
            }
            List<String> list2 = EnvironmentUtil.buildShellProcessCommand(shellScript, true, true, false);
            if (list2 == null) {
                ShellEnvReader.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @Nullable
        protected String getShell() {
            return System.getenv(EnvironmentUtil.SHELL_VARIABLE_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envDataFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptEnvironmentProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readShellEnv";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/EnvironmentUtil$ShellEnvReader";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShellProcessCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "runProcessAndReadOutputAndEnvs";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EnvironmentReaderException
    extends IOException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private EnvironmentReaderException(String message, String data2, String log) {
            super(message);
            this.myAttachments = new Attachment[]{new Attachment("EnvReaderData.txt", data2), new Attachment("EnvReaderLog.txt", log)};
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            if (this.myAttachments == null) {
                EnvironmentReaderException.$$$reportNull$$$0(0);
            }
            return this.myAttachments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$EnvironmentReaderException", "getAttachments"));
        }
    }
}

