/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.SvgCacheMapper;
import com.intellij.util.ImageCache;
import com.intellij.util.ImageLoader;
import com.intellij.util.ImageLoaderKt;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001MB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002JN\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0011J&\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJ/\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020#2\f\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0001\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020.H\u0007J\u0012\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u00100\u001a\u000201H\u0007J\u0010\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203J\u0012\u00104\u001a\u0004\u0018\u00010\u00142\u0006\u00105\u001a\u00020&H\u0007J\u0017\u00106\u001a\u0004\u0018\u00010\u00142\u000b\u00107\u001a\u00070#\u00a2\u0006\u0002\b8H\u0007J#\u00106\u001a\u0004\u0018\u00010\u00142\u000b\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b82\n\u00109\u001a\u0006\u0012\u0002\b\u00030(H\u0007J\u0012\u0010:\u001a\u0004\u0018\u00010\u00142\u0006\u0010;\u001a\u00020<H\u0007J6\u0010:\u001a\u00020\u00142\u0006\u0010=\u001a\u00020<2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0012\u001a\u00020\u000f2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010@\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203H\u0007J.\u0010@\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020#2\f\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJD\u0010A\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010B\u001a\u00020C2\u000e\b\u0002\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0011H\u0007J\u001a\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0007J4\u0010G\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0012\u001a\u00020\u000f2\u000e\b\u0002\u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010(H\u0007J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020IH\u0007J\u0018\u0010H\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\u0004H\u0007J \u0010H\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006N"}, d2={"Lcom/intellij/util/ImageLoader;", "", "()V", "ALLOW_FLOAT_SCALING", "", "USE_CACHE", "USE_DARK", "USE_SVG", "ourComponent", "Ljava/awt/Component;", "getOurComponent", "()Ljava/awt/Component;", "ourComponent$delegate", "Lkotlin/Lazy;", "adjustScaleFactor", "", "allowFloatScaling", "", "scale", "convertImage", "Ljava/awt/Image;", "image", "filters", "", "Ljava/awt/image/ImageFilter;", "flags", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "isUpScaleNeeded", "isHiDpiNeeded", "imageScale", "isSvg", "createImageDescriptorList", "Lcom/intellij/ui/icons/ImageDescriptor;", "path", "", "getImageDescriptors", "getResourceData", "", "resourceClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "getResourceData$intellij_platform_util_ui", "isIconTooLargeForCache", "icon", "Ljavax/swing/Icon;", "loadCustomIcon", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "loadFromBytes", "bytes", "loadFromResource", "s", "Lorg/jetbrains/annotations/NonNls;", "aClass", "loadFromStream", "inputStream", "Ljava/io/InputStream;", "stream", "originalUserSize", "Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "loadFromUrl", "loadImage", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "loadImageForStartUp", "Ljava/awt/image/BufferedImage;", "requestedPath", "loadPngFromClassResource", "scaleImage", "", "targetSize", "targetWidth", "targetHeight", "Dimension2DDouble", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoader.kt\ncom/intellij/util/ImageLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,638:1\n1#2:639\n*E\n"})
public final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE = new ImageLoader();
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final int USE_CACHE = 2;
    public static final int USE_DARK = 4;
    public static final int USE_SVG = 8;
    @NotNull
    private static final Lazy ourComponent$delegate = LazyKt.lazy((Function0)ourComponent.2.INSTANCE);

    private ImageLoader() {
    }

    @ApiStatus.Internal
    @NotNull
    public final Component getOurComponent() {
        Lazy lazy = ourComponent$delegate;
        return (Component)lazy.getValue();
    }

    @ApiStatus.Internal
    public final boolean isIconTooLargeForCache(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        return 4L * (long)icon2.getIconWidth() * (long)icon2.getIconHeight() > ImageLoaderKt.getCACHED_IMAGE_MAX_SIZE();
    }

    @ApiStatus.Internal
    @Nullable
    public final Image loadImage(@NotNull String path2, @NotNull LoadIconParameters parameters2, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, int flags, boolean isUpScaleNeeded) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        List<ImageDescriptor> descriptors = this.createImageDescriptorList(path2, flags, parameters2.scaleContext);
        ImageCache imageCache2 = ImageCache.Companion.getINSTANCE();
        boolean ioExceptionThrown = false;
        int n = descriptors.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ImageDescriptor descriptor2 = descriptors.get(i2);
            try {
                Image image = ImageLoaderKt.access$loadByDescriptor(descriptor2, flags, resourceClass, classLoader, i2 == 0 ? imageCache2.ioMissCache : null, imageCache2, path2, parameters2.colorPatcher);
                if (image == null) continue;
                Image image2 = image;
                if (start != -1L) {
                    IconLoadMeasurer.INSTANCE.addLoading(descriptor2.isSvg, start);
                }
                boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(parameters2.scaleContext);
                return this.convertImage(image2, parameters2.filters, flags, parameters2.scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor2.scale, descriptor2.isSvg);
            }
            catch (IOException e) {
                ioExceptionThrown = true;
            }
        }
        if (ioExceptionThrown) {
            imageCache2.ioMissCache.add(path2);
        }
        return null;
    }

    public static /* synthetic */ Image loadImage$default(ImageLoader imageLoader, String string2, LoadIconParameters loadIconParameters, Class clazz, ClassLoader classLoader, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            clazz = null;
        }
        return imageLoader.loadImage(string2, loadIconParameters, clazz, classLoader, n, bl);
    }

    @ApiStatus.Internal
    @Nullable
    public final BufferedImage loadImageForStartUp(@NotNull String requestedPath, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)requestedPath, (String)"requestedPath");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ScaleContext scaleContext = ScaleContext.create();
        Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"create()");
        ScaleContext scaleContext2 = scaleContext;
        List<ImageDescriptor> descriptors = this.createImageDescriptorList(requestedPath, 1, scaleContext2);
        for (ImageDescriptor descriptor2 : descriptors) {
            try {
                byte[] byArray = this.getResourceData$intellij_platform_util_ui(descriptor2.path, null, classLoader);
                if (byArray == null) continue;
                byte[] data2 = byArray;
                Image image = null;
                if (descriptor2.isSvg) {
                    return SVGLoader.INSTANCE.loadWithoutCache(data2, descriptor2.scale);
                }
                image = ImageLoaderKt.loadPng(new ByteArrayInputStream(data2), descriptor2.scale, null);
                float scale = (float)scaleContext2.getScale(DerivedScaleType.PIX_SCALE);
                if (descriptor2.scale > 1.0f) {
                    scale /= descriptor2.scale;
                }
                Image image2 = ImageLoader.scaleImage(image, scale);
                Intrinsics.checkNotNull((Object)image2, (String)"null cannot be cast to non-null type java.awt.image.BufferedImage");
                return (BufferedImage)image2;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @Nullable
    public final byte[] getResourceData$intellij_platform_util_ui(@NotNull String path2, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) {
        Object object;
        Object data2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        boolean bl2 = bl = resourceClass != null || classLoader != null || StringsKt.startsWith$default((String)path2, (String)"file://", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (classLoader != null) {
            String string3;
            boolean isAbsolute = StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null);
            if (isAbsolute) {
                String string4 = path2.substring(1);
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string3 = path2;
            }
            data2 = ResourceUtil.getResourceAsBytes(string3, classLoader, true);
            if (data2 != null || isAbsolute) {
                return data2;
            }
        }
        if ((object = resourceClass) != null && (object = ((Class)object).getResourceAsStream(path2)) != null) {
            data2 = (Closeable)object;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)data2;
                boolean bl3 = false;
                byte[] byArray = stream.readAllBytes();
                return byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)data2, (Throwable)throwable);
            }
        }
        if (StringsKt.startsWith$default((String)path2, (String)"file:/", (boolean)false, (int)2, null)) {
            Path nioPath = Path.of(URI.create(path2));
            try {
                return Files.readAllBytes(nioPath);
            }
            catch (NoSuchFileException e) {
                return null;
            }
            catch (IOException e) {
                ImageLoaderKt.access$getLOG().warn(e);
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public final Image loadPngFromClassResource(@NotNull String path2, @Nullable ClassLoader classLoader, float scale, @Nullable Class<?> resourceClass) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        byte[] byArray = this.getResourceData$intellij_platform_util_ui(path2, resourceClass, classLoader);
        if (byArray == null) {
            return null;
        }
        byte[] data2 = byArray;
        return ImageLoaderKt.loadPng(new ByteArrayInputStream(data2), scale, null);
    }

    public static /* synthetic */ Image loadPngFromClassResource$default(ImageLoader imageLoader, String string2, ClassLoader classLoader, float f, Class clazz, int n, Object object) {
        if ((n & 8) != 0) {
            clazz = null;
        }
        return imageLoader.loadPngFromClassResource(string2, classLoader, f, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public final Image loadFromStream(@NotNull InputStream stream, @Nullable String path2, float scale, @Nullable Dimension2DDouble originalUserSize, int flags) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            Image image;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            if ((flags & 8) == 8) {
                SvgCacheMapper mapper = new SvgCacheMapper(scale, (flags & 4) == 4, false);
                image = SVGLoader.INSTANCE.load$intellij_platform_util_ui(path2, stream, mapper, null);
            } else {
                image = ImageLoaderKt.loadPng(stream, scale, originalUserSize);
            }
            Image image2 = image;
            return image2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ Image loadFromStream$default(ImageLoader imageLoader, InputStream inputStream, String string2, float f, Dimension2DDouble dimension2DDouble, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            dimension2DDouble = null;
        }
        return imageLoader.loadFromStream(inputStream, string2, f, dimension2DDouble, n);
    }

    @NotNull
    public final Image convertImage(@NotNull Image image, @NotNull List<? extends ImageFilter> filters, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded, boolean isHiDpiNeeded, float imageScale, boolean isSvg) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        Image result2 = image;
        if (isUpScaleNeeded && !isSvg) {
            float scale = this.adjustScaleFactor((flags & 1) == 1, (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE));
            if (imageScale > 1.0f) {
                scale /= imageScale;
            }
            result2 = ImageLoader.scaleImage(result2, scale);
        }
        if (!filters.isEmpty()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (ImageFilter imageFilter : filters) {
                if (imageFilter == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)toolkit.createImage(new FilteredImageSource(ImageUtil.toBufferedImage(result2, false).getSource(), imageFilter)), (String)"toolkit.createImage(Filt\u2026, false).source, filter))");
            }
        }
        if (isHiDpiNeeded) {
            result2 = new JBHiDPIScaledImage(result2, scaleContext, 2);
        }
        return result2;
    }

    @NotNull
    public final List<ImageDescriptor> getImageDescriptors(@NotNull String path2, int flags, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        return this.createImageDescriptorList(path2, flags, scaleContext);
    }

    private final List<ImageDescriptor> createImageDescriptorList(String path2, int flags, ScaleContext scaleContext) {
        String string2;
        String string3;
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int i2 = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (i2 < 0) {
            string3 = path2;
        } else {
            String string4 = path2.substring(0, i2);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        String name = string3;
        if (i2 < 0 || i2 == path2.length() - 1) {
            string2 = "";
        } else {
            String string5 = path2.substring(i2 + 1);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
        }
        String ext = string2;
        float scale = this.adjustScaleFactor((flags & 1) == 1, pixScale);
        List list2 = null;
        if (!StringsKt.startsWith$default((String)path2, (String)"file:", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)path2, (CharSequence)"://", (boolean)false, (int)2, null)) {
            String string6;
            int qI = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'?', (int)0, (boolean)false, (int)6, null);
            if (qI == -1) {
                string6 = path2;
            } else {
                String string7 = path2.substring(0, qI);
                string6 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            boolean isSvg = StringUtilRt.endsWithIgnoreCase(string6, ".svg");
            list2 = CollectionsKt.listOf((Object)new ImageDescriptor(name + "." + ext, 1.0f, isSvg, true, false));
        } else {
            boolean isSvg = StringsKt.equals((String)"svg", (String)ext, (boolean)true);
            boolean isDark = (flags & 4) == 4;
            boolean retina = JBUIScale.isHiDPI(pixScale);
            list2 = new ArrayList();
            if (!isSvg && (flags & 8) == 8) {
                ImageLoaderKt.access$addFileNameVariant(retina, isDark, true, false, name, ext, scale, list2);
            }
            ImageLoaderKt.access$addFileNameVariant(retina, isDark, false, isSvg, name, ext, scale, list2);
            if (isDark) {
                ImageLoaderKt.access$addFileNameVariant(retina, false, false, isSvg, name, ext, scale, list2);
                if (!isSvg && (flags & 8) == 8) {
                    ImageLoaderKt.access$addFileNameVariant(false, false, false, true, name, ext, scale, list2);
                }
            }
        }
        return list2;
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int flags = 11;
        boolean isDark = StartupUiUtil.isUnderDarcula();
        if (isDark) {
            flags |= 4;
        }
        String string2 = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.toString()");
        String path2 = string2;
        return ImageLoader.loadImage$default(INSTANCE, path2, LoadIconParameters.Companion.defaultParameters(isDark), null, null, flags, !StringsKt.endsWith$default((String)path2, (String)".svg", (boolean)false, (int)2, null), 4, null);
    }

    @Nullable
    public final Image loadFromUrl(@NotNull String path2, @Nullable Class<?> aClass, int flags, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        LoadIconParameters parameters2 = new LoadIconParameters(CollectionsKt.emptyList(), scaleContext, (flags & 4) == 4, null, false);
        return this.loadImage(path2, parameters2, aClass, null, flags, !StringsKt.endsWith$default((String)path2, (String)".svg", (boolean)false, (int)2, null));
    }

    private final float adjustScaleFactor(boolean allowFloatScaling, float scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0f : 1.0f);
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, double scale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (scale == 1.0) {
            return image;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            Intrinsics.checkNotNullExpressionValue((Object)jBHiDPIScaledImage, (String)"image.scale(scale)");
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            return image;
        }
        int width = MathKt.roundToInt((double)(scale * (double)w));
        int height = MathKt.roundToInt((double)(scale * (double)h));
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{null};
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image, false), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])bufferedImageOpArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"resize(ImageUtil.toBuffe\u2026ACT, width, height, null)");
        return bufferedImage;
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, int targetSize) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @JvmStatic
    @NotNull
    public static final Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        Image image2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
            Intrinsics.checkNotNullExpressionValue((Object)jBHiDPIScaledImage, (String)"image.scale(targetWidth, targetHeight)");
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            image2 = image;
        } else {
            BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{null};
            BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])bufferedImageOpArray);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"{\n      Scalr.resize(Ima\u2026targetHeight, null)\n    }");
            image2 = bufferedImage;
        }
        return image2;
    }

    @JvmStatic
    @Deprecated(message="Use {@link #loadFromResource(String, Class)}")
    @Nullable
    public static final Image loadFromResource(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Class<?> callerClass = ReflectionUtil.getGrandCallerClass();
        return callerClass == null ? null : ImageLoader.loadFromResource(s, callerClass);
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromResource(@NotNull String path2, @NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        int flags = 11;
        boolean isDark = StartupUiUtil.isUnderDarcula();
        if (isDark) {
            flags |= 4;
        }
        return INSTANCE.loadImage(path2, LoadIconParameters.Companion.defaultParameters(isDark), aClass, null, flags, false);
    }

    @JvmStatic
    @Nullable
    public static final Image loadFromBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Image loadFromStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ScaleContext scaleContext = ScaleContext.create();
        Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"create()");
        ScaleContext scaleContext2 = scaleContext;
        try {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
                float scale = (float)scaleContext2.getScale(DerivedScaleType.PIX_SCALE);
                Image image = ImageLoaderKt.loadPng(inputStream, scale, originalUserSize);
                if (StartupUiUtil.isJreHiDPI(scaleContext2)) {
                    double userScale = scaleContext2.getScale(DerivedScaleType.EFF_USR_SCALE);
                    Image image2 = image;
                    Intrinsics.checkNotNull((Object)image2);
                    image = new JBHiDPIScaledImage(image2, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
                }
                Image image3 = image;
                return image3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            ImageLoaderKt.access$getLOG().error(e);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final Image loadCustomIcon(@NotNull File file2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        URL uRL = file2.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"file.toURI().toURL()");
        return INSTANCE.loadCustomIcon(uRL);
    }

    @Nullable
    public final Image loadCustomIcon(@NotNull URL url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string2 = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.toString()");
        String iconPath = string2;
        ScaleContext scaleContext = ScaleContext.create();
        Intrinsics.checkNotNullExpressionValue((Object)scaleContext, (String)"create()");
        ScaleContext scaleContext2 = scaleContext;
        float scale = (float)scaleContext2.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor imageDescriptor = new ImageDescriptor(iconPath, scale, StringUtilRt.endsWithIgnoreCase(iconPath, ".svg"), StringsKt.contains$default((CharSequence)iconPath, (CharSequence)"_dark.", (boolean)false, (int)2, null), StringsKt.contains$default((CharSequence)iconPath, (CharSequence)"_stroke.", (boolean)false, (int)2, null));
        Image image = ImageUtil.ensureHiDPI(ImageLoaderKt.access$loadByDescriptor(imageDescriptor, 2, null, null, null, ImageCache.Companion.getINSTANCE(), null, null), scaleContext2);
        if (image == null) {
            return null;
        }
        Image icon2 = image;
        int w = icon2.getWidth(null);
        int h = icon2.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoaderKt.access$getLOG().error("negative image size: w=" + w + ", h=" + h + ", path=" + iconPath);
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)RangesKt.coerceAtLeast((int)w, (int)h);
            return ImageLoader.scaleImage(icon2, s);
        }
        return icon2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "", "width", "", "height", "(DD)V", "getHeight", "()D", "setHeight", "(D)V", "getWidth", "setWidth", "setSize", "", "size", "intellij.platform.util.ui"})
    public static final class Dimension2DDouble {
        private double width;
        private double height;

        public Dimension2DDouble(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public final double getWidth() {
            return this.width;
        }

        public final void setWidth(double d) {
            this.width = d;
        }

        public final double getHeight() {
            return this.height;
        }

        public final void setHeight(double d) {
            this.height = d;
        }

        public final void setSize(@NotNull Dimension2DDouble size) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.width = size.width;
            this.height = size.height;
        }

        public final void setSize(double width, double height) {
            this.width = width;
            this.height = height;
        }
    }
}

