/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.svg.SvgCacheMapper;
import com.intellij.util.CacheKey;
import com.intellij.util.ImageCache;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u001a`\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0002\u001a4\u0010'\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002\u001a\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006."}, d2={"CACHED_IMAGE_MAX_SIZE", "", "getCACHED_IMAGE_MAX_SIZE", "()J", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "addFileNameVariant", "", "retina", "", "isDark", "isStroke", "isSvg", "name", "", "ext", "scale", "", "list", "", "Lcom/intellij/ui/icons/ImageDescriptor;", "loadByDescriptor", "Ljava/awt/Image;", "descriptor", "flags", "", "resourceClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "ioMissCache", "", "imageCache", "Lcom/intellij/util/ImageCache;", "ioMissCacheKey", "colorPatcher", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "loadByDescriptorWithoutCache", "loadPng", "Ljava/awt/image/BufferedImage;", "stream", "Ljava/io/InputStream;", "originalUserSize", "Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageLoader.kt\ncom/intellij/util/ImageLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,638:1\n10#2:639\n*S KotlinDebug\n*F\n+ 1 ImageLoader.kt\ncom/intellij/util/ImageLoaderKt\n*L\n54#1:639\n*E\n"})
public final class ImageLoaderKt {
    private static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty("ide.cached.image.max.size", 1.5f) * (float)1024 * (float)1024);

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImageLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        return logger;
    }

    public static final long getCACHED_IMAGE_MAX_SIZE() {
        return CACHED_IMAGE_MAX_SIZE;
    }

    private static final void addFileNameVariant(boolean retina, boolean isDark, boolean isStroke, boolean isSvg, String name, String ext, float scale, List<ImageDescriptor> list2) {
        List descriptors;
        float nonRetinaScale;
        String effectiveExt = isSvg ? "svg" : ext;
        float retinaScale = isSvg ? scale : 2.0f;
        float f = nonRetinaScale = isSvg ? scale : 1.0f;
        if (isStroke) {
            list2.add(new ImageDescriptor(name + "_stroke." + effectiveExt, retina ? retinaScale : nonRetinaScale, isSvg, false, true));
        }
        if (isDark) {
            var12_11 = new ImageDescriptor[]{new ImageDescriptor(name + "@2x_dark." + effectiveExt, retinaScale, isSvg, true, false), new ImageDescriptor(name + "_dark@2x." + effectiveExt, retinaScale, isSvg, true, false), new ImageDescriptor(name + "_dark." + effectiveExt, nonRetinaScale, isSvg, true, false)};
            v1 = CollectionsKt.mutableListOf((Object[])var12_11);
        } else {
            var12_11 = new ImageDescriptor[]{new ImageDescriptor(name + "@2x." + effectiveExt, retinaScale, isSvg, false, false), new ImageDescriptor(name + "." + effectiveExt, nonRetinaScale, isSvg, false, false)};
            v1 = descriptors = CollectionsKt.mutableListOf((Object[])var12_11);
        }
        if (!retina) {
            CollectionsKt.reverse((List)descriptors);
        }
        list2.addAll(descriptors);
    }

    private static final Image loadByDescriptor(ImageDescriptor descriptor2, int flags, Class<?> resourceClass, ClassLoader classLoader, Set<String> ioMissCache, ImageCache imageCache2, String ioMissCacheKey, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        Object subPatcher;
        CacheKey cacheKey = null;
        boolean tmpPatcher = false;
        byte[] digest = null;
        if (colorPatcher != null && (subPatcher = colorPatcher.forPath(descriptor2.path)) != null && (digest = subPatcher.digest()) == null) {
            tmpPatcher = true;
        }
        if (digest == null) {
            digest = SVGLoader.INSTANCE.getDEFAULT_THEME();
        }
        if ((flags & 2) == 2 && !tmpPatcher) {
            cacheKey = new CacheKey(descriptor2.path, descriptor2.isSvg ? descriptor2.scale : 0.0f, digest);
            Image image = (Image)imageCache2.imageCache.get(cacheKey);
            if (image == null) {
                image = (Image)imageCache2.largeImageCache.get(cacheKey);
            }
            if ((subPatcher = image) != null) {
                Object it = subPatcher;
                boolean bl = false;
                return it;
            }
        }
        if (ioMissCache != null && ioMissCache.contains(ioMissCacheKey)) {
            return null;
        }
        Image image = ImageLoaderKt.loadByDescriptorWithoutCache(descriptor2, resourceClass, classLoader, colorPatcher);
        if (image == null) {
            return null;
        }
        Image image2 = image;
        if (cacheKey != null) {
            if (4L * (long)image2.getWidth(null) * (long)image2.getHeight(null) <= CACHED_IMAGE_MAX_SIZE) {
                imageCache2.imageCache.put(cacheKey, image2);
            } else {
                imageCache2.largeImageCache.put(cacheKey, image2);
            }
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image loadByDescriptorWithoutCache(ImageDescriptor descriptor2, Class<?> resourceClass, ClassLoader classLoader, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        Image image = null;
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (resourceClass == null && (classLoader == null || URLUtil.containsScheme(descriptor2.path)) && !StringsKt.startsWith$default((String)descriptor2.path, (String)"file://", (boolean)false, (int)2, null)) {
            URLConnection connection = new URL(descriptor2.path).openConnection();
            HttpURLConnection httpURLConnection = connection instanceof HttpURLConnection ? (HttpURLConnection)connection : null;
            if (httpURLConnection != null) {
                httpURLConnection.addRequestProperty("User-Agent", "IntelliJ");
            }
            Closeable closeable = connection.getInputStream();
            Throwable throwable = null;
            try {
                Image image2;
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                if (descriptor2.isSvg) {
                    String string2 = descriptor2.path;
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                    image2 = SVGLoader.INSTANCE.load$intellij_platform_util_ui(string2, stream, descriptor2.toSvgMapper$intellij_platform_util_ui(), colorPatcher);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
                    image2 = ImageLoaderKt.loadPng(stream, descriptor2.scale, null);
                }
                image = image2;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromUrl.end(start);
            }
        } else {
            if (descriptor2.isSvg) {
                var7_7 = SVGLoader.INSTANCE;
                var8_9 = descriptor2.path;
                SvgCacheMapper svgCacheMapper = descriptor2.toSvgMapper$intellij_platform_util_ui();
                v3 = ((SVGLoader)var7_7).loadFromClassResource(classLoader, var8_9, 0, svgCacheMapper, colorPatcher, resourceClass);
            } else {
                var7_7 = ImageLoader.INSTANCE;
                var8_9 = descriptor2.path;
                float f = descriptor2.scale;
                v3 = image = ((ImageLoader)var7_7).loadPngFromClassResource(var8_9, classLoader, f, resourceClass);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BufferedImage loadPng(@NotNull InputStream stream, float scale, @Nullable ImageLoader.Dimension2DDouble originalUserSize) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        BufferedImage image = null;
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        try {
            Closeable closeable = new MemoryCacheImageInputStream(stream);
            Throwable throwable = null;
            try {
                MemoryCacheImageInputStream imageInputStream = (MemoryCacheImageInputStream)closeable;
                boolean bl = false;
                reader.setInput(imageInputStream, true, true);
                BufferedImage bufferedImage = reader.read(0, null);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"reader.read(0, null)");
                image = bufferedImage;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            reader.dispose();
        }
        ImageLoader.Dimension2DDouble dimension2DDouble = originalUserSize;
        if (dimension2DDouble != null) {
            dimension2DDouble.setSize((float)image.getWidth() / scale, (float)image.getHeight() / scale);
        }
        if (start != -1L) {
            IconLoadMeasurer.pngDecoding.end(start);
        }
        return image;
    }

    public static /* synthetic */ BufferedImage loadPng$default(InputStream inputStream, float f, ImageLoader.Dimension2DDouble dimension2DDouble, int n, Object object) {
        if ((n & 4) != 0) {
            dimension2DDouble = null;
        }
        return ImageLoaderKt.loadPng(inputStream, f, dimension2DDouble);
    }

    public static final /* synthetic */ Image access$loadByDescriptor(ImageDescriptor descriptor2, int flags, Class resourceClass, ClassLoader classLoader, Set ioMissCache, ImageCache imageCache2, String ioMissCacheKey, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        return ImageLoaderKt.loadByDescriptor(descriptor2, flags, resourceClass, classLoader, ioMissCache, imageCache2, ioMissCacheKey, colorPatcher);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ImageLoaderKt.getLOG();
    }

    public static final /* synthetic */ void access$addFileNameVariant(boolean retina, boolean isDark, boolean isStroke, boolean isSvg, String name, String ext, float scale, List list2) {
        ImageLoaderKt.addFileNameVariant(retina, isDark, isStroke, isSvg, name, ext, scale, list2);
    }
}

