/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.HiDPIScaledGraphics;
import com.intellij.util.ui.ImageUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBHiDPIScaledImage
extends BufferedImage {
    @Nullable
    private final Image myImage;
    private final double myUserWidth;
    private final double myUserHeight;
    private final double myScale;

    public JBHiDPIScaledImage(int width, int height, int type) {
        this((double)width, (double)height, type);
    }

    public JBHiDPIScaledImage(double width, double height, int type) {
        this((GraphicsConfiguration)null, width, height, type);
    }

    public JBHiDPIScaledImage(@Nullable Graphics2D g, int width, int height, int type) {
        this(g, (double)width, (double)height, type, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable Graphics2D g, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(0);
        }
        this(JBUIScale.sysScale(g), width, height, (int)type, (PaintUtil.RoundingMode)rm);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, int width, int height, int type) {
        this(gc, (double)width, (double)height, type);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable ScaleContext ctx, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(1);
        }
        this(JBUIScale.sysScale(ctx), width, height, (int)type, (PaintUtil.RoundingMode)rm);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int type) {
        this(gc, width, height, type, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(2);
        }
        this(JBUIScale.sysScale(gc), width, height, (int)type, (PaintUtil.RoundingMode)rm);
    }

    /*
     * WARNING - void declaration
     */
    private JBHiDPIScaledImage(double scale, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void type;
        void rm;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(3);
        }
        super(rm.round(width * scale), rm.round(height * scale), (int)type);
        this.myImage = null;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = scale;
    }

    public JBHiDPIScaledImage(@NotNull Image image, int width, int height, int type) {
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(4);
        }
        this(image, (double)width, (double)height, type);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@NotNull Image image, double width, double height, int n) {
        void type;
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(5);
        }
        super(1, 1, (int)type);
        this.myImage = image;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = this.myUserWidth > 0.0 ? (double)this.myImage.getWidth(null) / this.myUserWidth : 1.0;
    }

    public JBHiDPIScaledImage(@NotNull Image image, @NotNull ScaleContext ctx, int type) {
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(6);
        }
        if (ctx == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(7);
        }
        super(1, 1, type);
        this.myImage = image;
        this.myScale = ctx.getScale(ScaleType.SYS_SCALE);
        this.myUserWidth = (double)this.myImage.getWidth(null) / this.myScale;
        this.myUserHeight = (double)this.myImage.getHeight(null) / this.myScale;
    }

    public double getScale() {
        return this.myScale;
    }

    @NotNull
    public JBHiDPIScaledImage scale(double scaleFactor) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = (int)(scaleFactor * (double)this.getRealWidth(null));
        int h = (int)(scaleFactor * (double)this.getRealHeight(null));
        if (w <= 0 || h <= 0) {
            JBHiDPIScaledImage jBHiDPIScaledImage = this;
            if (jBHiDPIScaledImage == null) {
                JBHiDPIScaledImage.$$$reportNull$$$0(8);
            }
            return jBHiDPIScaledImage;
        }
        BufferedImage scaled = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (int)w, (int)h, (BufferedImageOp[])new BufferedImageOp[0]);
        double newUserWidth = (double)w / this.myScale;
        double newUserHeight = (double)h / this.myScale;
        if (this.myImage != null) {
            return new JBHiDPIScaledImage((Image)scaled, newUserWidth, newUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.myScale, newUserWidth, newUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, (int)Math.round(newUserWidth), (int)Math.round(newUserHeight), 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        JBHiDPIScaledImage jBHiDPIScaledImage = newImg;
        if (jBHiDPIScaledImage == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(9);
        }
        return jBHiDPIScaledImage;
    }

    @NotNull
    public JBHiDPIScaledImage scale(int targetUserWidth, int targetUserHeight) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = this.getUserWidth(null);
        int h = this.getUserHeight(null);
        if (w <= 0 || h <= 0 || w == targetUserWidth && h == targetUserHeight) {
            JBHiDPIScaledImage jBHiDPIScaledImage = this;
            if (jBHiDPIScaledImage == null) {
                JBHiDPIScaledImage.$$$reportNull$$$0(10);
            }
            return jBHiDPIScaledImage;
        }
        int targetWidth = (int)Math.round((double)targetUserWidth * this.myScale);
        int targetHeight = (int)Math.round((double)targetUserHeight * this.myScale);
        BufferedImage scaled = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        if (this.myImage != null) {
            return new JBHiDPIScaledImage((Image)scaled, targetUserWidth, targetUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.myScale, (double)targetUserWidth, (double)targetUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, targetUserWidth, targetUserHeight, 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        JBHiDPIScaledImage jBHiDPIScaledImage = newImg;
        if (jBHiDPIScaledImage == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(11);
        }
        return jBHiDPIScaledImage;
    }

    public Image getDelegate() {
        return this.myImage;
    }

    @Override
    public int getWidth() {
        return this.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.getHeight(null);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.myImage != null ? this.getUserWidth(observer) : this.getRealWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.myImage != null ? this.getUserHeight(observer) : this.getRealHeight(observer);
    }

    public int getUserWidth(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserWidth) : (int)Math.round((double)super.getWidth(observer) / this.myScale);
    }

    public int getUserHeight(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserHeight) : (int)Math.round((double)super.getHeight(observer) / this.myScale);
    }

    public int getRealWidth(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getWidth(observer) : super.getWidth(observer);
    }

    public int getRealHeight(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getHeight(observer) : super.getHeight(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (this.myImage == null) {
            g.scale(this.myScale, this.myScale);
            return new HiDPIScaledGraphics(g);
        }
        return g;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rm";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JBHiDPIScaledImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JBHiDPIScaledImage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9, 10, 11 -> new IllegalStateException(string2);
        };
    }
}

