/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LazyInitializer {
    private static final Object UNINITIALIZED_VALUE = new Object();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> LazyValue<T> create(@NotNull Supplier<? extends T> initializer2) {
        if (initializer2 == null) {
            LazyInitializer.$$$reportNull$$$0(0);
        }
        return new LazyValue<T>(initializer2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/util/LazyInitializer", "create"));
    }

    public static class LazyValue<T> {
        @NotNull
        private final Supplier<? extends T> initializer;
        private volatile T value;

        public LazyValue(@NotNull Supplier<? extends T> initializer2) {
            if (initializer2 == null) {
                LazyValue.$$$reportNull$$$0(0);
            }
            this.value = UNINITIALIZED_VALUE;
            this.initializer = initializer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            T v = this.value;
            if (v != UNINITIALIZED_VALUE) {
                return this.value;
            }
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                v = this.value;
                if (v != UNINITIALIZED_VALUE) {
                    return this.value;
                }
                this.value = v = this.initializer.get();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void set(T value) {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                this.value = value;
            }
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/util/LazyInitializer$LazyValue", "<init>"));
        }
    }
}

