/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatternUtil {
    private static final Logger LOG = Logger.getInstance(PatternUtil.class);
    public static final Pattern NOTHING = Pattern.compile("(a\\A)");
    private static final Map<String, String> ourEscapeRules = new LinkedHashMap<String, String>();

    @NotNull
    public static String convertToRegex(@NotNull String mask) {
        if (mask == null) {
            PatternUtil.$$$reportNull$$$0(0);
        }
        List<String> strings2 = StringUtil.split(mask, "\\");
        StringBuilder pattern = new StringBuilder();
        String separator = "";
        for (String string2 : strings2) {
            string2 = StringUtil.replace(string2, ".", "\\.");
            for (Map.Entry<String, String> e : ourEscapeRules.entrySet()) {
                string2 = StringUtil.replace(string2, e.getKey(), e.getValue());
            }
            pattern.append(separator);
            separator = "\\\\";
            pattern.append(string2);
        }
        String string3 = pattern.toString();
        if (string3 == null) {
            PatternUtil.$$$reportNull$$$0(1);
        }
        return string3;
    }

    @NotNull
    public static Pattern fromMask(@NotNull String mask) {
        Pattern pattern;
        if (mask == null) {
            PatternUtil.$$$reportNull$$$0(2);
        }
        try {
            pattern = Pattern.compile(PatternUtil.convertToRegex(mask));
        }
        catch (PatternSyntaxException e) {
            LOG.error(mask, e);
            Pattern pattern2 = NOTHING;
            if (pattern2 == null) {
                PatternUtil.$$$reportNull$$$0(4);
            }
            return pattern2;
        }
        if (pattern == null) {
            PatternUtil.$$$reportNull$$$0(3);
        }
        return pattern;
    }

    @Contract(value="_, !null->!null")
    public static Pattern compileSafe(String pattern, Pattern def) {
        try {
            return Pattern.compile(pattern);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Nullable
    public static String getFirstMatch(List<String> lines2, Pattern regex) {
        if (lines2 == null) {
            return null;
        }
        for (String s : lines2) {
            Matcher m = regex.matcher(s);
            if (!m.matches() || m.groupCount() <= 0) continue;
            return m.group(1);
        }
        return null;
    }

    static {
        ourEscapeRules.put("*", ".*");
        ourEscapeRules.put("?", ".");
        for (char c2 : "+()[]/^${}|".toCharArray()) {
            ourEscapeRules.put(String.valueOf(c2), "\\" + c2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mask";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PatternUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PatternUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRegex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToRegex";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromMask";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

