/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtilRt {
    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(0);
        }
        ArrayList<Field> result2 = new ArrayList<Field>();
        ReflectionUtilRt.collectFields(clazz, result2);
        ArrayList<Field> arrayList = result2;
        if (arrayList == null) {
            ReflectionUtilRt.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void collectFields(@NotNull Class<?> clazz, @NotNull List<? super Field> result2) {
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            ReflectionUtilRt.$$$reportNull$$$0(3);
        }
        result2.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtilRt.collectFields(superClass, result2);
        }
        for (Class<?> each : clazz.getInterfaces()) {
            ReflectionUtilRt.collectFields(each, result2);
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull String fieldName) {
        Field field;
        if (objectClass == null) {
            ReflectionUtilRt.$$$reportNull$$$0(4);
        }
        if (fieldName == null) {
            ReflectionUtilRt.$$$reportNull$$$0(5);
        }
        if ((field = ReflectionUtilRt.findField(objectClass, fieldName, fieldType)) != null) {
            try {
                return (T)field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field findField(@NotNull Class<?> clazz, @NotNull String fieldName, @Nullable Class<?> fieldType) {
        Field result2;
        if (clazz == null) {
            ReflectionUtilRt.$$$reportNull$$$0(6);
        }
        if (fieldName == null) {
            ReflectionUtilRt.$$$reportNull$$$0(7);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName()) || fieldType != null && !fieldType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (result2 = ReflectionUtilRt.findField(superClass, fieldName, fieldType)) != null) {
            return result2;
        }
        for (Class<?> each : clazz.getInterfaces()) {
            Field result3 = ReflectionUtilRt.findField(each, fieldName, fieldType);
            if (result3 == null) continue;
            return result3;
        }
        return null;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LoggerRt.getInstance(ReflectionUtilRt.class).warn(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ReflectionUtilRt";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 1: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

