/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgCacheMapper;
import com.intellij.ui.svg.SvgDocumentFactoryKt;
import com.intellij.ui.svg.SvgTranscoder;
import com.intellij.util.SVGLoader;
import com.intellij.util.SvgCache;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.transcoder.TranscoderException;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002\u001a6\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002\u001a$\u0010\u0013\u001a\u00020\u00142\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"USE_CACHE", "", "selectionColorPatcher", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "createDocument", "Lorg/apache/batik/anim/dom/SVGOMDocument;", "url", "", "inputStream", "Ljava/io/InputStream;", "data", "", "colorPatcher", "loadAndCache", "Ljava/awt/image/BufferedImage;", "path", "mapper", "Lcom/intellij/ui/svg/SvgCacheMapper;", "themeDigest", "patchColors", "", "document", "Lorg/w3c/dom/Document;", "toCanonicalColor", "color", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nSVGLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGLoader.kt\ncom/intellij/util/SVGLoaderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,442:1\n10#2:443\n*S KotlinDebug\n*F\n+ 1 SVGLoader.kt\ncom/intellij/util/SVGLoaderKt\n*L\n401#1:443\n*E\n"})
public final class SVGLoaderKt {
    private static final boolean USE_CACHE = Boolean.parseBoolean(System.getProperty("idea.ui.icons.svg.disk.cache", "true"));
    @Nullable
    private static SVGLoader.SvgElementColorPatcherProvider selectionColorPatcher;

    private static final String toCanonicalColor(String color) {
        String string2 = color.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Object s = string2;
        if (StringsKt.startsWith$default((String)s, (String)"#", (boolean)false, (int)2, null) && ((String)s).length() < 7) {
            s = "#" + ColorUtil.toHex(ColorUtil.fromHex((String)s));
        }
        return s;
    }

    private static final SVGOMDocument createDocument(String url, InputStream inputStream) {
        SVGOMDocument document = SvgDocumentFactoryKt.createSvgDocument(inputStream, url);
        SVGLoaderKt.patchColors(url, (Document)document, null);
        return document;
    }

    private static final void patchColors(String url, Document document, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        block0: {
            Object object = colorPatcher;
            if (object == null || (object = object.forPath(url)) == null) break block0;
            Element element = document.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.documentElement");
            object.patchColors(element);
        }
    }

    private static final SVGOMDocument createDocument(String url, byte[] data2, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        SVGOMDocument document = SvgDocumentFactoryKt.createSvgDocument(data2, url);
        SVGLoaderKt.patchColors(url, (Document)document, colorPatcher);
        return document;
    }

    private static final BufferedImage loadAndCache(String path2, byte[] data2, SvgCacheMapper mapper, byte[] themeDigest, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        BufferedImage bufferedImage;
        long decodingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        try {
            bufferedImage = SvgTranscoder.Companion.createImage$default(SvgTranscoder.Companion, mapper.scale, SVGLoaderKt.createDocument(path2, data2, colorPatcher), 0.0f, 0.0f, 12, null);
        }
        catch (TranscoderException e) {
            throw new IOException(e);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (decodingStart != -1L) {
            IconLoadMeasurer.svgDecoding.end(decodingStart);
        }
        if (themeDigest != null) {
            try {
                long cacheWriteStart = StartUpMeasurer.getCurrentTimeIfEnabled();
                SvgCacheManager svgCacheManager = SvgCache.INSTANCE.getPersistentCache();
                if (svgCacheManager != null) {
                    svgCacheManager.storeLoadedImage(themeDigest, data2, mapper, bufferedImage2);
                }
                IconLoadMeasurer.svgCacheWrite.end(cacheWriteStart);
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SVGLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Failed to write SVG cache for: " + path2, e);
            }
        }
        return bufferedImage2;
    }

    public static final /* synthetic */ BufferedImage access$loadAndCache(String path2, byte[] data2, SvgCacheMapper mapper, byte[] themeDigest, SVGLoader.SvgElementColorPatcherProvider colorPatcher) {
        return SVGLoaderKt.loadAndCache(path2, data2, mapper, themeDigest, colorPatcher);
    }

    public static final /* synthetic */ SVGOMDocument access$createDocument(String url, InputStream inputStream) {
        return SVGLoaderKt.createDocument(url, inputStream);
    }

    public static final /* synthetic */ String access$toCanonicalColor(String color) {
        return SVGLoaderKt.toCanonicalColor(color);
    }

    public static final /* synthetic */ void access$setSelectionColorPatcher$p(SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider) {
        selectionColorPatcher = svgElementColorPatcherProvider;
    }

    public static final /* synthetic */ SVGLoader.SvgElementColorPatcherProvider access$getSelectionColorPatcher$p() {
        return selectionColorPatcher;
    }

    public static final /* synthetic */ boolean access$getUSE_CACHE$p() {
        return USE_CACHE;
    }
}

