/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgPrebuiltCacheManager;
import com.intellij.util.SVGLoader;
import com.intellij.util.SVGLoaderKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/util/SvgCache;", "", "()V", "persistentCache", "Lcom/intellij/ui/svg/SvgCacheManager;", "getPersistentCache", "()Lcom/intellij/ui/svg/SvgCacheManager;", "prebuiltPersistentCache", "Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;", "getPrebuiltPersistentCache", "()Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nSVGLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SVGLoader.kt\ncom/intellij/util/SvgCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,442:1\n10#2:443\n10#2:444\n*S KotlinDebug\n*F\n+ 1 SVGLoader.kt\ncom/intellij/util/SvgCache\n*L\n428#1:443\n438#1:444\n*E\n"})
final class SvgCache {
    @NotNull
    public static final SvgCache INSTANCE;
    @Nullable
    private static final SvgCacheManager persistentCache;
    @Nullable
    private static final SvgPrebuiltCacheManager prebuiltPersistentCache;

    private SvgCache() {
    }

    @Nullable
    public final SvgCacheManager getPersistentCache() {
        return persistentCache;
    }

    @Nullable
    public final SvgPrebuiltCacheManager getPrebuiltPersistentCache() {
        return prebuiltPersistentCache;
    }

    static {
        SvgCacheManager svgCacheManager;
        INSTANCE = new SvgCache();
        SvgPrebuiltCacheManager prebuiltCache = null;
        if (SVGLoaderKt.access$getUSE_CACHE$p()) {
            try {
                Path dbDir = null;
                String dbPath = System.getProperty("idea.ui.icons.prebuilt.db");
                if (!Intrinsics.areEqual((Object)dbPath, (Object)"false")) {
                    dbDir = dbPath == null || ((CharSequence)dbPath).length() == 0 ? Path.of(PathManager.getBinPath() + "/icons", new String[0]) : Path.of(dbPath, new String[0]);
                }
                prebuiltCache = dbDir != null && Files.isDirectory(dbDir, new LinkOption[0]) ? new SvgPrebuiltCacheManager(dbDir) : null;
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SVGLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Cannot use prebuilt svg cache", e);
                prebuiltCache = null;
            }
        }
        prebuiltPersistentCache = prebuiltCache;
        try {
            SvgCacheManager svgCacheManager2;
            if (SVGLoaderKt.access$getUSE_CACHE$p()) {
                String[] $i$f$logger = new String[]{"icon-v7.db"};
                Path path2 = Path.of(PathManager.getSystemPath(), $i$f$logger);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(PathManager.getSystemPath(), \"icon-v7.db\")");
                svgCacheManager2 = new SvgCacheManager(path2);
            } else {
                svgCacheManager2 = null;
            }
            svgCacheManager = svgCacheManager2;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SVGLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.error(e);
            svgCacheManager = null;
        }
        persistentCache = svgCacheManager;
    }
}

