/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenterEx;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class CommentUtilCore {
    public static boolean isComment(@Nullable PsiElement element) {
        return element != null && CommentUtilCore.isComment(element.getNode());
    }

    public static boolean isComment(@Nullable ASTNode node2) {
        if (node2 == null) {
            return false;
        }
        IElementType type = node2.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage());
        return parserDefinition != null && parserDefinition.getCommentTokens().contains(type);
    }

    public static boolean isCommentTextElement(PsiElement element) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(element.getLanguage());
        if (commenter instanceof CodeDocumentationAwareCommenterEx) {
            CodeDocumentationAwareCommenterEx commenterEx = (CodeDocumentationAwareCommenterEx)commenter;
            if (commenterEx.isDocumentationCommentText(element)) {
                return true;
            }
            if (element instanceof PsiComment && commenterEx.isDocumentationComment((PsiComment)element)) {
                return false;
            }
        }
        return CommentUtilCore.isComment(element);
    }
}

