/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

@Deprecated
public final class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public T removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        T result2 = this.getRaw(this.myLast);
        this.myArray[this.myLast] = null;
        return result2;
    }

    private T getRaw(int last2) {
        return (T)this.myArray[last2];
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        return this.getRaw(this.myFirst);
    }

    private int copyFromTo(int first2, int last2, Object[] result2, int destinationPos) {
        int length = last2 - first2;
        System.arraycopy(this.myArray, first2, result2, destinationPos, length);
        return length;
    }

    private T @NotNull [] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        return this.normalize(result2);
    }

    private T @NotNull [] normalize(T[] result2) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        if (result2 == null) {
            Queue.$$$reportNull$$$0(0);
        }
        return result2;
    }

    public void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    public boolean process(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            Queue.$$$reportNull$$$0(1);
        }
        if (this.isWrapped) {
            T t;
            int i2;
            for (i2 = this.myFirst; i2 < this.myArray.length; ++i2) {
                t = this.getRaw(i2);
                if (processor.process(t)) continue;
                return false;
            }
            for (i2 = 0; i2 < this.myLast; ++i2) {
                t = this.getRaw(i2);
                if (processor.process(t)) continue;
                return false;
            }
        } else {
            for (int i3 = this.myFirst; i3 < this.myLast; ++i3) {
                T t = this.getRaw(i3);
                if (processor.process(t)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        return this.isWrapped ? "[ " + this.sub(this.myFirst, this.myArray.length) + " ||| " + this.sub(0, this.myLast) + " ]" : "[ " + this.sub(this.myFirst, this.myLast) + " ]";
    }

    private Object sub(int start, int end) {
        if (start == end) {
            return "";
        }
        return Arrays.asList(this.myArray).subList(start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/Queue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/Queue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

