/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SortedList<T>
extends AbstractList<T> {
    private final SortedMap<T, List<T>> myMap;
    private final Comparator<? super T> myComparator;
    private List<T> myDelegate;

    public SortedList(@NotNull Comparator<? super T> comparator) {
        if (comparator == null) {
            SortedList.$$$reportNull$$$0(0);
        }
        this.myComparator = comparator;
        this.myMap = new TreeMap<T, List<T>>(comparator);
    }

    @NotNull
    public Comparator<? super T> getComparator() {
        Comparator<? super T> comparator = this.myComparator;
        if (comparator == null) {
            SortedList.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    @Override
    public void add(int index2, T element) {
        this.addToMap(element);
    }

    private void addToMap(T element) {
        SmartList<T> group2 = (SmartList<T>)this.myMap.get(element);
        if (group2 == null) {
            group2 = new SmartList<T>();
            this.myMap.put(element, group2);
        }
        group2.add(element);
        this.myDelegate = null;
    }

    @Override
    public boolean add(T t) {
        this.addToMap(t);
        return true;
    }

    @Override
    public T remove(int index2) {
        T value = this.get(index2);
        this.remove(value);
        return value;
    }

    @Override
    public boolean remove(Object value) {
        List group2 = (List)this.myMap.remove(value);
        if (group2 == null) {
            return false;
        }
        group2.remove(value);
        if (!group2.isEmpty()) {
            this.myMap.put(group2.get(0), group2);
        }
        this.myDelegate = null;
        return true;
    }

    @Override
    public T get(int index2) {
        return this.ensureLinearized().get(index2);
    }

    @NotNull
    private List<T> ensureLinearized() {
        List<T> delegate2 = this.myDelegate;
        if (delegate2 == null) {
            this.myDelegate = delegate2 = ContainerUtil.concat(this.myMap.values());
        }
        List<T> list2 = delegate2;
        if (list2 == null) {
            SortedList.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.myDelegate = null;
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public int size() {
        return this.ensureLinearized().size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/SortedList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/SortedList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureLinearized";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

