/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GistManagerImpl
extends GistManager {
    private static final Logger LOG = Logger.getInstance(GistManagerImpl.class);
    private static final Map<String, VirtualFileGist<?>> ourGists = ContainerUtil.createConcurrentWeakValueMap();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private static final Key<AtomicInteger> GIST_INVALIDATION_COUNT_KEY = Key.create("virtual.file.gist.invalidation.count");
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));
    private final MergingUpdateQueue myDropCachesQueue = new MergingUpdateQueue("gist-manager-drop-caches", 500, true, null).setRestartTimerOnAdd(true);
    private final AtomicInteger myMergingDropCachesRequestors = new AtomicInteger();

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (id == null) {
            GistManagerImpl.$$$reportNull$$$0(0);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(1);
        }
        if (calcData == null) {
            GistManagerImpl.$$$reportNull$$$0(2);
        }
        if (ourGists.get(id) != null) {
            throw new IllegalArgumentException("Gist '" + id + "' is already registered");
        }
        VirtualFileGist virtualFileGist = ourGists.computeIfAbsent(id, __ -> new VirtualFileGistImpl(id, version, externalizer, calcData));
        if (virtualFileGist == null) {
            GistManagerImpl.$$$reportNull$$$0(3);
        }
        return virtualFileGist;
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<? super PsiFile, ? extends Data> calculator) {
        if (id == null) {
            GistManagerImpl.$$$reportNull$$$0(4);
        }
        if (externalizer == null) {
            GistManagerImpl.$$$reportNull$$$0(5);
        }
        if (calculator == null) {
            GistManagerImpl.$$$reportNull$$$0(6);
        }
        return new PsiFileGistImpl<Data>(id, version, externalizer, calculator);
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        this.invalidateGists();
        this.invalidateDependentCaches();
    }

    public void invalidateData(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GistManagerImpl.$$$reportNull$$$0(7);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invalidating gist " + file2);
        }
        file2.putUserDataIfAbsent(GIST_INVALIDATION_COUNT_KEY, new AtomicInteger()).incrementAndGet();
        this.invalidateDependentCaches();
    }

    private void invalidateGists() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("Invalidating gists"));
        }
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    private void invalidateDependentCaches() {
        Runnable dropCaches = () -> {
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                PsiManager.getInstance(project2).dropPsiCaches();
            }
        };
        if (this.myMergingDropCachesRequestors.get() == 0) {
            ModalityUiUtil.invokeLaterIfNeeded(ModalityState.NON_MODAL, dropCaches);
        } else {
            this.myDropCachesQueue.queue(Update.create((Object)((Object)this), (Runnable)dropCaches));
        }
    }

    public void runWithMergingDependentCacheInvalidations(@NotNull Runnable runnable) {
        if (runnable == null) {
            GistManagerImpl.$$$reportNull$$$0(8);
        }
        this.myMergingDropCachesRequestors.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            if (this.myMergingDropCachesRequestors.decrementAndGet() == 0) {
                this.myDropCachesQueue.sendFlush();
            }
        }
    }

    public static int getGistStamp(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GistManagerImpl.$$$reportNull$$$0(9);
        }
        AtomicInteger invalidationCount = file2.getUserData(GIST_INVALIDATION_COUNT_KEY);
        return Objects.hash(file2.getModificationCount(), ((GistManagerImpl)GistManagerImpl.getInstance()).getReindexCount(), invalidationCount != null ? invalidationCount.get() : 0);
    }

    @TestOnly
    public void clearQueueInTests() {
        this.myDropCachesQueue.cancelAllUpdates();
    }

    @TestOnly
    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calcData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/gist/GistManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newVirtualFileGist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newVirtualFileGist";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newPsiFileGist";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidateData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runWithMergingDependentCacheInvalidations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGistStamp";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }

    static final class MyBulkFileListener
    implements BulkFileListener {
        MyBulkFileListener() {
        }

        @Override
        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyBulkFileListener.$$$reportNull$$$0(0);
            }
            if (events.stream().anyMatch(MyBulkFileListener::shouldDropCache)) {
                ((GistManagerImpl)GistManager.getInstance()).invalidateGists();
            }
        }

        private static boolean shouldDropCache(VFileEvent e) {
            if (!(e instanceof VFilePropertyChangeEvent)) {
                return false;
            }
            String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
            return propertyName.equals("name") || propertyName.equals("encoding");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/gist/GistManagerImpl$MyBulkFileListener", "after"));
        }
    }
}

