/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.graph.Graph;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ShortestPathFinder<Node> {
    private final InboundSemiGraph<Node> myGraph;

    public ShortestPathFinder(Graph<Node> graph2) {
        this.myGraph = graph2;
    }

    public ShortestPathFinder(InboundSemiGraph<Node> graph2) {
        this.myGraph = graph2;
    }

    @Nullable
    public List<Node> findPath(Node start, Node finish) {
        HashMap nextNodes = new HashMap();
        ArrayDeque<Node> queue2 = new ArrayDeque<Node>();
        queue2.addLast(finish);
        boolean found2 = false;
        while (!queue2.isEmpty()) {
            Object node2 = queue2.removeFirst();
            if (node2.equals(start)) {
                found2 = true;
                break;
            }
            Iterator<Node> in = this.myGraph.getIn(node2);
            while (in.hasNext()) {
                Node prev = in.next();
                if (nextNodes.containsKey(prev)) continue;
                nextNodes.put(prev, node2);
                queue2.addLast(prev);
            }
        }
        if (!found2) {
            return null;
        }
        ArrayList<Node> path2 = new ArrayList<Node>();
        Object current = start;
        while (!current.equals(finish)) {
            path2.add(current);
            current = nextNodes.get(current);
        }
        path2.add(finish);
        return path2;
    }
}

