/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.io.PathKt;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u000eH\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "EXPLICIT_INVALIDATION_REASON", "FORCE_REBUILD_REASON", "MARKED_AS_DIRTY_REASON", "corruptionMarker", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCorruptionMarker", "()Ljava/nio/file/Path;", "createCorruptionMarker", "", "reason", "dropIndexes", "markIndexesAsClosed", "markIndexesAsDirty", "requestInvalidation", "requireInvalidation", "", "intellij.platform.lang.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCorruptionMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorruptionMarker.kt\ncom/intellij/util/indexing/CorruptionMarker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 path.kt\ncom/intellij/util/io/PathKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n11653#2,9:109\n13579#2:118\n13580#2:120\n11662#2:121\n13579#2,2:129\n1#3:119\n206#4,2:122\n209#4,3:126\n1855#5,2:124\n*S KotlinDebug\n*F\n+ 1 CorruptionMarker.kt\ncom/intellij/util/indexing/CorruptionMarker\n*L\n74#1:109,9\n74#1:118\n74#1:120\n74#1:121\n96#1:129,2\n74#1:119\n75#1:122,2\n75#1:126,3\n76#1:124,2\n*E\n"})
public final class CorruptionMarker {
    @NotNull
    public static final CorruptionMarker INSTANCE = new CorruptionMarker();
    @NotNull
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    @NotNull
    private static final String MARKED_AS_DIRTY_REASON = "Indexes marked as dirty (IDE is expected to be work)";
    @NotNull
    private static final String FORCE_REBUILD_REASON = "Indexes were forcibly marked as corrupted";
    @NotNull
    private static final String EXPLICIT_INVALIDATION_REASON = "Explicit index invalidation";

    private CorruptionMarker() {
    }

    private final Path getCorruptionMarker() {
        return PathManager.getIndexRoot().resolve(CORRUPTION_MARKER_NAME);
    }

    @JvmStatic
    public static final void markIndexesAsDirty() {
        INSTANCE.createCorruptionMarker(MARKED_AS_DIRTY_REASON);
    }

    @JvmStatic
    public static final void markIndexesAsClosed() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean corruptionMarkerExists = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (corruptionMarkerExists) {
            try {
                path3 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"corruptionMarker");
                if (Intrinsics.areEqual((Object)PathKt.readText(path3), (Object)MARKED_AS_DIRTY_REASON)) {
                    Path path4 = INSTANCE.getCorruptionMarker();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"corruptionMarker");
                    path3 = path4;
                    Files.delete(path3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @JvmStatic
    public static final void requestInvalidation() {
        FileBasedIndexImpl.LOG.info("Explicit index invalidation has been requested");
        INSTANCE.createCorruptionMarker(EXPLICIT_INVALIDATION_REASON);
    }

    @JvmStatic
    public static final boolean requireInvalidation() {
        Path path2 = INSTANCE.getCorruptionMarker();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean corruptionMarkerExists = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (corruptionMarkerExists) {
            String message = "Indexes are corrupted and will be rebuilt";
            try {
                Path path4 = INSTANCE.getCorruptionMarker();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"corruptionMarker");
                String corruptionReason = PathKt.readText(path4);
                FileBasedIndexImpl.LOG.info(message + " (reason = " + corruptionReason + ")");
            }
            catch (Exception e) {
                FileBasedIndexImpl.LOG.info(message);
            }
        }
        return IndexInfrastructure.hasIndices() && corruptionMarkerExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void dropIndexes() {
        FileBasedIndexImpl.LOG.info("Indexes are dropped");
        Path path2 = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getIndexRoot()");
        Path indexRoot = path2;
        if (Files.exists(indexRoot, new LinkOption[0])) {
            void $this$mapNotNullTo$iv$iv;
            T[] $this$mapNotNull$iv = FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions();
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                boolean bl = false;
                FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv$iv;
                boolean bl2 = false;
                if (it.getPersistentStateRoot() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Set filesToBeIgnored = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            Path $this$directoryStreamIfExists$iv = indexRoot;
            boolean $i$f$directoryStreamIfExists = false;
            try {
                object = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                destination$iv$iv = null;
                try {
                    DirectoryStream dirStream = (DirectoryStream)object;
                    boolean bl = false;
                    Iterable $this$forEach$iv = dirStream;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it = (Path)element$iv;
                        boolean bl4 = false;
                        if (filesToBeIgnored.contains(((Object)it.getFileName()).toString())) continue;
                        FileUtil.deleteWithRenaming(it.toFile());
                    }
                    dirStream = Unit.INSTANCE;
                }
                catch (Throwable dirStream) {
                    destination$iv$iv = dirStream;
                    throw dirStream;
                }
                finally {
                    CloseableKt.closeFinally(object, (Throwable)destination$iv$iv);
                }
            }
            catch (NoSuchFileException noSuchFileException) {
            }
        } else {
            Files.createDirectories(indexRoot, new FileAttribute[0]);
        }
        if (SystemProperties.getBooleanProperty("idea.index.clear.diagnostic.on.invalidation", true)) {
            IndexDiagnosticDumper.Companion.clearDiagnostic();
        }
        SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
        ID.reinitializeDiskStorage();
        PersistentIndicesConfiguration.saveConfiguration();
        FileUtil.delete(INSTANCE.getCorruptionMarker());
        T[] $this$forEach$iv = FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileBasedIndexInfrastructureExtension it = (FileBasedIndexInfrastructureExtension)element$iv;
            boolean bl = false;
            it.resetPersistentState();
        }
        FileBasedIndexLayoutSettings.INSTANCE.saveCurrentLayout();
    }

    private final void createCorruptionMarker(String reason) {
        try {
            Path path2 = this.getCorruptionMarker();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"corruptionMarker");
            PathKt.write$default(path2, reason, null, false, 6, null);
        }
        catch (Exception e) {
            FileBasedIndexImpl.LOG.warn(e);
        }
    }
}

